/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class AssemblerConfiguration
extends BasicCompilerConfiguration
implements AllOptionsProvider,
ConfigurationBase {
    public AssemblerConfiguration(String string, AssemblerConfiguration assemblerConfiguration) {
        super(string, assemblerConfiguration);
    }

    public void assign(AssemblerConfiguration assemblerConfiguration) {
        super.assign(assemblerConfiguration);
    }

    public AssemblerConfiguration clone() {
        AssemblerConfiguration assemblerConfiguration = new AssemblerConfiguration(this.getBaseDir(), (AssemblerConfiguration)this.getMaster());
        assemblerConfiguration.setDevelopmentMode(this.getDevelopmentMode().clone());
        assemblerConfiguration.setWarningLevel(this.getWarningLevel().clone());
        assemblerConfiguration.setSixtyfourBits(this.getSixtyfourBits().clone());
        assemblerConfiguration.setStrip(this.getStrip().clone());
        assemblerConfiguration.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        assemblerConfiguration.setTool(this.getTool().clone());
        assemblerConfiguration.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        return assemblerConfiguration;
    }

    public String getOptions(BasicCompiler basicCompiler) {
        String string = "$(AS) $(ASFLAGS) ";
        string = string + this.getAllOptions2(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAsFlagsBasic(BasicCompiler basicCompiler) {
        String string = "";
        string = string + basicCompiler.getStripOption(this.getStrip().getValue()) + " ";
        string = string + basicCompiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            string = string + basicCompiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAsFlags(BasicCompiler basicCompiler) {
        String string = this.getAsFlagsBasic(basicCompiler) + " ";
        string = string + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions(BasicCompiler basicCompiler) {
        AssemblerConfiguration assemblerConfiguration = (AssemblerConfiguration)this.getMaster();
        String string = "";
        string = string + this.getAsFlagsBasic(basicCompiler) + " ";
        if (assemblerConfiguration != null) {
            string = string + assemblerConfiguration.getCommandLineConfiguration().getValue() + " ";
        }
        string = string + this.getAllOptions2(basicCompiler) + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getAllOptions2(BasicCompiler basicCompiler) {
        String string = "";
        string = string + basicCompiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        string = string + basicCompiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public Sheet getGeneralSheet(MakeConfiguration makeConfiguration) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        BasicCompiler basicCompiler = compilerSet == null ? null : (BasicCompiler)compilerSet.getTool(4);
        Sheet.Set set = this.getBasicSet();
        set.remove("StripSymbols");
        sheet.put(set);
        if (this.getMaster() != null) {
            sheet.put(this.getInputSet());
        }
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("Tool");
        set2.setDisplayName(AssemblerConfiguration.getString("ToolTxt1"));
        set2.setShortDescription(AssemblerConfiguration.getString("ToolHint1"));
        if (basicCompiler != null) {
            set2.put((Node.Property)new StringNodeProp(this.getTool(), basicCompiler.getName(), false, "Tool", AssemblerConfiguration.getString("ToolTxt2"), AssemblerConfiguration.getString("ToolHint2")));
        }
        sheet.put(set2);
        String[] stringArray = new String[]{AssemblerConfiguration.getString("AdditionalOptionsTxt1"), AssemblerConfiguration.getString("AdditionalOptionsHint"), AssemblerConfiguration.getString("AdditionalOptionsTxt2"), AssemblerConfiguration.getString("AllOptionsTxt")};
        Sheet.Set set3 = new Sheet.Set();
        set3.setName("CommandLine");
        set3.setDisplayName(AssemblerConfiguration.getString("CommandLineTxt"));
        set3.setShortDescription(AssemblerConfiguration.getString("CommandLineHint"));
        if (basicCompiler != null) {
            set3.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, basicCompiler, null, stringArray));
        }
        sheet.put(set3);
        return sheet;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(AssemblerConfiguration.class, (String)string);
    }
}

