/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

public class IntConfiguration {
    private IntConfiguration master;
    private int def;
    private String[] names;
    private String[] options;
    private int value;
    private boolean modified;
    private boolean dirty = false;

    public IntConfiguration(IntConfiguration intConfiguration, int n, String[] stringArray, String[] stringArray2) {
        this.master = intConfiguration;
        this.def = n;
        this.names = stringArray;
        this.options = stringArray2;
        this.reset();
    }

    protected IntConfiguration() {
    }

    public void setMaster(IntConfiguration intConfiguration) {
        this.master = intConfiguration;
    }

    public void setValue(int n) {
        this.value = n;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(n != this.getDefault());
        }
    }

    public void setValue(String string) {
        if (string != null) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!string.equals(this.names[i])) continue;
                this.setValue(i);
                break;
            }
        }
    }

    public int getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public int getDefault() {
        return this.def;
    }

    public void setDefault(int n) {
        this.def = n;
        this.setModified(this.value != this.getDefault());
    }

    public void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public String getName() {
        if (this.getValue() < this.names.length) {
            return this.names[this.getValue()];
        }
        return "???";
    }

    public String[] getNames() {
        return this.names;
    }

    public String getOption() {
        return this.options[this.getValue()] + " ";
    }

    public void assign(IntConfiguration intConfiguration) {
        this.dirty = this.getValue() != intConfiguration.getValue();
        this.setValue(intConfiguration.getValue());
        this.setModified(intConfiguration.getModified());
    }

    public IntConfiguration clone() {
        IntConfiguration intConfiguration = new IntConfiguration(this.master, this.def, this.names, this.options);
        intConfiguration.setValue(this.getValue());
        intConfiguration.setModified(this.getModified());
        return intConfiguration;
    }
}

