/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QmakeProjectWriter {
    private static final String PROJECT_PREFIX = "nbproject" + File.separator + "qt-";
    private static final String PROJECT_SUFFIX = ".pro";
    private final MakeConfigurationDescriptor projectDescriptor;
    private final MakeConfiguration configuration;

    public QmakeProjectWriter(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        this.projectDescriptor = makeConfigurationDescriptor;
        this.configuration = makeConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.configuration.isQmakeConfiguration()) {
            File file = new File(this.configuration.getBaseDir(), PROJECT_PREFIX + this.configuration.getName() + PROJECT_SUFFIX);
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                this.write(bufferedWriter);
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
    }

    private void write(BufferedWriter bufferedWriter) throws IOException {
        this.write(bufferedWriter, Variable.TEMPLATE, Operation.SET, this.getTemplate());
        this.write(bufferedWriter, Variable.DESTDIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getDestdirValue()));
        this.write(bufferedWriter, Variable.TARGET, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getTargetValue()));
        this.write(bufferedWriter, Variable.VERSION, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getVersion().getValue()));
        this.write(bufferedWriter, Variable.CONFIG, Operation.SUB, "debug_and_release app_bundle lib_bundle");
        this.write(bufferedWriter, Variable.CONFIG, Operation.ADD, this.getConfig());
        this.write(bufferedWriter, Variable.QT, Operation.SET, this.configuration.getQmakeConfiguration().getEnabledModules());
        Item[] itemArray = this.projectDescriptor.getProjectItems();
        this.write(bufferedWriter, Variable.SOURCES, Operation.ADD, this.getItems(itemArray, "text/x-c", "text/x-c++"));
        this.write(bufferedWriter, Variable.HEADERS, Operation.ADD, this.getItems(itemArray, "text/x-h"));
        this.write(bufferedWriter, Variable.FORMS, Operation.ADD, this.getItems(itemArray, "text/qtui+xml"));
        this.write(bufferedWriter, Variable.RESOURCES, Operation.ADD, this.getItems(itemArray, "text/qtresource+xml"));
        this.write(bufferedWriter, Variable.TRANSLATIONS, Operation.ADD, this.getItems(itemArray, "text/qttranslation+xml"));
        this.write(bufferedWriter, Variable.OBJECTS_DIR, Operation.SET, this.expandAndQuote(ConfigurationMakefileWriter.getObjectDir(this.configuration)));
        this.write(bufferedWriter, Variable.MOC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getMocDir().getValue()));
        this.write(bufferedWriter, Variable.RCC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getRccDir().getValue()));
        this.write(bufferedWriter, Variable.UI_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getUiDir().getValue()));
        this.write(bufferedWriter, Variable.QMAKE_CC, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, 0));
        this.write(bufferedWriter, Variable.QMAKE_CXX, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, 1));
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        CCCCompilerConfiguration.OptionToString optionToString = new CCCCompilerConfiguration.OptionToString(compilerSet, null);
        this.write(bufferedWriter, Variable.DEFINES, Operation.ADD, this.configuration.getCCCompilerConfiguration().getPreprocessorConfiguration().toString(optionToString));
        IncludeToString includeToString = new IncludeToString(compilerSet);
        this.write(bufferedWriter, Variable.INCLUDEPATH, Operation.ADD, this.configuration.getCCCompilerConfiguration().getIncludeDirectories().toString(includeToString));
        this.write(bufferedWriter, Variable.LIBS, Operation.ADD, this.getLibs());
        for (String string : this.configuration.getQmakeConfiguration().getCustomDefs().getValue()) {
            bufferedWriter.write(string);
            bufferedWriter.write(10);
        }
    }

    private void write(BufferedWriter bufferedWriter, Variable variable, Operation operation, String string) throws IOException {
        bufferedWriter.write(variable.toString());
        bufferedWriter.write(32);
        bufferedWriter.write(operation.getOp());
        bufferedWriter.write(32);
        bufferedWriter.write(string);
        bufferedWriter.write(10);
    }

    private void write(BufferedWriter bufferedWriter, Variable variable, Operation operation, List<String> list) throws IOException {
        bufferedWriter.write(variable.toString());
        bufferedWriter.write(32);
        bufferedWriter.write(operation.getOp());
        for (String string : list) {
            bufferedWriter.write(32);
            bufferedWriter.write(string);
        }
        bufferedWriter.write(10);
    }

    private List<String> getItems(Item[] itemArray, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (Item item : itemArray) {
            FileObject fileObject;
            ItemConfiguration itemConfiguration = item.getItemConfiguration(this.configuration);
            if (itemConfiguration.getExcluded().getValue() || (fileObject = item.getFileObject()) == null) continue;
            String string = fileObject.getMIMEType();
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                arrayList.add(IpeUtils.quoteIfNecessary((String)item.getPath()));
                continue block0;
            }
        }
        return arrayList;
    }

    private String getTemplate() {
        switch (this.configuration.getConfigurationType().getValue()) {
            case 4: {
                return "app";
            }
            case 5: 
            case 6: {
                return "lib";
            }
        }
        return "";
    }

    private List<String> getConfig() {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.configuration.getConfigurationType().getValue()) {
            case 5: {
                arrayList.add("dll");
                break;
            }
            case 6: {
                arrayList.add("staticlib");
            }
        }
        arrayList.add(this.configuration.getQmakeConfiguration().getBuildMode().getOption());
        return arrayList;
    }

    private String getLibs() {
        StringBuilder stringBuilder = new StringBuilder();
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        LibraryToString libraryToString = new LibraryToString(compilerSet);
        stringBuilder.append(this.configuration.getLinkerConfiguration().getLibrariesConfiguration().toString(libraryToString));
        if (compilerSet != null) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(' ');
            }
            CCCCompilerConfiguration.OptionToString optionToString = new CCCCompilerConfiguration.OptionToString(compilerSet, compilerSet.getDynamicLibrarySearchOption());
            stringBuilder.append(this.configuration.getLinkerConfiguration().getDynamicSearch().toString(optionToString));
        }
        return stringBuilder.toString();
    }

    private String expandAndQuote(String string) {
        return IpeUtils.quoteIfNecessary((String)this.configuration.expandMacros(string));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludeToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;

        public IncludeToString(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        @Override
        public String toString(String string) {
            if (0 < string.length()) {
                if (this.compilerSet != null) {
                    string = this.compilerSet.normalizeDriveLetter(string);
                }
                return IpeUtils.quoteIfNecessary((String)string);
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final CompilerSet compilerSet;

        public LibraryToString(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        @Override
        public String toString(LibraryItem libraryItem) {
            switch (libraryItem.getType()) {
                case 0: {
                    return this.projectLibToString(libraryItem);
                }
                case 3: {
                    return IpeUtils.quoteIfNecessary((String)libraryItem.getPath());
                }
                case 1: 
                case 2: 
                case 4: {
                    return libraryItem.getOption();
                }
            }
            return "";
        }

        private String projectLibToString(LibraryItem libraryItem) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.compilerSet != null) {
                stringBuilder.append(this.compilerSet.getDynamicLibrarySearchOption());
                stringBuilder.append(IpeUtils.quoteIfNecessary((String)IpeUtils.getDirName((String)libraryItem.getPath())));
                stringBuilder.append(' ');
            }
            stringBuilder.append(IpeUtils.quoteIfNecessary((String)libraryItem.getPath()));
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        SET("="),
        ADD("+="),
        SUB("-=");

        private final String op;

        private Operation(String string2) {
            this.op = string2;
        }

        public String getOp() {
            return this.op;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variable {
        TEMPLATE,
        DESTDIR,
        TARGET,
        VERSION,
        CONFIG,
        QT,
        SOURCES,
        HEADERS,
        FORMS,
        RESOURCES,
        TRANSLATIONS,
        DEFINES,
        INCLUDEPATH,
        LIBS,
        QMAKE_CC,
        QMAKE_CXX,
        MOC_DIR,
        RCC_DIR,
        UI_DIR,
        OBJECTS_DIR;

    }
}

