/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class StdLibPanel
extends JPanel {
    private MyListCellRenderer myListCellRenderer = new MyListCellRenderer();
    private JLabel label;
    private JList libraryList;
    private JScrollPane scrollPane;

    public StdLibPanel(LibraryItem.StdLibItem[] stdLibItemArray) {
        this.initComponents();
        this.libraryList = new JList<LibraryItem.StdLibItem>(stdLibItemArray);
        this.libraryList.setCellRenderer(this.myListCellRenderer);
        this.scrollPane.setViewportView(this.libraryList);
        this.setPreferredSize(new Dimension(300, 300));
        this.label.setLabelFor(this.libraryList);
        this.libraryList.getAccessibleContext().setAccessibleDescription(StdLibPanel.getString("LIBRARY_LIST_SD"));
        this.libraryList.getAccessibleContext().setAccessibleName(StdLibPanel.getString("LIBRARY_LIST_NM"));
        this.getAccessibleContext().setAccessibleDescription(StdLibPanel.getString("LIBRARY_LIST_SD"));
    }

    public LibraryItem.StdLibItem[] getSelectedStdLibs() {
        Object[] objectArray = this.libraryList.getSelectedValues();
        LibraryItem.StdLibItem[] stdLibItemArray = new LibraryItem.StdLibItem[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stdLibItemArray[i] = (LibraryItem.StdLibItem)objectArray[i];
        }
        return stdLibItemArray;
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.libraryList = new JList();
        this.setLayout(new GridBagLayout());
        this.label.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("STANDARD_LIBRARIES_MN").charAt(0));
        this.label.setLabelFor(this.libraryList);
        this.label.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("STANDARD_LIBRARIES_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.label, gridBagConstraints);
        this.scrollPane.setViewportView(this.libraryList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 12);
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(StdLibPanel.class).getString(string);
    }

    private static final class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            LibraryItem libraryItem = (LibraryItem)object;
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)libraryItem.getIconName(), (boolean)false));
            jLabel.setToolTipText(libraryItem.getToolTip());
            return jLabel;
        }
    }
}

