/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "Zip";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return ZipPackager.getString(PACKAGER_NAME);
    }

    @Override
    public boolean hasInfoList() {
        return false;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public List<String> getOptionalInfoList() {
        return null;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "zip";
    }

    @Override
    public boolean isOutputAFolder() {
        return false;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.getOutputName();
    }

    @Override
    public String getOutputFileSuffix() {
        return "zip";
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String string = IpeUtils.getBaseName((String)packagingConfiguration.getOutputValue());
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return false;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ZipPackager.class, (String)string);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        public void writeShellScript(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyTarZip(bufferedWriter, makeConfiguration);
        }

        private void writePackagingScriptBodyTarZip(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
            PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
            List<PackagerFileElement> list = packagingConfiguration.getFiles().getValue();
            String string = packagingConfiguration.getOutputValue();
            String string2 = IpeUtils.isPathAbsolute((String)string) ? string : "../../../../" + string;
            bufferedWriter.write("# Copy files and create directories and links\n");
            for (PackagerFileElement packagerFileElement : list) {
                String string3;
                bufferedWriter.write("cd \"${TOP}\"\n");
                if (packagerFileElement.getType() == PackagerFileElement.FileType.FILE) {
                    string3 = IpeUtils.getDirName((String)makeConfiguration.getPackagingConfiguration().expandMacros(packagerFileElement.getTo()));
                    if (string3 != null && string3.length() >= 0) {
                        bufferedWriter.write("makeDirectory ${TMPDIR}/" + string3 + "\n");
                    }
                    bufferedWriter.write("copyFileToTmpDir \"" + packagerFileElement.getFrom() + "\" \"${TMPDIR}/" + packagerFileElement.getTo() + "\" 0" + packagerFileElement.getPermission() + "\n");
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bufferedWriter.write("makeDirectory  \"${TMPDIR}/" + packagerFileElement.getTo() + "\"" + " 0" + packagerFileElement.getPermission() + "\n");
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    string3 = IpeUtils.getDirName((String)packagerFileElement.getTo());
                    String string4 = IpeUtils.getBaseName((String)packagerFileElement.getTo());
                    if (string3 != null && string3.length() >= 0) {
                        bufferedWriter.write("makeDirectory \"${TMPDIR}/" + string3 + "\"" + "\n");
                    }
                    bufferedWriter.write("cd \"${TMPDIR}/" + string3 + "\"" + "\n");
                    bufferedWriter.write("ln -s \"" + packagerFileElement.getFrom() + "\"" + " " + "\"" + string4 + "\"" + "\n");
                } else if (packagerFileElement.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Generate zip file\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("rm -f " + string + "\n");
            bufferedWriter.write("cd ${TMPDIR}\n");
            bufferedWriter.write(packagingConfiguration.getToolValue() + " -r " + packagingConfiguration.getOptionsValue() + " " + string2 + " *\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("\n");
        }
    }
}

