/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.impl.OQLEngineImpl;
import org.netbeans.modules.profiler.oql.engine.api.impl.Snapshot;

public class OQLEngine {
    private static final Logger LOGGER = Logger.getLogger(OQLEngine.class.getName());
    private final OQLEngineImpl delegate;
    private final Heap heap;

    public static boolean isOQLSupported() {
        return OQLEngineImpl.isOQLSupported();
    }

    public OQLEngine(Heap heap) {
        this.delegate = new OQLEngineImpl(new Snapshot(heap));
        this.heap = heap;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public void executeQuery(String string, ObjectVisitor objectVisitor) throws OQLException {
        this.delegate.executeQuery(string, objectVisitor);
    }

    public OQLQuery parseQuery(String string) throws OQLException {
        return this.delegate.parseQuery(string);
    }

    public static interface ObjectVisitor {
        public static final ObjectVisitor DEFAULT = new ObjectVisitor(){

            public boolean visit(Object object) {
                if (object != null && LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(object.toString());
                }
                return true;
            }
        };

        public boolean visit(Object var1);
    }

    public static abstract class OQLQuery {
    }
}

