/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsConfigurationHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.ProjectTemplateZipHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.BasicModuleConfWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DescriptorsWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.JavaMELibsWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomComponentWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String WIZARD_PANEL_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String LBL_WIZARD_STEPS_COUNT = "LBL_WizardStepsCount";
    public static final String CONTENT_DATA = "WizardPanel_contentData";
    public static final String SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    public static final String BUNDLE_PROPERTIES = "Bundle.properties";
    public static final String LAYER_XML = "layer.xml";
    public static final String STEP_BASIC_PARAMS = "LBL_BasicProjectParamsStep";
    public static final String LBL_LIBRARIES = "LBL_LibrariesDescStep";
    public static final String LBL_COMPONENT_DESC = "LBL_ComponentsDescStep";
    public static final String FINAL_STEP = "LBL_FinalStep";
    public static final String PROJECT_DIR = "projDir";
    public static final String PROJECT_NAME = "projName";
    public static final String SET_AS_MAIN = "setAsMain";
    public static final String LAYER_PATH = "layer";
    public static final String BUNDLE_PATH = "bundle";
    public static final String CODE_BASE_NAME = "codeBaseName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String LIBRARIES = "libraries";
    public static final String LIB_DISPLAY_NAMES = "libDisplayNames";
    public static final String LIB_NAMES = "libNames";
    public static final String CUSTOM_COMPONENTS = "customComponents";
    private static final String TEMPLATE_PROJECT_NETBEANSORG = "CustomComponentProject_netbeansorg.zip";
    private static final String TEMPLATE_PROJECT_STANDALONE = "CustomComponentProject_standalone.zip";
    private static final String TEMPLATE_PROJECT_SUITECOMPONENT = "CustomComponentProject_suitecomponent.zip";
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor myWizard;

    private CustomComponentWizardIterator() {
    }

    public static CustomComponentWizardIterator createIterator() {
        return new CustomComponentWizardIterator();
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new CustomComponentWizardPanel(), new BasicModuleConfWizardPanel(), new JavaMELibsWizardPanel(), new DescriptorsWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(CustomComponentWizardIterator.class, (String)STEP_BASIC_PARAMS), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)FINAL_STEP), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_LIBRARIES), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_COMPONENT_DESC)};
    }

    public Set instantiate() throws IOException {
        File file;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file2 = FileUtil.normalizeFile((File)((File)this.myWizard.getProperty(PROJECT_DIR)));
        file2.mkdirs();
        FileObject fileObject = this.getProjectTemplate(this.myWizard);
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        ProjectTemplateZipHelper.unZipFile(fileObject.getInputStream(), fileObject2, this.myWizard);
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add(file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        ProjectManager.getDefault().clearNonProjectCache();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        assert (project != null) : "crated project is null";
        JavaMELibsConfigurationHelper.configureJavaMELibs(project, this.myWizard);
        CustomComponentWizardIterator.configureComponents(project, this.myWizard);
        return linkedHashSet;
    }

    private FileObject getProjectTemplate(WizardDescriptor wizardDescriptor) {
        if (BaseHelper.isNetBeansOrg(wizardDescriptor)) {
            return BaseHelper.getTemplate(TEMPLATE_PROJECT_NETBEANSORG);
        }
        if (BaseHelper.isSuiteComponent(wizardDescriptor)) {
            return BaseHelper.getTemplate(TEMPLATE_PROJECT_SUITECOMPONENT);
        }
        if (BaseHelper.isStandalone(wizardDescriptor)) {
            return BaseHelper.getTemplate(TEMPLATE_PROJECT_STANDALONE);
        }
        throw new IllegalArgumentException("unsupported wizard type");
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.myWizard = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty(SELECTED_INDEX, new Integer(i));
            jComponent.putClientProperty(CONTENT_DATA, stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(PROJECT_DIR, null);
        wizardDescriptor.putProperty(PROJECT_NAME, null);
        wizardDescriptor.putProperty(LIBRARIES, null);
        wizardDescriptor.putProperty(LIB_NAMES, null);
        wizardDescriptor.putProperty(LIB_DISPLAY_NAMES, null);
        wizardDescriptor.putProperty(CUSTOM_COMPONENTS, null);
        wizardDescriptor = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(CustomComponentWizardIterator.class).getString(LBL_WIZARD_STEPS_COUNT), new Integer(this.index + 1) + "", new Integer(this.panels.length) + "");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private static Set<FileObject> configureComponents(Project project, WizardDescriptor wizardDescriptor) throws IOException {
        List list = (List)wizardDescriptor.getProperty(CUSTOM_COMPONENTS);
        if (list == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (Map map : list) {
            CustomComponentHelper.RealInstantiationHelper realInstantiationHelper = new CustomComponentHelper.RealInstantiationHelper(project, map);
            linkedHashSet.addAll(((CustomComponentHelper)realInstantiationHelper).instantiate());
        }
        return Collections.EMPTY_SET;
    }
}

