/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.customwizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.customwizard.WizardPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class CommandLinesPanel
extends JPanel
implements WizardPanel.ComponentDescriptor {
    protected WizardPanel wizardPanel;
    private static final Set<Character> INVALID_CHARACTERS = new HashSet<Character>();
    private JButton browseButton;
    private JTextField debuggerCommand;
    private JTextField deviceName;
    private JTextField executionCommand;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField platformHome;
    private JTextField platformName;
    private JTextField preverifyCommand;

    public CommandLinesPanel() {
        Object object;
        for (char c : "\\^$?*+-!.;:,=<>|/\"'[]{}()".toCharArray()) {
            INVALID_CHARACTERS.add(Character.valueOf(c));
        }
        this.initComponents();
        this.infoPanel.setEditorKit(new HTMLEditorKit());
        int n = 1;
        String string = NbBundle.getMessage(CommandLinesPanel.class, (String)"Preset_CmdLinesPanel_Custom_Platform");
        while ((object = JavaPlatformManager.getDefault().getPlatforms(string + n, null)) != null && ((JavaPlatform[])object).length > 0) {
            ++n;
        }
        this.platformName.setText(string + n);
        this.deviceName.setText(NbBundle.getMessage(CommandLinesPanel.class, (String)"Preset_CmdLinesPanel_Custom_Device"));
        object = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }
        };
        this.platformHome.getDocument().addDocumentListener((DocumentListener)object);
        this.platformName.getDocument().addDocumentListener((DocumentListener)object);
        this.deviceName.getDocument().addDocumentListener((DocumentListener)object);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getComponent();
                URL uRL = null;
                try {
                    if (component == CommandLinesPanel.this.preverifyCommand) {
                        uRL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/preverifyinfo.html");
                    } else if (component == CommandLinesPanel.this.executionCommand) {
                        uRL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/executioninfo.html");
                    } else if (component == CommandLinesPanel.this.debuggerCommand) {
                        uRL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/debuggerinfo.html");
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
                if (uRL != null) {
                    try {
                        String string = CommandLinesPanel.findEncodingFromURL(uRL.openStream());
                        ErrorManager.getDefault().log(1, "Url " + uRL + " has charset " + string);
                        if (string != null) {
                            CommandLinesPanel.this.infoPanel.putClientProperty("charset", string);
                        }
                        CommandLinesPanel.this.infoPanel.read(uRL.openStream(), (Object)uRL);
                    }
                    catch (ChangedCharSetException changedCharSetException) {
                        Document document = CommandLinesPanel.this.infoPanel.getEditorKit().createDefaultDocument();
                        document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                        try {
                            CommandLinesPanel.this.infoPanel.read(uRL.openStream(), (Object)document);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                    }
                } else {
                    CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                }
                CommandLinesPanel.this.infoPanel.setCaretPosition(0);
            }

            public void focusLost(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null && component != CommandLinesPanel.this.preverifyCommand && component != CommandLinesPanel.this.executionCommand && component != CommandLinesPanel.this.debuggerCommand && component != CommandLinesPanel.this.infoPanel) {
                    CommandLinesPanel.this.infoPanel.setText("");
                }
            }
        };
        this.preverifyCommand.addFocusListener(focusListener);
        this.executionCommand.addFocusListener(focusListener);
        this.debuggerCommand.addFocusListener(focusListener);
        FocusListener focusListener2 = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ((JTextField)focusEvent.getComponent()).selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        };
        FocusListener focusListener3 = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ((JTextField)focusEvent.getComponent()).setCaretPosition(0);
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        };
        this.platformHome.addFocusListener(focusListener2);
        this.platformName.addFocusListener(focusListener2);
        this.deviceName.addFocusListener(focusListener2);
        this.preverifyCommand.addFocusListener(focusListener3);
        this.executionCommand.addFocusListener(focusListener3);
        this.debuggerCommand.addFocusListener(focusListener3);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.platformHome = new JTextField();
        this.browseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.platformName = new JTextField();
        this.jLabel3 = new JLabel();
        this.deviceName = new JTextField();
        this.jLabel4 = new JLabel();
        this.preverifyCommand = new JTextField();
        this.jLabel5 = new JLabel();
        this.executionCommand = new JTextField();
        this.jLabel6 = new JLabel();
        this.debuggerCommand = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.setName(NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_General_Information"));
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinePanel_Platform_Home"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinePanel_Platform_Home"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinePanel_Platform_Home"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.platformHome, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommandLinesPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Browse"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Browse"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Platform_Name"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.platformName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Device_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Device_Name"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Device_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.deviceName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Preverify_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Preverify_Command"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Preverify_Command"));
        this.preverifyCommand.setText("\"{platformhome}{/}bin{/}preverify\" {classpath|-classpath \"{classpath}\"} -d \"{destdir}\" \"{srcdir}\"");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.preverifyCommand, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Execution_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Execution_Command"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Execution_Command"));
        this.executionCommand.setText("\"{platformhome}{/}bin{/}emulator\" {device|-Xdevice:\"{device}\"} {jadfile|-Xdescriptor:\"{jadfile}\"} {securitydomain|-Xdomain:{securitydomain}} {cmdoptions}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.executionCommand, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Debugger_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Debugger_Command"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Debugger_Command"));
        this.debuggerCommand.setText("\"{platformhome}{/}bin{/}emulator\" {device|-Xdevice:\"{device}\"} {jadfile|-Xdescriptor:\"{jadfile}\"} {securitydomain|-Xdomain:{securitydomain}} {debug|-Xdebug -Xrunjdwp:transport={debugtransport},server={debugserver},suspend={debugsuspend},address={debugaddress}} {cmdoptions}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.debuggerCommand, gridBagConstraints);
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane1.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.browseFolder(NbBundle.getMessage(CommandLinesPanel.class, (String)"TITLE_CommandLinesPanel_BrowseHome"));
        if (string == null) {
            return;
        }
        this.platformHome.setText(string);
    }

    public void setWizardPanel(WizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        if (j2MEPlatform == null) {
            return;
        }
        this.platformHome.setText(j2MEPlatform.getHomePath());
        this.platformName.setText(j2MEPlatform.getDisplayName());
        this.deviceName.setText(j2MEPlatform.getDevices()[0].getName());
        this.preverifyCommand.setText(j2MEPlatform.getPreverifyCmd());
        this.executionCommand.setText(j2MEPlatform.getRunCmd());
        this.debuggerCommand.setText(j2MEPlatform.getDebugCmd());
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform j2MEPlatform = new J2MEPlatform(J2MEPlatform.computeUniqueName(this.platformName.getText()), this.platformHome.getText(), "CUSTOM", this.platformName.getText(), null, null, this.preverifyCommand.getText(), this.executionCommand.getText(), this.debuggerCommand.getText(), new J2MEPlatform.Device[]{new J2MEPlatform.Device(this.deviceName.getText(), null, null, new J2MEPlatform.J2MEProfile[0], null)});
        wizardDescriptor.putProperty("Platform", (Object)j2MEPlatform);
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean isPanelValid() {
        String string = null;
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(this.platformName.getText(), null);
        if (javaPlatformArray != null && javaPlatformArray.length > 0) {
            string = "ERR_PlatformExists";
        }
        if (this.deviceName.getText().length() <= 0) {
            string = "ERR_EnterDeviceName";
        }
        if (this.platformName.getText().length() <= 0) {
            string = "ERR_EnterPlatformName";
        }
        for (char c : this.platformName.getText().toCharArray()) {
            if (!INVALID_CHARACTERS.contains(Character.valueOf(c))) continue;
            string = "ERR_InvalidPlatformName";
        }
        for (char c : this.deviceName.getText().toCharArray()) {
            if (!INVALID_CHARACTERS.contains(Character.valueOf(c))) continue;
            string = "ERR_InvalidDeviceName";
        }
        String string2 = this.platformHome.getText();
        if (string2 == null || !new File(string2).isDirectory()) {
            string = "ERR_InvalidPlatformHome";
        }
        this.wizardPanel.setErrorMessage(CommandLinesPanel.class, string);
        return string == null;
    }

    public boolean isFinishPanel() {
        return false;
    }

    private String browseFolder(String string) {
        File file = new FileChooserBuilder(CommandLinesPanel.class).setTitle(string).setDirectoriesOnly(true).setFileFilter((FileFilter)new FolderFilter()).showOpenDialog();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static String findEncodingFromURL(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray, 0, byArray.length);
            String string = new String(byArray, 0, n >= 0 ? n : 0).toUpperCase();
            return CommandLinesPanel.findEncoding(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String findEncoding(String string) {
        int n;
        int n2 = string.indexOf("</HEAD>");
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.indexOf("CONTENT-TYPE")) == -1 || n > n2) {
            return null;
        }
        int n3 = string.indexOf("CHARSET=", n);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(34, n3);
        int n5 = string.indexOf(39, n3);
        if (n4 == -1 && n5 == -1) {
            return null;
        }
        if (n5 != -1 && (n4 == -1 || n4 > n5)) {
            n4 = n5;
        }
        return string.substring(n3 + "CHARSET=".length(), n4);
    }

    private static final class FolderFilter
    extends FileFilter {
        private FolderFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.canRead() && file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(CommandLinesPanel.class, (String)"TXT_FolderFilter");
        }
    }
}

