/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openide.ErrorManager;

public class SolarisRoutines {
    public static final int PATCH_INSTALLED = 0;
    public static final int PATCH_MISSING = 1;
    public static final int PATCH_UNKNOWN = 2;

    public static PkgInfo findPackage(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            n = SolarisRoutines.executeRuntimeCommand("/bin/pkginfo -i -l " + string, stringBuffer);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
        if (n == 0) {
            return new PkgInfo(stringBuffer);
        }
        return null;
    }

    public static File createPatchScript() throws IOException {
        File file = new File("/bin/showrev");
        if (!file.exists()) {
            throw new FileNotFoundException("/bin/showrev is not found to check the installed patches");
        }
        File file2 = File.createTempFile("appserver-showrev", ".sh", new File("/tmp"));
        Process process = Runtime.getRuntime().exec("chmod +x " + file2);
        try {
            process.waitFor();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write("/bin/showrev -p | grep $1\n");
        fileWriter.close();
        return file2;
    }

    public static String[] getUninstalledPatches(String[] stringArray) throws IOException {
        File file = SolarisRoutines.createPatchScript();
        String string = file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (SolarisRoutines.checkPatch(string2, string) != 0) continue;
            iterator.remove();
        }
        file.delete();
        return arrayList.size() > 0 ? arrayList.toArray(new String[arrayList.size()]) : null;
    }

    public static int checkPatch(String string, String string2) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string.substring(0, string.indexOf(45));
        try {
            n = SolarisRoutines.executeRuntimeCommand(string2 + " " + string3, stringBuffer);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return 2;
        }
        if (n == 0) {
            if (SolarisRoutines.checkPatchInstalled(string, stringBuffer)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private static boolean checkPatchInstalled(String string, StringBuffer stringBuffer) {
        String string2 = stringBuffer.toString();
        String string3 = string.substring(0, string.indexOf(45));
        String string4 = string.substring(string.indexOf(45) + 1);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = string2.indexOf("Patch:", 0);
        while (n != -1) {
            ++n;
            ++n2;
            n = string2.indexOf("Patch:", n);
        }
        n = 0;
        while (n3 < n2) {
            String string5 = (n = string2.indexOf("Patch:", n + 1)) == -1 ? string2.substring(n4) : string2.substring(n4, n);
            int n5 = string5.indexOf(32);
            int n6 = string5.indexOf(32, n5 + 1);
            String string6 = string5.substring(n5, n6).trim();
            String string7 = string6.substring(0, string6.indexOf(45));
            String string8 = string6.substring(string6.indexOf(45) + 1);
            if (string7.equals(string3) && string8.compareTo(string4) >= 0) {
                return true;
            }
            n4 = n;
            ++n3;
        }
        return false;
    }

    public static void killProcess(String string) {
        block6: {
            String string2 = string.trim();
            int n = string2.indexOf(32);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            String string3 = "/bin/pgrep -f " + string2;
            try {
                int n2 = -1;
                StringBuffer stringBuffer = new StringBuffer();
                n2 = SolarisRoutines.executeRuntimeCommand(string3, stringBuffer);
                if (n2 != 0 || stringBuffer.length() == 0) break block6;
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer = new StringBuffer();
                    String string4 = stringTokenizer.nextToken().trim();
                    try {
                        Integer.valueOf(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    Thread.sleep(3000L);
                    n2 = SolarisRoutines.executeRuntimeCommand("/bin/ptree " + string4, stringBuffer);
                    if (n2 != 0 || stringBuffer.length() == 0) continue;
                    String string5 = SolarisRoutines.parsePtreeInformation(stringBuffer, string2);
                    n2 = SolarisRoutines.executeRuntimeCommand("/bin/kill -9 " + string5, stringBuffer);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private static String parsePtreeInformation(StringBuffer stringBuffer, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        boolean bl = false;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken().trim();
            if (!bl) {
                n = string3.indexOf(string);
                if (n == -1) continue;
                bl = true;
            }
            if ((n = string3.indexOf(32)) == -1) continue;
            string2 = string2 + " " + string3.substring(0, n);
        }
        return string2;
    }

    public static int executeRuntimeCommand(String string, StringBuffer stringBuffer) throws Exception {
        Process process = Runtime.getRuntime().exec(string);
        try {
            process.waitFor();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        if (bufferedReader.ready()) {
            int n = 0;
            while (n != -1) {
                char[] cArray = new char[250];
                n = bufferedReader.read(cArray, 0, 250);
                stringBuffer.append(cArray);
            }
        }
        bufferedReader.close();
        return process.exitValue();
    }

    public static void main(String[] stringArray) {
        try {
            File file = SolarisRoutines.createPatchScript();
            String string = file.getAbsolutePath();
            System.out.println("Checking patch 108827-35 -> " + SolarisRoutines.checkPatch("108827-35", string));
            System.out.println("Checking patch 109326-09 -> " + SolarisRoutines.checkPatch("109326-09", string));
            System.out.println("Checking patch 110380-04 -> " + SolarisRoutines.checkPatch("110380-04", string));
            System.out.println("Checking patch 110934-10 -> " + SolarisRoutines.checkPatch("110934-10", string));
            System.out.println("Checking patch 109320-01 -> " + SolarisRoutines.checkPatch("109320-01", string));
            System.out.println("Checking patch 108435-05 -> " + SolarisRoutines.checkPatch("108435-05", string));
            System.out.println("Class -> " + SolarisRoutines.class.getName());
            System.out.println("os -> " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
            file.delete();
            String[] stringArray2 = new String[]{"108827-35", "109326-09", "110380-04", "110934-10", "109320-01", "108435-05"};
            String[] stringArray3 = SolarisRoutines.getUninstalledPatches(stringArray2);
            String string2 = stringArray3 == null ? "all installed" : Arrays.asList(stringArray3).toString();
            System.out.println("All installed -> " + Arrays.asList(stringArray2) + "\n" + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class PkgInfo {
        private String version = "";
        private String location = "";
        private double versionNumber = 0.0;
        private Date revision;
        private String pkgInst = "";

        private PkgInfo() {
        }

        public PkgInfo(StringBuffer stringBuffer) {
            this.parsePackageInformation(stringBuffer);
        }

        public String getPkgInst() {
            return this.pkgInst;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLocation() {
            return this.location;
        }

        public double getVersionNumber() {
            return this.versionNumber;
        }

        public Date getRevision() {
            return this.revision;
        }

        public int compareTo(PkgInfo pkgInfo) {
            if (this.versionNumber > pkgInfo.getVersionNumber()) {
                return 1;
            }
            if (this.versionNumber < pkgInfo.getVersionNumber()) {
                return -1;
            }
            if (this.revision != null && pkgInfo.getRevision() != null) {
                return this.revision.compareTo(pkgInfo.getRevision());
            }
            return 0;
        }

        private void parsePackageInformation(StringBuffer stringBuffer) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if ("BASEDIR:".equals(string)) {
                    this.location = stringTokenizer.nextToken();
                    continue;
                }
                if ("PKGINST:".equals(string)) {
                    this.pkgInst = stringTokenizer.nextToken();
                    continue;
                }
                if (!"VERSION:".equals(string)) continue;
                this.version = stringTokenizer.nextToken();
                int n = this.version.indexOf(",REV=");
                if (n == -1) continue;
                try {
                    this.versionNumber = Double.parseDouble(this.version.substring(0, n));
                    String string2 = this.version.substring(n + ",REV=".length());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd.hh.mm");
                    this.revision = simpleDateFormat.parse(string2);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
    }
}

