/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ant.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private Map breakpointToAnnotation = new HashMap();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof AntBreakpoint)) {
            return;
        }
        this.addAnnotation((AntBreakpoint)breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof AntBreakpoint)) {
            return;
        }
        this.removeAnnotation(breakpoint);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != "enabled") {
            return;
        }
        this.removeAnnotation((Breakpoint)propertyChangeEvent.getSource());
        this.addAnnotation((AntBreakpoint)((Object)propertyChangeEvent.getSource()));
    }

    private void addAnnotation(AntBreakpoint antBreakpoint) {
        this.breakpointToAnnotation.put(antBreakpoint, new DebuggerBreakpointAnnotation(antBreakpoint.isEnabled() ? "Breakpoint" : "DisabledBreakpoint", antBreakpoint));
        antBreakpoint.addPropertyChangeListener("enabled", this);
    }

    private void removeAnnotation(Breakpoint breakpoint) {
        DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = (DebuggerBreakpointAnnotation)((Object)this.breakpointToAnnotation.remove(breakpoint));
        if (debuggerBreakpointAnnotation == null) {
            return;
        }
        debuggerBreakpointAnnotation.detach();
        breakpoint.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }
}

