/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class SourceRoots {
    public static final String PROP_ROOTS = SourceRoots.class.getName() + ".roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final List<String> sourceRootProperties;
    private final List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final File projectDir;
    private final Type type;

    public static SourceRoots create(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, Type type) {
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        assert (type != null);
        return new SourceRoots(updateHelper, propertyEvaluator, referenceHelper, type);
    }

    private SourceRoots(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, Type type) {
        this.helper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.type = type;
        switch (type) {
            case SOURCES: {
                this.sourceRootProperties = Arrays.asList("src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_Sources"));
                break;
            }
            case TESTS: {
                this.sourceRootProperties = Arrays.asList("test.src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_Tests"));
                break;
            }
            case SELENIUM: {
                this.sourceRootProperties = Arrays.asList("selenium.src.dir");
                this.sourceRootNames = Arrays.asList(NbBundle.getMessage(SourceRoots.class, (String)"LBL_Node_SeleniumTests"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknow sources roots type: " + (Object)((Object)type));
            }
        }
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
    }

    public String[] getRootNames() {
        return this.sourceRootNames.toArray(new String[this.sourceRootNames.size()]);
    }

    public String[] getRootProperties() {
        return this.sourceRootProperties.toArray(new String[this.sourceRootProperties.size()]);
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        for (String string : stringArray) {
                            FileObject fileObject;
                            String string2 = SourceRoots.this.evaluator.getProperty(string);
                            if (string2 == null || (fileObject = SourceRoots.this.helper.getAntProjectHelper().resolveFileObject(string2)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                            }
                            arrayList.add(fileObject);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        for (String string : SourceRoots.this.getRootProperties()) {
                            String string2 = SourceRoots.this.evaluator.getProperty(string);
                            if (string2 == null) continue;
                            File file = SourceRoots.this.helper.getAntProjectHelper().resolveFile(string2);
                            try {
                                URL uRL = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL = new URL(uRL.toExternalForm() + "/");
                                } else if (file.isFile()) continue;
                                assert (uRL.toExternalForm().endsWith("/")) : "#90639 violation for " + uRL + "; " + file + " exists? " + file.exists() + " dir? " + file.isDirectory() + " file? " + file.isFile();
                                arrayList.add(uRL);
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String getRootDisplayName(String string, String string2) {
        if (string == null || string.length() == 0) {
            switch (this.type) {
                case SOURCES: {
                    string = DEFAULT_SOURCE_LABEL;
                    break;
                }
                case TESTS: {
                    string = DEFAULT_TEST_LABEL;
                    break;
                }
                default: {
                    String string3 = this.evaluator.getProperty(string2);
                    File file = string3 == null ? null : this.helper.getAntProjectHelper().resolveFile(string3);
                    string = this.createInitialDisplayName(file);
                }
            }
        }
        return string;
    }

    public String createInitialDisplayName(File file) {
        return SourceRoots.createInitialDisplayName(file, this.projectDir, this.type);
    }

    public static String createInitialDisplayName(File file, File file2, Type type) {
        String string;
        String string2;
        String string3 = file != null ? ((string2 = file.getAbsolutePath()).startsWith(string = file2.getAbsolutePath() + File.separatorChar) ? string2.substring(string.length()) : file.getAbsolutePath()) : (type.equals((Object)Type.SOURCES) ? DEFAULT_SOURCE_LABEL : DEFAULT_TEST_LABEL);
        return string3;
    }

    public boolean isTest() {
        boolean bl = false;
        switch (this.type) {
            case SOURCES: {
                bl = false;
                break;
            }
            case TESTS: 
            case SELENIUM: {
                bl = true;
                break;
            }
            default: {
                assert (false) : "Unknown source roots type: " + (Object)((Object)this.type);
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(String string) {
        boolean bl = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (string == null || this.sourceRootProperties.contains(string)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl = true;
            }
        }
        if (bl) {
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private final class ProjectMetadataListener
    implements PropertyChangeListener {
        private ProjectMetadataListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourceRoots.this.resetCache(propertyChangeEvent.getPropertyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SOURCES,
        TESTS,
        SELENIUM;

    }
}

