/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BrowseTestSources
extends JPanel {
    private static final long serialVersionUID = 1463321897654268L;
    private final PhpProject phpProject;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel infoLabel;
    private JButton testSourcesBrowseButton;
    private JLabel testSourcesLabel;
    private JTextField testSourcesTextField;

    public BrowseTestSources(PhpProject phpProject, String string) {
        assert (phpProject != null);
        assert (string != null);
        this.phpProject = phpProject;
        this.initComponents();
        this.infoLabel.setText(string);
        this.testSourcesTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                BrowseTestSources.this.validateTestSources();
            }
        });
    }

    public boolean open() {
        this.dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(BrowseTestSources.class, (String)"LBL_DirectoryForProject", (Object)ProjectUtils.getInformation((Project)this.phpProject).getDisplayName()), true, 2, DialogDescriptor.OK_OPTION, null);
        this.notificationLineSupport = this.dialogDescriptor.createNotificationLineSupport();
        this.dialogDescriptor.setValid(false);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dialogDescriptor) == DialogDescriptor.OK_OPTION;
    }

    public String getTestSources() {
        return this.testSourcesTextField.getText();
    }

    void validateTestSources() {
        assert (this.notificationLineSupport != null);
        String string = this.testSourcesTextField.getText();
        if (string.length() == 0) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_FolderEmpty"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestNotAbsolute"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        if (!file.isDirectory()) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestNotDirectory"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        FileObject fileObject = this.phpProject.getProjectDirectory().getFileObject("nbproject");
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        if (file.equals(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(this.phpProject)))) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestEqualsSources"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject.equals(fileObject2)) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestUnderneathNBMetadata"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        if (!Utils.isFolderWritable(file)) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestNotWritable"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        if (!FileUtil.isParentOf((FileObject)this.phpProject.getProjectDirectory(), (FileObject)fileObject2)) {
            this.notificationLineSupport.setWarningMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"MSG_TestNotUnderneathProjectFolder"));
            this.dialogDescriptor.setValid(true);
            return;
        }
        this.notificationLineSupport.setInformationMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"LBL_PhpUnitIncludePathInfo"));
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.testSourcesLabel = new JLabel();
        this.testSourcesTextField = new JTextField();
        this.testSourcesBrowseButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        this.testSourcesLabel.setLabelFor(this.testSourcesTextField);
        Mnemonics.setLocalizedText((JLabel)this.testSourcesLabel, (String)NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testSourcesBrowseButton, (String)NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesBrowseButton.text"));
        this.testSourcesBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowseTestSources.this.testSourcesBrowseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.infoLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.testSourcesLabel).addPreferredGap(0).add((Component)this.testSourcesTextField, -1, 314, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.testSourcesBrowseButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.infoLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.testSourcesLabel).add((Component)this.testSourcesTextField, -2, -1, -2).add((Component)this.testSourcesBrowseButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void testSourcesBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseTestSources(this.testSourcesTextField, this.phpProject);
    }
}

