/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

class ConfigActionScript
extends ConfigAction {
    static final ExecutionDescriptor.LineConvertorFactory PHP_LINE_CONVERTOR_FACTORY = new PhpLineConvertorFactory();
    private final FileObject sourceRoot;

    protected ConfigActionScript(PhpProject phpProject) {
        super(phpProject);
        this.sourceRoot = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
        assert (this.sourceRoot != null);
    }

    public boolean isValid(boolean bl) {
        boolean bl2 = true;
        if (bl && !this.isIndexFileValid(this.sourceRoot)) {
            bl2 = false;
        } else {
            try {
                if (RunAsValidator.validateScriptFields(ProjectPropertiesSupport.getPhpInterpreter(this.project).getProgram(), FileUtil.toFile((FileObject)this.sourceRoot), null, ProjectPropertiesSupport.getArguments(this.project)) != null) {
                    bl2 = false;
                }
            }
            catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
                bl2 = false;
            }
        }
        if (!bl2) {
            this.showCustomizer();
        }
        return bl2;
    }

    public boolean isRunFileEnabled(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup, this.sourceRoot);
        return fileObject != null && FileUtils.isPhpFile((FileObject)fileObject);
    }

    public boolean isDebugFileEnabled(Lookup lookup) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(lookup);
    }

    public void runProject() {
        new RunScript(new ScriptProvider()).run();
    }

    public void debugProject() {
        new DebugScript(new ScriptProvider()).run();
    }

    public void runFile(Lookup lookup) {
        new RunScript(new ScriptProvider(lookup)).run();
    }

    public void debugFile(Lookup lookup) {
        new DebugScript(new ScriptProvider(lookup)).run();
    }

    static final class PhpLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        PhpLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            LineConvertor[] lineConvertorArray = new LineConvertor[PhpInterpreter.LINE_PATTERNS.length];
            int n = 0;
            for (Pattern pattern : PhpInterpreter.LINE_PATTERNS) {
                lineConvertorArray[n++] = LineConvertors.filePattern(null, (Pattern)pattern, null, (int)1, (int)2);
            }
            return LineConvertors.proxy((LineConvertor[])lineConvertorArray);
        }
    }

    private final class ScriptProvider
    implements DebugScript.Provider {
        private final PhpProgram program;
        private final File startFile;

        public ScriptProvider() {
            this(null);
        }

        public ScriptProvider(Lookup lookup) {
            PhpInterpreter phpInterpreter = null;
            try {
                phpInterpreter = ProjectPropertiesSupport.getPhpInterpreter(ConfigActionScript.this.project);
            }
            catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
                Exceptions.printStackTrace((Throwable)invalidPhpProgramException);
            }
            assert (phpInterpreter.isValid()) : String.format("php program %s must be valid", phpInterpreter);
            this.program = phpInterpreter;
            this.startFile = this.getStartFile(lookup);
        }

        public PhpProject getProject() {
            return ConfigActionScript.this.project;
        }

        public FileObject getStartFile() {
            assert (this.startFile != null);
            return FileUtil.toFileObject((File)this.startFile);
        }

        public ExecutionDescriptor getDescriptor() throws IOException {
            assert (this.startFile != null);
            RunScript.InOutPostRedirector inOutPostRedirector = new RunScript.InOutPostRedirector(this.startFile);
            return PhpProgram.getExecutionDescriptor().frontWindow(PhpOptions.getInstance().isOpenResultInOutputWindow()).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory").outConvertorFactory(PHP_LINE_CONVERTOR_FACTORY).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)inOutPostRedirector).postExecution((Runnable)inOutPostRedirector).charset(Charset.forName(ProjectPropertiesSupport.getEncoding(ConfigActionScript.this.project)));
        }

        public ExternalProcessBuilder getProcessBuilder() {
            assert (this.startFile != null);
            ExternalProcessBuilder externalProcessBuilder = this.program.getProcessBuilder().addArgument(this.startFile.getName());
            String string = ProjectPropertiesSupport.getArguments(ConfigActionScript.this.project);
            if (StringUtils.hasText((String)string)) {
                for (String string2 : Arrays.asList(string.split(" "))) {
                    externalProcessBuilder = externalProcessBuilder.addArgument(string2);
                }
            }
            externalProcessBuilder = externalProcessBuilder.workingDirectory(this.startFile.getParentFile());
            return externalProcessBuilder;
        }

        public String getOutputTabTitle() {
            assert (this.startFile != null);
            return String.format("%s - %s", this.program.getProgram(), this.startFile.getName());
        }

        public boolean isValid() {
            return this.program.isValid() && this.startFile != null;
        }

        private File getStartFile(Lookup lookup) {
            FileObject fileObject = null;
            fileObject = lookup == null ? CommandUtils.fileForProject(ConfigActionScript.this.project, ConfigActionScript.this.sourceRoot) : CommandUtils.fileForContextOrSelectedNodes(lookup, ConfigActionScript.this.sourceRoot);
            assert (fileObject != null) : "Start file must be found";
            return FileUtil.toFile((FileObject)fileObject);
        }
    }
}

