/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateTestsAction
extends NodeAction {
    private static final long serialVersionUID = 952382987542628824L;
    private static final Logger LOGGER = Logger.getLogger(CreateTestsAction.class.getName());
    private static final String REQUIRE_ONCE_TPL = "require_once '%s';";
    private static final ExecutionDescriptor EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(false).frontWindow(false);
    private static final RequestProcessor RP = new RequestProcessor("Generate PHP Unit tests", 1);
    static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        public void run() {
            Runnable runnable = RUNNABLES.poll();
            while (runnable != null) {
                runnable.run();
                runnable = RUNNABLES.poll();
            }
        }
    }, true);

    public CreateTestsAction() {
        this.putValue("noIconInMenu", true);
    }

    public boolean asynchronous() {
        return true;
    }

    protected void performAction(final Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final PhpUnit phpUnit = CommandUtils.getPhpUnit(true);
        if (phpUnit == null) {
            return;
        }
        final PhpProject phpProject = PhpProjectUtils.getPhpProject(nodeArray[0]);
        assert (phpProject != null) : "PHP project must be found for " + nodeArray[0];
        if (ProjectPropertiesSupport.getTestDirectory(phpProject, true) == null) {
            return;
        }
        if (!Utils.validatePhpUnitForProject(phpUnit, phpProject)) {
            return;
        }
        RUNNABLES.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreatingTests"));
                progressHandle.start();
                try {
                    LifecycleManager.getDefault().saveAll();
                    CreateTestsAction.this.generateTests(nodeArray, phpUnit, phpProject);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    progressHandle.finish();
                    throw throwable;
                }
                progressHandle.finish();
            }
        });
        TASK.schedule(0);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        PhpProject phpProject = null;
        for (Node node : nodeArray) {
            FileObject fileObject = CommandUtils.getFileObject(node);
            if (fileObject == null) {
                return false;
            }
            if (fileObject.isData() && !FileUtils.isPhpFile((FileObject)fileObject)) {
                return false;
            }
            PhpProject phpProject2 = PhpProjectUtils.getPhpProject(fileObject);
            if (phpProject2 == null) {
                return false;
            }
            if (phpProject == null) {
                phpProject = phpProject2;
            } else if (!phpProject.equals(phpProject2)) {
                return false;
            }
            if (CommandUtils.isUnderSources(phpProject2, fileObject) && !CommandUtils.isUnderTests(phpProject2, fileObject, false)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreateTests");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    void generateTests(Node[] nodeArray, final PhpUnit phpUnit, final PhpProject phpProject) {
        Serializable serializable;
        assert (phpProject != null);
        final List<FileObject> list = CommandUtils.getFileObjects(nodeArray);
        assert (!list.isEmpty()) : "No files for tests?!";
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        final HashSet hashSet3 = new HashSet();
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            public void run() {
                try {
                    PhpVisibilityQuery phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
                    for (FileObject fileObject : list) {
                        CreateTestsAction.this.generateTest(phpUnit, phpProject, phpVisibilityQuery, fileObject, hashSet, hashSet2, hashSet3);
                        Enumeration enumeration = fileObject.getChildren(true);
                        while (enumeration.hasMoreElements()) {
                            CreateTestsAction.this.generateTest(phpUnit, phpProject, phpVisibilityQuery, (FileObject)enumeration.nextElement(), hashSet, hashSet2, hashSet3);
                        }
                    }
                }
                catch (ExecutionException executionException) {
                    LOGGER.log(Level.INFO, null, executionException);
                    UiUtils.processExecutionException((ExecutionException)executionException);
                }
            }
        });
        if (!hashSet2.isEmpty()) {
            serializable = new StringBuilder();
            for (Object object : hashSet2) {
                ((StringBuilder)serializable).append(object.getNameExt());
                ((StringBuilder)serializable).append("\n");
            }
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateTestsAction.class, (String)"MSG_TestNotGenerated", (Object)((StringBuilder)serializable).toString()), 2));
        }
        serializable = new HashSet();
        for (Object object : hashSet3) {
            assert (((File)object).isFile()) : "File must be given to open: " + object;
            serializable.add(((File)object).getParentFile());
            try {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object));
                assert (fileObject != null) : "File object not found for " + object;
                assert (fileObject.isValid()) : "File object not valid for " + object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                editorCookie.open();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, null, dataObjectNotFoundException);
            }
        }
        if (!serializable.isEmpty()) {
            FileUtil.refreshFor((File[])serializable.toArray(new File[serializable.size()]));
        }
    }

    private void generateTest(PhpUnit phpUnit, PhpProject phpProject, PhpVisibilityQuery phpVisibilityQuery, FileObject fileObject, Set<FileObject> set, Set<FileObject> set2, Set<File> set3) throws ExecutionException {
        if (fileObject.isFolder() || !FileUtils.isPhpFile((FileObject)fileObject) || set.contains(fileObject) || CommandUtils.isUnderTests(phpProject, fileObject, false) || CommandUtils.isUnderSelenium(phpProject, fileObject, false) || !PhpProjectUtils.isVisible(phpVisibilityQuery, fileObject)) {
            return;
        }
        set.add(fileObject);
        PhpUnit.ConfigFiles configFiles = PhpUnit.getConfigFiles(phpProject, false);
        String string = PhpUnit.hasValidVersion(phpUnit) ? "--skeleton-test" : "--skeleton";
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = FileUtil.toFile((FileObject)fileObject.getParent());
        File file3 = phpUnit.getWorkingDirectory(configFiles, file2);
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection collection = editorSupport.getClasses(fileObject);
        if (collection.size() == 0) {
            this.generateSkeleton(phpUnit, configFiles, fileObject.getName(), fileObject, file3, string);
            set2.add(fileObject);
            return;
        }
        for (PhpClass phpClass : collection) {
            String string2 = phpClass.getName();
            File file4 = this.getTestFile(phpProject, fileObject, string2);
            if (file4.isFile()) {
                set3.add(file4);
                continue;
            }
            File file5 = this.getGeneratedFile(string2, file2);
            Future<Integer> future = this.generateSkeleton(phpUnit, configFiles, phpClass.getFullyQualifiedName(), fileObject, file3, string);
            try {
                if (future.get() != 0) {
                    set2.add(fileObject);
                    continue;
                }
                File file6 = this.moveAndAdjustGeneratedFile(file5, file4, file);
                if (file6 == null) {
                    set2.add(fileObject);
                    continue;
                }
                set3.add(file6);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.WARNING, null, interruptedException);
            }
        }
    }

    private Future<Integer> generateSkeleton(PhpUnit phpUnit, PhpUnit.ConfigFiles configFiles, String string, FileObject fileObject, File file, String string2) {
        ExternalProcessBuilder externalProcessBuilder = phpUnit.getProcessBuilder().workingDirectory(file);
        if (configFiles.configuration != null) {
            externalProcessBuilder = externalProcessBuilder.addArgument("--configuration").addArgument(configFiles.configuration.getAbsolutePath());
        }
        if (string.startsWith("\\")) {
            string = string.substring(1);
        }
        externalProcessBuilder = externalProcessBuilder.addArgument(string2).addArgument(string).addArgument(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)EXECUTION_DESCRIPTOR, (String)String.format("%s %s %s %s", phpUnit.getProgram(), string2, string, fileObject.getNameExt()));
        return executionService.run();
    }

    private File getGeneratedFile(String string, File file) {
        return new File(file, string + "Test.php");
    }

    private File getTestDirectory(PhpProject phpProject) {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (fileObject != null && fileObject.isValid()) : "Valid folder for tests must be found for " + phpProject;
        return FileUtil.toFile((FileObject)fileObject);
    }

    private File getTestFile(PhpProject phpProject, FileObject fileObject, String string) {
        assert (phpProject != null);
        assert (fileObject != null);
        FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
        String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent());
        assert (string2 != null) : String.format("Relative path must be found for sources %s and folder %s", fileObject2, fileObject.getParent());
        File file = new File(this.getTestDirectory(phpProject), string2.replace('/', File.separatorChar));
        return new File(file, string + "Test.php");
    }

    private File moveAndAdjustGeneratedFile(File file, File file2, File file3) {
        assert (file.isFile()) : "Generated files must exist: " + file;
        assert (!file2.exists()) : "Test file cannot exist: " + file2;
        try {
            FileUtil.createFolder((File)file2.getParentFile());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
            return file;
        }
        file2 = this.adjustFileContent(file, file2, file3, PhpUnit.getRequireOnce(file2, file3));
        if (file2 == null) {
            return null;
        }
        assert (file2.isFile()) : "Test file must exist: " + file2;
        try {
            PhpProjectUtils.reformatFile(file2);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Cannot reformat file " + file2, iOException);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File adjustFileContent(File file, File file2, File file3, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                try {
                    String string2;
                    boolean bl = false;
                    String string3 = file3.getName();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!bl && PhpUnit.isRequireOnceSourceFile(string2.trim(), string3)) {
                            bufferedWriter.write(String.format(REQUIRE_ONCE_TPL, string).replace("''.", ""));
                            bl = true;
                        } else {
                            bufferedWriter.write(string2);
                        }
                        bufferedWriter.newLine();
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            {
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
            return null;
        }
        if (!file.delete()) {
            LOGGER.info("Cannot delete generated file " + file);
        }
        return file2;
    }
}

