/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.Inflector;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;

final class ActiveRecordAssociationFinder {
    private static final String HAS_MANY = "has_many";
    private static final String HAS_MANY_POLYMORPHS = "has_many_polymorphs";
    private static final String HAS_AND_BELONGS_TO_MANY = "has_and_belongs_to_many";
    static final String[] AR_ASSOCIATIONS = new String[]{"belongs_to", "has_one", "has_many", "has_many_polymorphs", "has_and_belongs_to_many"};
    private final RubyIndex index;
    private final SymbolNode closest;
    private final Node root;
    private final AstPath path;

    public ActiveRecordAssociationFinder(RubyIndex rubyIndex, SymbolNode symbolNode, Node node, AstPath astPath) {
        this.index = rubyIndex;
        this.closest = symbolNode;
        this.root = node;
        this.path = astPath;
    }

    private Node findAssociationNode() {
        for (Node node : this.closest.childNodes()) {
            if (!AstUtilities.isActiveRecordAssociation(node)) continue;
            return node;
        }
        Iterator iterator = this.path.leafToRoot();
        while (iterator.hasNext()) {
            Node node;
            node = (Node)iterator.next();
            if (!AstUtilities.isActiveRecordAssociation(node)) continue;
            return node;
        }
        return null;
    }

    private static String getExplicitySpecifiedClassName(Node node) {
        if (node.childNodes().isEmpty() || HAS_MANY_POLYMORPHS.equals(AstUtilities.getName(node))) {
            return null;
        }
        ArrayNode arrayNode = (ArrayNode)node.childNodes().get(0);
        for (Node node2 : arrayNode.childNodes()) {
            Node node3;
            HashNode hashNode;
            if (!(node2 instanceof HashNode) || (hashNode = (HashNode)node2).childNodes().isEmpty() || (node3 = (Node)node2.childNodes().get(0)).childNodes().size() < 2) continue;
            for (int i = 0; i < node3.childNodes().size(); ++i) {
                Node node4 = (Node)node3.childNodes().get(i);
                if (!(node4 instanceof INameNode) || !"class_name".equals(AstUtilities.getName(node4)) || node3.childNodes().size() <= i + 1) continue;
                Node node5 = (Node)node3.childNodes().get(i + 1);
                if (node5 instanceof StrNode) {
                    return ((StrNode)node5).getValue();
                }
                return AstUtilities.getName(node5);
            }
        }
        return null;
    }

    static String getClassNameFor(Node node, SymbolNode symbolNode) {
        String string;
        String string2 = ActiveRecordAssociationFinder.getExplicitySpecifiedClassName(node);
        if (string2 == null) {
            string2 = AstUtilities.getName((Node)symbolNode);
            if (string2.length() == 0) {
                return string2;
            }
            string2 = RubyUtils.underlinedNameToCamel(string2);
        }
        if (HAS_MANY.equals(string = AstUtilities.getName(node)) || HAS_MANY_POLYMORPHS.equals(string) || HAS_AND_BELONGS_TO_MANY.equals(string)) {
            return Inflector.getDefault().singularize(string2);
        }
        return string2;
    }

    DeclarationFinder.DeclarationLocation findAssociationLocation() {
        Node node = this.findAssociationNode();
        if (node == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String string = ActiveRecordAssociationFinder.getClassNameFor(node, this.closest);
        if (string.length() == 0) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Set<IndexedClass> set = this.index.getSubClasses("ActiveRecord::Base", null, string, false);
        if (set.isEmpty()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>();
        for (IndexedClass indexedClass : set) {
            if (!indexedClass.getName().equals(string)) continue;
            hashSet.add(indexedClass);
        }
        return RubyDeclarationFinder.getLocation(hashSet);
    }
}

