/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Set;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;

final class HelpersFinder {
    private static final String[] HELPER_METHODS = new String[]{"helper"};
    private final RubyIndex index;
    private final SymbolNode closest;
    private final Node root;
    private final AstPath path;

    public HelpersFinder(RubyIndex rubyIndex, SymbolNode symbolNode, Node node, AstPath astPath) {
        this.index = rubyIndex;
        this.closest = symbolNode;
        this.root = node;
        this.path = astPath;
    }

    private boolean isHelper(Node node) {
        if (!AstUtilities.isCall(node)) {
            return false;
        }
        return AstUtilities.isNodeNameIn(node, HELPER_METHODS);
    }

    private boolean isHelper() {
        for (Node node : this.closest.childNodes()) {
            if (!this.isHelper(node)) continue;
            return true;
        }
        return this.isHelper(this.path.leafParent()) || this.isHelper(this.path.leafGrandParent());
    }

    private String getClassName() {
        String string = AstUtilities.getName((Node)this.closest);
        if (string.length() == 0) {
            return null;
        }
        return RubyUtils.underlinedNameToCamel(string) + "Helper";
    }

    DeclarationFinder.DeclarationLocation findHelperLocation() {
        if (!this.isHelper()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String string = this.getClassName();
        if (string == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Set<IndexedClass> set = this.index.getClasses(string, QuerySupport.Kind.EXACT, true, false, false);
        if (set.isEmpty()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        return RubyDeclarationFinder.getLocation(set);
    }
}

