/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.ZSuperNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.ActiveRecordAssociationFinder;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.HelpersFinder;
import org.netbeans.modules.ruby.RubyClassDeclarationFinder;
import org.netbeans.modules.ruby.RubyConstantDeclarationFinder;
import org.netbeans.modules.ruby.RubyDeclarationFinderHelper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyDeclarationFinder
extends RubyDeclarationFinderHelper
implements DeclarationFinder {
    private static int methodSelector = 0;
    private boolean ignoreAlias;
    private RubyIndex rubyIndex;
    private static final String PARTIAL = "partial";
    private static final String CONTROLLER = "controller";
    private static final String ACTION = "action";
    private static final String TEMPLATE = "template";
    private static final String[] RAILS_TARGET_RAW_NAMES = new String[]{"partial", "controller", "action", "template"};
    private static final List<String> RAILS_TARGETS = RubyDeclarationFinder.initRailsTargets();

    private static List<String> initRailsTargets() {
        ArrayList<String> arrayList = new ArrayList<String>(RAILS_TARGET_RAW_NAMES.length * 4);
        for (String string : RAILS_TARGET_RAW_NAMES) {
            arrayList.add(":" + string + " => ");
            arrayList.add(":" + string + "=> ");
            arrayList.add(":" + string + " =>");
            arrayList.add(":" + string + "=>");
        }
        return arrayList;
    }

    private RubyIndex getIndex(ParserResult parserResult) {
        if (this.rubyIndex == null) {
            this.rubyIndex = RubyIndex.get((Parser.Result)parserResult);
        }
        return this.rubyIndex;
    }

    public OffsetRange getReferenceSpan(Document document, int n) {
        Object object;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        BaseDocument baseDocument = (BaseDocument)document;
        FileObject fileObject = RubyUtils.getFileObject(document);
        if ((RubyUtils.isRhtmlDocument((Document)baseDocument) || fileObject != null && RubyUtils.isRailsProject(fileObject)) && (object = this.findRailsTarget(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n)) != null) {
            return object.range;
        }
        object = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (object == null) {
            return OffsetRange.NONE;
        }
        object.move(n);
        if (!object.moveNext() && !object.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == object.offset();
        OffsetRange offsetRange = this.getReferenceSpan((TokenSequence<?>)object, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && object.movePrevious()) {
            offsetRange = this.getReferenceSpan((TokenSequence<?>)object, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        String string;
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == RubyTokenId.IDENTIFIER && token.length() == 1 && tokenId == RubyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            return OffsetRange.NONE;
        }
        if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CLASS_VAR || tokenId == RubyTokenId.GLOBAL_VAR || tokenId == RubyTokenId.CONSTANT || tokenId == RubyTokenId.TYPE_SYMBOL || tokenId == RubyTokenId.INSTANCE_VAR || tokenId == RubyTokenId.SUPER) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded();
        if (tokenSequence2 != null) {
            tokenSequence = tokenSequence2;
            tokenSequence2.move(n);
            if (tokenSequence2.moveNext()) {
                Token token2 = tokenSequence2.token();
                if (token2.id() == RubyCommentTokenId.COMMENT_LINK) {
                    return new OffsetRange(tokenSequence2.offset(), tokenSequence2.offset() + token2.length());
                }
                string = this.getReferenceSpan(tokenSequence2, tokenHierarchy, n);
                if (string != OffsetRange.NONE) {
                    return string;
                }
            }
        }
        if (tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.STRING_LITERAL) {
            String string2;
            int n2 = LexUtilities.getRequireStringOffset(n, tokenHierarchy);
            if (n2 != -1 && (string = LexUtilities.getStringAt(n, tokenHierarchy)) != null) {
                return new OffsetRange(n2, n2 + string.length());
            }
            int n3 = LexUtilities.getClassNameStringOffset(n, tokenHierarchy);
            if (n3 != -1 && (string2 = LexUtilities.getStringAt(n, tokenHierarchy)) != null) {
                return new OffsetRange(n3, n3 + string2.length());
            }
        }
        return OffsetRange.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, int n) {
        try {
            int n2;
            OffsetRange offsetRange;
            BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult, true);
            if (baseDocument == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            BaseDocument baseDocument2 = baseDocument;
            int n3 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
            if (n3 == -1) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean bl = RubyUtils.isRhtmlFile(RubyUtils.getFileObject((Parser.Result)parserResult));
            if ((bl || RubyUtils.isRailsProject(RubyUtils.getFileObject((Parser.Result)parserResult))) && (offsetRange = this.findRailsFile(parserResult, baseDocument2, (TokenHierarchy<Document>)tokenHierarchy, n, n3, bl)) != DeclarationFinder.DeclarationLocation.NONE) {
                return offsetRange;
            }
            offsetRange = this.getReferenceSpan((Document)baseDocument2, n);
            if (offsetRange == OffsetRange.NONE) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean bl2 = offsetRange.getEnd() <= n;
            Node node = AstUtilities.getRoot((Parser.Result)parserResult);
            RubyIndex rubyIndex = this.getIndex(parserResult);
            if (node == null) {
                DeclarationFinder.DeclarationLocation declarationLocation;
                String string = baseDocument2.getText(offsetRange.getStart(), offsetRange.getLength());
                if (rubyIndex == null) return DeclarationFinder.DeclarationLocation.NONE;
                if (string.length() == 0) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                if (Character.isUpperCase(string.charAt(0))) {
                    Set<IndexedClass> set = rubyIndex.getClasses(string, QuerySupport.Kind.EXACT, true, false, false);
                    if (set.size() == 0) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    RubyClassDeclarationFinder rubyClassDeclarationFinder = new RubyClassDeclarationFinder(null, null, null, rubyIndex, null);
                    DeclarationFinder.DeclarationLocation declarationLocation2 = rubyClassDeclarationFinder.getElementDeclaration(set, null);
                    if (declarationLocation2 == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return declarationLocation2;
                }
                Set<IndexedMethod> set = rubyIndex.getMethods(string, (String)null, QuerySupport.Kind.EXACT);
                if (set.size() == 0) {
                    set = rubyIndex.getMethods(string, QuerySupport.Kind.EXACT);
                }
                if ((declarationLocation = this.getMethodDeclaration(parserResult, string, set, null, null, rubyIndex, n3, n)) == null) return DeclarationFinder.DeclarationLocation.NONE;
                return declarationLocation;
            }
            int n4 = n;
            if (bl2 && n4 > 0) {
                --n4;
            }
            if ((n2 = LexUtilities.getRequireStringOffset(n4, (TokenHierarchy<Document>)tokenHierarchy)) != -1) {
                String string = LexUtilities.getStringAt(n4, (TokenHierarchy<Document>)tokenHierarchy);
                if (string == null) return DeclarationFinder.DeclarationLocation.NONE;
                FileObject fileObject = rubyIndex.getRequiredFile(string);
                if (fileObject == null) return DeclarationFinder.DeclarationLocation.NONE;
                return new DeclarationFinder.DeclarationLocation(fileObject, 0);
            }
            AstPath astPath = new AstPath(node, n3);
            Node node2 = astPath.leaf();
            if (node2 == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            DeclarationFinder.DeclarationLocation declarationLocation = this.findRDocMethod(parserResult, (Document)baseDocument2, n3, n, node, astPath, node2, rubyIndex);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                return RubyDeclarationFinder.fix(declarationLocation, parserResult);
            }
            if (node2 instanceof LocalVarNode || node2 instanceof LocalAsgnNode) {
                String string = ((INameNode)node2).getName();
                Node node3 = AstUtilities.findLocalScope(node2, astPath);
                return RubyDeclarationFinder.fix(this.findLocal(parserResult, node3, string), parserResult);
            }
            if (node2 instanceof DVarNode) {
                String string = ((DVarNode)node2).getName();
                Node node4 = AstUtilities.findDynamicScope(node2, astPath);
                return RubyDeclarationFinder.fix(this.findDynamic(parserResult, node4, string), parserResult);
            }
            if (node2 instanceof DAsgnNode) {
                String string = ((INameNode)node2).getName();
                Node node5 = AstUtilities.findDynamicScope(node2, astPath);
                return RubyDeclarationFinder.fix(this.findDynamic(parserResult, node5, string), parserResult);
            }
            if (node2 instanceof InstVarNode) {
                String string = ((INameNode)node2).getName();
                return this.findInstanceFromIndex(parserResult, string, astPath, rubyIndex, false);
            }
            if (node2 instanceof ClassVarNode) {
                String string = ((INameNode)node2).getName();
                return this.findInstanceFromIndex(parserResult, string, astPath, rubyIndex, false);
            }
            if (node2 instanceof GlobalVarNode) {
                String string = ((GlobalVarNode)node2).getName();
                return RubyDeclarationFinder.fix(this.findGlobal(parserResult, node, string), parserResult);
            }
            if (node2 instanceof FCallNode || node2 instanceof VCallNode || node2 instanceof CallNode) {
                Object object;
                Object object2;
                String string = ((INameNode)node2).getName();
                Call call = Call.getCallType(baseDocument2, (TokenHierarchy<Document>)tokenHierarchy, n);
                RubyType rubyType = call.getType();
                String string2 = call.getLhs();
                if (!rubyType.isKnown() && string2 != null && node2 != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node2, astPath)) != null) {
                    object = new ContextKnowledge(rubyIndex, node, (Node)object2, n3, n, parserResult);
                    RubyTypeInferencer rubyTypeInferencer = RubyTypeInferencer.create((ContextKnowledge)object);
                    rubyType = rubyTypeInferencer.inferType(string2);
                }
                if (!rubyType.isKnown()) {
                    if (string.equals("new")) {
                        string = "initialize";
                    }
                    if ((object = RubyDeclarationFinder.fix(this.findMethod(parserResult, node, string, (Arity)(object2 = Arity.getCallArity(node2))), parserResult)) != DeclarationFinder.DeclarationLocation.NONE) {
                        return object;
                    }
                }
                object2 = AstUtilities.getFqnName(astPath);
                if (call != Call.LOCAL) return this.findMethod(string, (String)object2, rubyType, call, parserResult, n3, n, astPath, node2, rubyIndex);
                if (object2 == null) return this.findMethod(string, (String)object2, rubyType, call, parserResult, n3, n, astPath, node2, rubyIndex);
                if (((String)object2).length() != 0) return this.findMethod(string, (String)object2, rubyType, call, parserResult, n3, n, astPath, node2, rubyIndex);
                object2 = "Object";
                return this.findMethod(string, (String)object2, rubyType, call, parserResult, n3, n, astPath, node2, rubyIndex);
            }
            if (node2 instanceof ConstNode || node2 instanceof Colon2Node) {
                RubyClassDeclarationFinder rubyClassDeclarationFinder = new RubyClassDeclarationFinder(parserResult, node, astPath, rubyIndex, node2);
                DeclarationFinder.DeclarationLocation declarationLocation3 = rubyClassDeclarationFinder.findClassDeclaration();
                if (declarationLocation3 != DeclarationFinder.DeclarationLocation.NONE) {
                    return declarationLocation3;
                }
                RubyConstantDeclarationFinder rubyConstantDeclarationFinder = new RubyConstantDeclarationFinder(parserResult, node, astPath, rubyIndex, node2);
                return rubyConstantDeclarationFinder.findConstantDeclaration();
            }
            if (node2 instanceof SymbolNode) {
                RubyClassDeclarationFinder rubyClassDeclarationFinder;
                Node node6;
                Arity arity;
                String string = ((SymbolNode)node2).getName();
                DeclarationFinder.DeclarationLocation declarationLocation4 = this.findMethod(parserResult, node, string, arity = Arity.UNKNOWN);
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = new ActiveRecordAssociationFinder(rubyIndex, (SymbolNode)node2, node, astPath).findAssociationLocation();
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = new HelpersFinder(rubyIndex, (SymbolNode)node2, node, astPath).findHelperLocation();
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = this.findInstance(parserResult, node, string, rubyIndex);
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = this.findClassVar(parserResult, node, string);
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = this.findGlobal(parserResult, node, string);
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE && (node6 = (rubyClassDeclarationFinder = new RubyClassDeclarationFinder()).findClass(node, ((INameNode)node2).getName(), this.ignoreAlias)) != null) {
                    declarationLocation4 = RubyDeclarationFinder.getLocation(parserResult, node6);
                }
                if (declarationLocation4 == DeclarationFinder.DeclarationLocation.NONE) {
                    declarationLocation4 = this.findInstanceMethodsFromIndex(parserResult, string, astPath, rubyIndex);
                }
                if (declarationLocation4 != DeclarationFinder.DeclarationLocation.NONE) return RubyDeclarationFinder.fix(declarationLocation4, parserResult);
                declarationLocation4 = this.findInstanceFromIndex(parserResult, string, astPath, rubyIndex, true);
                return RubyDeclarationFinder.fix(declarationLocation4, parserResult);
            }
            if (node2 instanceof AliasNode) {
                AliasNode aliasNode = (AliasNode)node2;
                String string = aliasNode.getNewName();
                int n5 = string.length();
                int n6 = aliasNode.getPosition().getStartOffset();
                if (n3 <= n6 + 6) return DeclarationFinder.DeclarationLocation.NONE;
                if (n3 <= n6 + 6 + n5) return new DeclarationFinder.DeclarationLocation(RubyUtils.getFileObject((Parser.Result)parserResult), n6 + 4);
                String string3 = aliasNode.getOldName();
                this.ignoreAlias = true;
                try {
                    RubyClassDeclarationFinder rubyClassDeclarationFinder;
                    Node node7;
                    DeclarationFinder.DeclarationLocation declarationLocation5 = this.findLocal(parserResult, AstUtilities.findLocalScope(node2, astPath), string3);
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation5 = this.findDynamic(parserResult, AstUtilities.findDynamicScope(node2, astPath), string3);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation5 = this.findMethod(parserResult, node, string3, Arity.UNKNOWN);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation5 = this.findInstance(parserResult, node, string3, rubyIndex);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation5 = this.findClassVar(parserResult, node, string3);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation5 = this.findGlobal(parserResult, node, string3);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE && (node7 = (rubyClassDeclarationFinder = new RubyClassDeclarationFinder()).findClass(node, string3, this.ignoreAlias)) != null) {
                        declarationLocation5 = RubyDeclarationFinder.getLocation(parserResult, node7);
                    }
                    if (declarationLocation5 == DeclarationFinder.DeclarationLocation.NONE) {
                        rubyClassDeclarationFinder = declarationLocation5;
                        return rubyClassDeclarationFinder;
                    }
                    rubyClassDeclarationFinder = RubyDeclarationFinder.fix(declarationLocation5, parserResult);
                    return rubyClassDeclarationFinder;
                }
                finally {
                    this.ignoreAlias = false;
                }
            }
            if (node2 instanceof ArgumentNode) {
                String string = ((ArgumentNode)node2).getName();
                Node node8 = astPath.leafParent();
                if (node8 == null) return DeclarationFinder.DeclarationLocation.NONE;
                if (node8 instanceof MethodDefNode) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                Node node9 = AstUtilities.findLocalScope(node2, astPath);
                return RubyDeclarationFinder.fix(this.findLocal(parserResult, node9, string), parserResult);
            }
            if (node2 instanceof StrNode) {
                int n7 = LexUtilities.getClassNameStringOffset(n3, (TokenHierarchy<Document>)tokenHierarchy);
                if (n7 == -1) return DeclarationFinder.DeclarationLocation.NONE;
                String string = LexUtilities.getStringAt(n4, (TokenHierarchy<Document>)tokenHierarchy);
                if (string == null) return DeclarationFinder.DeclarationLocation.NONE;
                return RubyDeclarationFinder.getLocation(rubyIndex.getClasses(string, QuerySupport.Kind.EXACT, true, false, false));
            }
            if (!(node2 instanceof SuperNode)) {
                if (!(node2 instanceof ZSuperNode)) return DeclarationFinder.DeclarationLocation.NONE;
            }
            Node node10 = AstUtilities.findLocalScope(node2, astPath);
            String string = AstUtilities.getFqnName(astPath);
            switch (node10.getNodeType()) {
                case SCLASSNODE: 
                case MODULENODE: 
                case CLASSNODE: {
                    IndexedClass indexedClass = rubyIndex.getSuperclass(string);
                    if (indexedClass == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return RubyDeclarationFinder.getLocation(Collections.singleton(indexedClass));
                }
                case DEFNNODE: 
                case DEFSNODE: {
                    MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
                    IndexedMethod indexedMethod = rubyIndex.getSuperMethod(string, methodDefNode.getName(), true);
                    if (indexedMethod == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return RubyDeclarationFinder.getLocation(Collections.singleton(indexedMethod));
                }
            }
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public static DeclarationFinder.DeclarationLocation getTestDeclaration(FileObject fileObject, String string, boolean bl) {
        return RubyDeclarationFinder.getTestDeclaration(fileObject, string, bl, true);
    }

    public static DeclarationFinder.DeclarationLocation getTestDeclaration(FileObject fileObject, String string, boolean bl, boolean bl2) {
        int n = string.indexOf(47);
        if (n == -1) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        RubyIndex rubyIndex = RubyIndex.get(QuerySupport.findRoots((FileObject)fileObject, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
        if (rubyIndex == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Set<IndexedMethod> set = rubyIndex.getMethods(string3, string2, QuerySupport.Kind.EXACT);
        DeclarationFinder.DeclarationLocation declarationLocation = RubyDeclarationFinder.getLocation(set);
        if (!bl) {
            if (DeclarationFinder.DeclarationLocation.NONE == declarationLocation && !bl2) {
                declarationLocation = RubyDeclarationFinder.getLocation(rubyIndex.getMethods(string3, QuerySupport.Kind.EXACT));
            }
            return declarationLocation;
        }
        Set<IndexedClass> set2 = rubyIndex.getClasses(string2, QuerySupport.Kind.EXACT, false, false, true, null);
        DeclarationFinder.DeclarationLocation declarationLocation2 = RubyDeclarationFinder.getLocation(set2);
        if (DeclarationFinder.DeclarationLocation.NONE == declarationLocation && bl) {
            return declarationLocation2;
        }
        if (declarationLocation.getFileObject().equals(declarationLocation2.getFileObject())) {
            return declarationLocation2;
        }
        for (DeclarationFinder.AlternativeLocation alternativeLocation : declarationLocation2.getAlternativeLocations()) {
            if (!declarationLocation.getFileObject().equals(alternativeLocation.getLocation().getFileObject())) continue;
            return alternativeLocation.getLocation();
        }
        return declarationLocation2;
    }

    static DeclarationFinder.DeclarationLocation getLocation(Set<? extends IndexedElement> set) {
        DeclarationFinder.DeclarationLocation declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
        for (IndexedElement indexedElement : set) {
            FileObject fileObject = indexedElement.getFileObject();
            if (fileObject == null) continue;
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                int n = -1;
                Node node = AstUtilities.getForeignNode(indexedElement);
                if (node != null) {
                    n = AstUtilities.getRange(node).getStart();
                }
                declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, n, (ElementHandle)indexedElement);
                declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new RubyDeclarationFinderHelper.RubyAltLocation(indexedElement, false));
                continue;
            }
            RubyDeclarationFinderHelper.RubyAltLocation rubyAltLocation = new RubyDeclarationFinderHelper.RubyAltLocation(indexedElement, false);
            declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)rubyAltLocation);
        }
        return declarationLocation;
    }

    private DeclarationFinder.DeclarationLocation findRailsFile(ParserResult parserResult, BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n, int n2, boolean bl) {
        RailsTarget railsTarget = this.findRailsTarget(baseDocument, tokenHierarchy, n);
        if (railsTarget != null) {
            String string = railsTarget.type;
            if (string.indexOf(PARTIAL) != -1 || string.indexOf(TEMPLATE) != -1) {
                String string2;
                FileObject fileObject;
                Object object;
                boolean bl2 = string.indexOf(TEMPLATE) != -1;
                int n3 = railsTarget.name.lastIndexOf(47);
                if (n3 != -1) {
                    object = RubyUtils.getAppDir(RubyUtils.getFileObject((Parser.Result)parserResult));
                    if (object == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    String[] stringArray = railsTarget.name.substring(0, n3);
                    fileObject = object.getFileObject("views/" + (String)stringArray);
                    if (fileObject == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    string2 = railsTarget.name.substring(n3 + 1);
                } else {
                    fileObject = RubyUtils.getFileObject((Parser.Result)parserResult).getParent();
                    string2 = railsTarget.name;
                }
                if (!bl2) {
                    string2 = "_" + string2;
                }
                if ((object = fileObject.getFileObject(string2)) == null) {
                    for (String string3 : RubyUtils.RUBY_VIEW_EXTS) {
                        object = fileObject.getFileObject(string2 + string3);
                        if (object != null) break;
                    }
                }
                if (object == null) {
                    for (String string3 : fileObject.getChildren()) {
                        if (!string3.isValid() || string3.isFolder() || !string3.getName().equals(string2)) continue;
                        object = string3;
                        break;
                    }
                }
                if (object != null) {
                    return new DeclarationFinder.DeclarationLocation(object, 0);
                }
            } else if (string.indexOf(CONTROLLER) != -1 || string.indexOf(ACTION) != -1) {
                FileObject fileObject;
                FileObject fileObject2;
                FileObject fileObject3 = RubyUtils.getFileObject((Parser.Result)parserResult);
                fileObject3 = fileObject3.getParent();
                String string4 = null;
                String string5 = fileObject3.getName();
                boolean bl3 = string.indexOf(CONTROLLER) != -1;
                String string6 = "";
                if (bl3) {
                    string6 = railsTarget.name;
                } else if (!string5.startsWith("_")) {
                    string6 = string5;
                    string4 = RubyUtils.getFileObject((Parser.Result)parserResult).getName();
                }
                int n4 = railsTarget.range.getStart() - n;
                String[] stringArray = this.findControllerAction(parserResult, n + n4, n2 + n4);
                if (stringArray[0] != null) {
                    string6 = stringArray[0];
                }
                if (stringArray[1] != null) {
                    string4 = stringArray[1];
                }
                if (!bl) {
                    String string7 = null;
                    string7 = stringArray[0] != null ? stringArray[0] : (bl3 ? railsTarget.name : RubyUtils.getFileObject((Parser.Result)parserResult).getName());
                    return this.findActionLocation(RubyDeclarationFinder.asControllerClass(string7), string4, parserResult);
                }
                for (fileObject2 = fileObject3.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                    if (fileObject2.getName().equals("views") && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                        fileObject2 = fileObject2.getParent();
                        break;
                    }
                    string6 = fileObject2.getNameExt() + "/" + string6;
                }
                if (fileObject2 != null && (fileObject = fileObject2.getFileObject("controllers/" + string6 + "_controller.rb")) != null) {
                    int n3 = 0;
                    if (string4 != null && (n3 = AstUtilities.findOffset(fileObject, string4)) < 0) {
                        n3 = 0;
                    }
                    return new DeclarationFinder.DeclarationLocation(fileObject, n3);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static String asControllerClass(String string) {
        String string2 = string.endsWith("_controller") ? "" : "_controller";
        return RubyUtils.underlinedNameToCamel(string + string2);
    }

    private DeclarationFinder.DeclarationLocation findActionLocation(String string, String string2, ParserResult parserResult) {
        RubyIndex rubyIndex = this.getIndex(parserResult);
        Set<IndexedMethod> set = rubyIndex.getMethods(string2, string, QuerySupport.Kind.EXACT);
        return RubyDeclarationFinder.getLocation(set);
    }

    private String[] findControllerAction(ParserResult parserResult, int n, int n2) {
        String[] stringArray = new String[2];
        Node node = AstUtilities.getRoot((Parser.Result)parserResult);
        if (node == null) {
            return stringArray;
        }
        AstPath astPath = new AstPath(node, n2);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        Node node2 = null;
        while (listIterator.hasNext()) {
            Node node3 = (Node)listIterator.next();
            if (node3 instanceof HashNode && node2 instanceof ListNode) {
                List list = node2.childNodes();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node4;
                    String string = null;
                    String string2 = null;
                    Node node5 = (Node)iterator.next();
                    if (node5 instanceof SymbolNode) {
                        string = ((SymbolNode)node5).getName();
                    }
                    if (iterator.hasNext() && (node4 = (Node)iterator.next()) instanceof StrNode) {
                        string2 = ((StrNode)node4).getValue().toString();
                    }
                    if (CONTROLLER.equals(string)) {
                        stringArray[0] = string2;
                        continue;
                    }
                    if (!ACTION.equals(string)) continue;
                    stringArray[1] = string2;
                }
                break;
            }
            node2 = node3;
        }
        return stringArray;
    }

    private boolean fastCheckIsRailsTarget(String string) {
        for (String string2 : RAILS_TARGET_RAW_NAMES) {
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RailsTarget findRailsTarget(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        block15: {
            try {
                baseDocument.readLock();
                int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n2 == -1) break block15;
                int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string = baseDocument.getText(n2, n3 - n2);
                if (!this.fastCheckIsRailsTarget(string)) {
                    RailsTarget railsTarget = null;
                    return railsTarget;
                }
                for (String string2 : RAILS_TARGETS) {
                    String string3;
                    Token token;
                    StringBuilder stringBuilder;
                    int n4 = string.indexOf(string2);
                    if (n4 == -1) continue;
                    int n5 = n2 + n4 + string2.length();
                    TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n5);
                    if (tokenSequence == null) {
                        stringBuilder = null;
                        return stringBuilder;
                    }
                    tokenSequence.move(n5);
                    stringBuilder = new StringBuilder();
                    boolean bl = false;
                    while (tokenSequence.moveNext() && tokenSequence.offset() < n3) {
                        bl = true;
                        token = tokenSequence.token();
                        string3 = token.id();
                        if (string3 == RubyTokenId.STRING_LITERAL || string3 == RubyTokenId.QUOTED_STRING_LITERAL) {
                            stringBuilder.append(((Object)token.text()).toString());
                        }
                        if ("string".equals(string3.primaryCategory())) continue;
                        break;
                    }
                    if (!bl) {
                        token = null;
                        return token;
                    }
                    int n6 = tokenSequence.offset();
                    string3 = stringBuilder.toString();
                    if (n > n6 || n < n2 + n4) continue;
                    OffsetRange offsetRange = new OffsetRange(n2 + n4, n6);
                    RailsTarget railsTarget = new RailsTarget(string2, string3, offsetRange);
                    return railsTarget;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findMethod(String string, String string2, RubyType rubyType, Call call, ParserResult parserResult, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        Set<IndexedMethod> set = this.getApplicableMethods(string, string2, rubyType, call, rubyIndex);
        int n3 = n;
        DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(parserResult, string, set, astPath, node, rubyIndex, n3, n2);
        return declarationLocation;
    }

    private Set<IndexedMethod> getApplicableMethods(String string, String string2, RubyType rubyType, Call call, RubyIndex rubyIndex) {
        int n;
        Set<IndexedMethod> set = new HashSet<IndexedMethod>();
        String string3 = string2;
        if (!rubyType.isKnown() && string2 != null && call.getLhs() == null && call != Call.UNKNOWN) {
            string3 = string2;
            while (set.size() == 0 && string3.length() > 0) {
                set = rubyIndex.getInheritedMethods(string3, string, QuerySupport.Kind.EXACT);
                n = string3.lastIndexOf("::");
                if (n == -1) break;
                string3 = string3.substring(0, n);
            }
        }
        if (rubyType.isKnown() && set.size() == 0) {
            for (string3 = string2; set.size() == 0 && string3 != null && string3.length() > 0; string3 = string3.substring(0, n)) {
                for (String string4 : rubyType.getRealTypes()) {
                    set.addAll(rubyIndex.getInheritedMethods(string3 + "::" + string4, string, QuerySupport.Kind.EXACT));
                }
                n = string3.lastIndexOf("::");
                if (n == -1) break;
            }
            if (set.size() == 0) {
                for (String string4 : rubyType.getRealTypes()) {
                    set.addAll(rubyIndex.getInheritedMethods(string4, string, QuerySupport.Kind.EXACT));
                }
                if (set.size() == 0) {
                    for (String string5 : rubyType.getRealTypes()) {
                        assert (string5 != null) : "Should not be null";
                        if (string5.indexOf("::") != -1) continue;
                        Set<IndexedClass> set2 = rubyIndex.getClasses(string5, QuerySupport.Kind.EXACT, false, false, false);
                        HashSet<String> hashSet = new HashSet<String>();
                        for (IndexedClass indexedClass : set2) {
                            String string6 = indexedClass.getFqn();
                            if (string6 == null) continue;
                            hashSet.add(string6);
                        }
                        for (String string7 : hashSet) {
                            if (string7.equals(string5)) continue;
                            set.addAll(rubyIndex.getInheritedMethods(string7, string, QuerySupport.Kind.EXACT));
                        }
                    }
                }
            }
            if (set.size() == 0) {
                set.addAll(rubyIndex.getMethods(string, QuerySupport.Kind.EXACT));
            }
        }
        if (set.size() == 0) {
            if (!rubyType.isKnown()) {
                set.addAll(rubyIndex.getMethods(string, QuerySupport.Kind.EXACT));
            } else {
                set.addAll(rubyIndex.getMethods(string, rubyType, QuerySupport.Kind.EXACT));
            }
            if (set.size() == 0 && rubyType.isKnown()) {
                set = rubyIndex.getMethods(string, QuerySupport.Kind.EXACT);
            }
        }
        return set;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(ParserResult parserResult, String string, Set<IndexedMethod> set, AstPath astPath, Node node, RubyIndex rubyIndex, int n, int n2) {
        BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
        if (baseDocument == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, baseDocument, n, n2, astPath, node, rubyIndex);
        if (indexedMethod != null) {
            FileObject fileObject = indexedMethod.getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Node node2 = AstUtilities.getForeignNode(indexedMethod);
            int n3 = node2 != null ? node2.getPosition().getStartOffset() : 0;
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, n3, (ElementHandle)indexedMethod);
            if (!CHOOSE_ONE_DECLARATION && set.size() > 1) {
                int n4 = 0;
                for (IndexedMethod indexedMethod2 : set) {
                    if (indexedMethod2.isNoDoc()) continue;
                    ++n4;
                }
                if (n4 >= 2) {
                    for (IndexedMethod indexedMethod2 : set) {
                        declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new RubyDeclarationFinderHelper.RubyAltLocation(indexedMethod2, indexedMethod2 == indexedMethod));
                    }
                }
            }
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public IndexedMethod findMethodDeclaration(Parser.Result result, Node node, AstPath astPath, Set<IndexedMethod>[] setArray) {
        int n = AstUtilities.getCallRange(node).getStart();
        try {
            Object object;
            Object object2;
            BaseDocument baseDocument = RubyUtils.getDocument(result);
            if (baseDocument == null) {
                return null;
            }
            int n2 = LexUtilities.getLexerOffset(result, n);
            if (n2 == -1) {
                return null;
            }
            OffsetRange offsetRange = this.getReferenceSpan((Document)baseDocument, n2);
            if (offsetRange == OffsetRange.NONE) {
                return null;
            }
            boolean bl = offsetRange.getEnd() <= n;
            Node node2 = AstUtilities.getRoot(result);
            RubyIndex rubyIndex = RubyIndex.get(result);
            if (node2 == null) {
                String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                if (rubyIndex == null || string.length() == 0) {
                    return null;
                }
                if (Character.isUpperCase(string.charAt(0))) {
                    return null;
                }
                Set<IndexedMethod> set = rubyIndex.getMethods(string, QuerySupport.Kind.EXACT);
                BaseDocument baseDocument2 = baseDocument;
                IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, baseDocument2, n, n2, null, null, rubyIndex);
                return indexedMethod;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            int n3 = n;
            if (bl && n3 > 0) {
                --n3;
            }
            String string = ((INameNode)node).getName();
            String string2 = AstUtilities.getFqnName(astPath);
            if (string2 == null || string2.length() == 0) {
                string2 = "Object";
            }
            Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n2);
            boolean bl2 = true;
            boolean bl3 = call.isMethodExpected();
            boolean bl4 = call.isStatic();
            RubyType rubyType = call.getType();
            String string3 = call.getLhs();
            QuerySupport.Kind kind = QuerySupport.Kind.EXACT;
            Node node3 = node;
            if (!rubyType.isKnown() && string3 != null && node3 != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node3, astPath)) != null) {
                object = new ContextKnowledge(rubyIndex, node2, (Node)object2, n, n2, AstUtilities.getParseResult(result));
                RubyTypeInferencer rubyTypeInferencer = RubyTypeInferencer.create((ContextKnowledge)object);
                rubyType = rubyTypeInferencer.inferType(string3);
            }
            if (rubyType.isKnown()) {
                if ("self".equals(string3)) {
                    rubyType = RubyType.create(string2);
                    bl2 = false;
                } else if ("super".equals(string3)) {
                    bl2 = false;
                    object2 = rubyIndex.getSuperclass(string2);
                    if (object2 != null) {
                        rubyType = RubyType.create(((IndexedElement)object2).getFqn());
                    } else {
                        object = AstUtilities.findClass(astPath);
                        if (object != null) {
                            rubyType = RubyType.create(AstUtilities.getSuperclass(object));
                        }
                    }
                    if (!rubyType.isKnown()) {
                        rubyType = RubyType.OBJECT;
                    }
                }
            }
            if (call == Call.LOCAL && string2 != null && string2.length() == 0) {
                string2 = "Object";
            }
            object2 = this.getApplicableMethods(string, string2, rubyType, call, rubyIndex);
            if (string.equals("new")) {
                object = this.getApplicableMethods("initialize", string2, rubyType, call, rubyIndex);
                object2.addAll(object);
            }
            object = this.findBestMethodMatch(string, (Set<IndexedMethod>)object2, baseDocument, n, n2, astPath, node, rubyIndex);
            if (setArray != null) {
                setArray[0] = object2;
            }
            return object;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private DeclarationFinder.DeclarationLocation findRDocMethod(ParserResult parserResult, Document document, int n, int n2, Node node, AstPath astPath, Node node2, RubyIndex rubyIndex) {
        block9: {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((BaseDocument)document, n2);
            if (tokenSequence == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Token token = tokenSequence.token();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                tokenSequence = tokenSequence2;
                tokenSequence2.move(n2);
                if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                token = tokenSequence2.token();
            }
            if (token != null && token.id() == RubyCommentTokenId.COMMENT_LINK) {
                String string = ((Object)token.text()).toString();
                if (string.startsWith("#")) {
                    DeclarationFinder.DeclarationLocation declarationLocation = this.findMethod(parserResult, node, string = string.substring(1), Arity.UNKNOWN);
                    if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation = this.findInstance(parserResult, node, "@" + string, rubyIndex);
                    }
                    return declarationLocation;
                }
                try {
                    URL uRL = new URL(string);
                    return new DeclarationFinder.DeclarationLocation(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    int n3 = string.indexOf("#");
                    if (n3 == -1 || n3 >= string.length() - 1) break block9;
                    String string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                    return this.findMethod(string, null, RubyType.create(string2), Call.UNKNOWN, parserResult, n, n2, astPath, node2, rubyIndex);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    DeclarationFinder.DeclarationLocation findLinkedMethod(ParserResult parserResult, String string) {
        Node node = AstUtilities.getRoot((Parser.Result)parserResult);
        AstPath astPath = new AstPath();
        astPath.descend(node);
        Node node2 = node;
        int n = 0;
        int n2 = 0;
        RubyIndex rubyIndex = this.getIndex(parserResult);
        if (node == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (string.startsWith("#")) {
            DeclarationFinder.DeclarationLocation declarationLocation = this.findMethod(parserResult, node, string = string.substring(1), Arity.UNKNOWN);
            if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                declarationLocation = this.findInstance(parserResult, node, "@" + string, rubyIndex);
            }
            return declarationLocation;
        }
        try {
            URL uRL = new URL(string);
            return new DeclarationFinder.DeclarationLocation(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            int n3 = string.indexOf("#");
            if (n3 != -1 && n3 < string.length() - 1) {
                String string2 = string.substring(0, n3);
                string = string.substring(n3 + 1);
                return this.findMethod(string, null, RubyType.create(string2), Call.UNKNOWN, parserResult, n, n2, astPath, node2, rubyIndex);
            }
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    IndexedMethod findBestMethodMatch(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>(set);
        while (!hashSet.isEmpty()) {
            IndexedMethod indexedMethod = this.findBestMethodMatchHelper(string, hashSet, baseDocument, n, n2, astPath, node, rubyIndex);
            Node node2 = AstUtilities.getForeignNode(indexedMethod);
            if (node2 != null) {
                return indexedMethod;
            }
            if (!hashSet.contains(indexedMethod)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedMethod);
        }
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IndexedMethod findBestMethodMatchHelper(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, Node node, RubyIndex rubyIndex) {
        void var13_19;
        Object object;
        Object object22;
        Object object32;
        Object object4;
        Node node2;
        Set<Object> set2 = new HashSet<Object>();
        if (node instanceof CallNode) {
            node2 = ((CallNode)node).getReceiverNode();
            object4 = null;
            if (node2 instanceof Colon2Node) {
                object4 = AstUtilities.getFqn((Colon2Node)node2);
            } else if (node2 instanceof ConstNode) {
                object4 = ((ConstNode)node2).getName();
            }
            if (object4 != null) {
                while (object4 != null && ((String)object4).length() > 0) {
                    for (IndexedMethod indexedMethod : set) {
                        if (!((String)object4).equals(indexedMethod.getClz())) continue;
                        set2.add(indexedMethod);
                    }
                    IndexedClass indexedClass = rubyIndex.getSuperclass((String)object4);
                    if (indexedClass == null) break;
                    object4 = indexedClass.getSignature();
                }
            }
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        node2 = TokenHierarchy.get((Document)baseDocument);
        object4 = Call.getCallType(baseDocument, (TokenHierarchy<Document>)node2, n2);
        boolean bl = true;
        if (astPath != null && node != null && object4 != Call.LOCAL && object4 != Call.NONE) {
            boolean bl2 = ((Call)object4).isStatic();
            set2 = new HashSet();
            Object object5 = ((Call)object4).getType();
            if (((RubyType)object5).isKnown()) {
                object32 = ((Call)object4).getLhs();
                object22 = AstUtilities.getFqnName(astPath);
                if ("self".equals(object32)) {
                    object5 = RubyType.create((String)object22);
                    bl = false;
                } else if ("super".equals(object32)) {
                    bl = false;
                    IndexedClass indexedClass = rubyIndex.getSuperclass((String)object22);
                    if (indexedClass != null) {
                        object5 = RubyType.create(indexedClass.getFqn());
                    } else {
                        object = AstUtilities.findClass(astPath);
                        if (object != null) {
                            object5 = RubyType.create(AstUtilities.getSuperclass(object));
                        }
                    }
                }
                if (((RubyType)object5).isKnown()) {
                    while (set2.size() == 0) {
                        set2 = rubyIndex.getInheritedMethods((String)object22 + "::" + object5, string, QuerySupport.Kind.EXACT);
                        int n3 = ((String)object22).lastIndexOf("::");
                        if (n3 == -1) break;
                        object22 = ((String)object22).substring(0, n3);
                    }
                    if (set2.size() == 0) {
                        set2 = rubyIndex.getInheritedMethods((RubyType)object5, string, QuerySupport.Kind.EXACT);
                    }
                }
            }
            if (bl || bl2) {
                object32 = new HashSet();
                for (IndexedMethod indexedMethod : set2) {
                    if (bl && indexedMethod.isPrivate() && !"new".equals(indexedMethod.getName()) || bl2 && !indexedMethod.isStatic()) continue;
                    object32.add(indexedMethod);
                }
                set2 = object32;
            }
            if (object5 != null) {
                object32 = new HashSet<IndexedMethod>();
                for (IndexedMethod indexedMethod : set2) {
                    if (indexedMethod.getIn() == null || !((RubyType)object5).isSingleton() || !indexedMethod.getIn().endsWith(((RubyType)object5).first())) continue;
                    object32.add((IndexedMethod)indexedMethod);
                }
                if (object32.size() < set2.size()) {
                    set2 = object32;
                }
            }
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        set2 = new HashSet();
        for (Object object5 : set) {
            object32 = ((IndexedMethod)object5).getEncodedAttributes();
            if (object32 == null || ((String)object32).length() <= 3) continue;
            set2.add(object5);
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        Object var13_17 = null;
        if (astPath != null) {
            set2 = new HashSet();
            Set<String> set3 = AstUtilities.getRequires(astPath.root());
            for (Object object32 : set) {
                object22 = ((IndexedElement)object32).getRequire();
                if (!set3.contains(object22)) continue;
                set2.add(object32);
            }
            if (set2.size() == 1) {
                return (IndexedMethod)set2.iterator().next();
            }
            if (!set2.isEmpty()) {
                set = set2;
            }
        }
        set2 = new HashSet();
        for (Object object32 : set) {
            object22 = ((IndexedElement)object32).getFileUrl();
            if (!RubyUtils.isRubyStubsURL((String)object22)) continue;
            set2.add(object32);
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        set2 = new HashSet<Iterator<Object>>();
        int n4 = 0;
        for (Object object22 : set) {
            int n5 = ((IndexedElement)object22).getDocumentationLength();
            if (n5 > n4) {
                set2.clear();
                set2.add(object22);
                n4 = n5;
                continue;
            }
            if (n5 <= 0 || n5 != n4) continue;
            set2.add(object22);
        }
        if (set2.size() == 1) {
            return (IndexedMethod)set2.iterator().next();
        }
        if (!set2.isEmpty()) {
            set = set2;
        }
        if (rubyIndex != null && var13_19 != null) {
            set2 = new HashSet();
            object32 = rubyIndex.getRequiresTransitively((Set<String>)var13_19);
            for (IndexedMethod indexedMethod : set) {
                object = indexedMethod.getRequire();
                if (!object32.contains(object)) continue;
                set2.add(indexedMethod);
            }
            if (set2.size() == 1) {
                return (IndexedMethod)set2.iterator().next();
            }
            if (!set2.isEmpty()) {
                set = set2;
            }
        }
        if (set.size() > 0) {
            return (IndexedMethod)set.iterator().next();
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findLocal(ParserResult parserResult, Node node, String string) {
        Node node2;
        List list;
        if (node instanceof LocalAsgnNode) {
            if (((INameNode)node).getName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            if (((AliasNode)node).getNewName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, node);
            }
        } else if (node instanceof ArgsNode) {
            Object object;
            list = (ArgsNode)node;
            if (list.getRequiredCount() > 0) {
                object = list.childNodes();
                Node node3 = object.iterator();
                while (node3.hasNext()) {
                    node2 = (Node)node3.next();
                    if (!(node2 instanceof ListNode)) continue;
                    List list2 = node2.childNodes();
                    for (Node node4 : list2) {
                        if (!(node4 instanceof ArgumentNode ? ((ArgumentNode)node4).getName().equals(string) : node4 instanceof LocalAsgnNode && ((LocalAsgnNode)node4).getName().equals(string))) continue;
                        return RubyDeclarationFinder.getLocation(parserResult, node4);
                    }
                }
            }
            if (list.getRest() != null && (object = list.getRest()).getName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, (Node)object);
            }
            if (list.getBlock() != null && (object = list.getBlock()).getName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, (Node)object);
            }
        }
        list = node.childNodes();
        for (Node node3 : list) {
            if (node3.isInvisible() || (node2 = this.findLocal(parserResult, node3, string)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return node2;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findDynamic(ParserResult parserResult, Node node, String string) {
        if (node instanceof DAsgnNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return RubyDeclarationFinder.getLocation(parserResult, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node2.isInvisible() || (declarationLocation = this.findDynamic(parserResult, node2, string)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstance(ParserResult parserResult, Node node, String string, RubyIndex rubyIndex) {
        SymbolNode[] symbolNodeArray;
        if (node instanceof InstAsgnNode) {
            if (((INameNode)node).getName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            if (((AliasNode)node).getNewName().equals(string)) {
                return RubyDeclarationFinder.getLocation(parserResult, node);
            }
        } else if (AstUtilities.isAttr(node)) {
            symbolNodeArray = AstUtilities.getAttrSymbols(node);
            for (int i = 0; i < symbolNodeArray.length; ++i) {
                if (!string.equals(symbolNodeArray[i].getName())) continue;
                Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
                DeclarationFinder.DeclarationLocation declarationLocation = this.findInstanceFromIndex(parserResult, string, new AstPath(node2, node), rubyIndex, true);
                if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                    return declarationLocation;
                }
                return RubyDeclarationFinder.getLocation(parserResult, (Node)symbolNodeArray[i]);
            }
        }
        symbolNodeArray = node.childNodes();
        for (Node node3 : symbolNodeArray) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node3.isInvisible() || (declarationLocation = this.findInstance(parserResult, node3, string, rubyIndex)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findClassVar(ParserResult parserResult, Node node, String string) {
        if (node instanceof ClassVarDeclNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return RubyDeclarationFinder.getLocation(parserResult, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node2.isInvisible() || (declarationLocation = this.findClassVar(parserResult, node2, string)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstanceFromIndex(ParserResult parserResult, String string, AstPath astPath, RubyIndex rubyIndex, boolean bl) {
        String string2 = AstUtilities.getFqnName(astPath);
        Set<IndexedField> set = rubyIndex.getInheritedFields(string2, string, QuerySupport.Kind.EXACT, bl);
        for (IndexedField indexedField : set) {
            Node node = AstUtilities.getForeignNode(indexedField);
            if (node == null) continue;
            return new DeclarationFinder.DeclarationLocation(indexedField.getFileObject(), node.getPosition().getStartOffset(), (ElementHandle)indexedField);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstanceMethodsFromIndex(ParserResult parserResult, String string, AstPath astPath, RubyIndex rubyIndex) {
        String string2 = AstUtilities.getFqnName(astPath);
        Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string2, string, QuerySupport.Kind.EXACT);
        return RubyDeclarationFinder.getLocation(set);
    }

    private DeclarationFinder.DeclarationLocation findGlobal(ParserResult parserResult, Node node, String string) {
        if (node instanceof GlobalAsgnNode ? ((INameNode)node).getName().equals(string) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return RubyDeclarationFinder.getLocation(parserResult, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node2.isInvisible() || (declarationLocation = this.findGlobal(parserResult, node2, string)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findMethod(ParserResult parserResult, Node node, String string, Arity arity) {
        if (node instanceof MethodDefNode ? ((MethodDefNode)node).getName().equals(string) && Arity.matches(arity, Arity.getDefArity(node)) : !this.ignoreAlias && node instanceof AliasNode && ((AliasNode)node).getNewName().equals(string)) {
            return RubyDeclarationFinder.getLocation(parserResult, node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            if (node2.isInvisible() || (declarationLocation = this.findMethod(parserResult, node2, string, arity)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static class RailsTarget {
        String name;
        OffsetRange range;
        String type;

        RailsTarget(String string, String string2, OffsetRange offsetRange) {
            this.type = string;
            this.range = offsetRange;
            this.name = string2;
        }

        public String toString() {
            return "RailsTarget(" + this.type + ", " + this.name + ", " + this.range + ")";
        }
    }
}

