/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ToAryNode;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyTypeAnalyzer {
    private ContextKnowledge knowledge;
    private boolean analyzed;
    private boolean targetReached;
    private final Set<String> analyzedMethods = new HashSet<String>();
    private static final String[] RAILS_CONTROLLER_VARS = new String[]{"action_name", "String", "assigns", "Hash", "cookies", "ActionController::CookieJar", "flash", "ActionController::Flash::FlashHash", "headers", "Hash", "params", "Hash", "request", "ActionController::CgiRequest", "session", "CGI::Session", "url", "ActionController::UrlRewriter"};

    RubyTypeAnalyzer(ContextKnowledge contextKnowledge) {
        this.knowledge = contextKnowledge;
    }

    void analyze() {
        if (!this.analyzed) {
            this.knowledge.setAnalyzed(true);
            RubyTypeAnalyzer.initFileTypeVars(this.knowledge);
            RDocAnalyzer.collectTypeAssertions(this.knowledge);
            this.analyze(this.knowledge.getRoot(), this.knowledge.getTypesForSymbols(), true, null);
            this.analyzed = true;
        }
    }

    static void collectMultipleAsgnVars(MultipleAsgnNode multipleAsgnNode, RubyTypeInferencer rubyTypeInferencer, Map<Node, RubyType> map) {
        ListNode listNode = multipleAsgnNode.getHeadNode();
        Node node = multipleAsgnNode.getValueNode();
        if (listNode == null || node == null) {
            return;
        }
        if (node.getNodeType() == NodeType.TOARYNODE) {
            node = ((ToAryNode)node).getValue();
        }
        if (node.childNodes().size() != listNode.childNodes().size()) {
            return;
        }
        for (int i = 0; i < listNode.childNodes().size(); ++i) {
            Node node2 = (Node)listNode.childNodes().get(i);
            RubyTypeAnalyzer.collectTypes(node2, (Node)node.childNodes().get(i), rubyTypeInferencer, map);
        }
    }

    private static void collectTypes(Node node, Node node2, RubyTypeInferencer rubyTypeInferencer, Map<Node, RubyType> map) {
        if (node == null || node2 == null) {
            return;
        }
        if (node2.getNodeType() == NodeType.TOARYNODE) {
            node2 = ((ToAryNode)node2).getValue();
        }
        if (node.getNodeType() == NodeType.MULTIPLEASGNNODE) {
            MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
            if (multipleAsgnNode.getHeadNode().childNodes().size() == node2.childNodes().size()) {
                for (int i = 0; i < multipleAsgnNode.getHeadNode().childNodes().size(); ++i) {
                    Node node3 = (Node)multipleAsgnNode.getHeadNode().childNodes().get(i);
                    RubyTypeAnalyzer.collectTypes(node3, (Node)node2.childNodes().get(i), rubyTypeInferencer, map);
                }
            }
        } else if (node.getNodeType() == NodeType.ARRAYNODE && node2.getNodeType() == NodeType.ARRAYNODE) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayNode arrayNode2 = (ArrayNode)node2;
            if (arrayNode.size() == arrayNode2.size()) {
                for (int i = 0; i < arrayNode.size(); ++i) {
                    RubyTypeAnalyzer.collectTypes(arrayNode.get(i), arrayNode2.get(i), rubyTypeInferencer, map);
                }
            }
        } else {
            map.put(node, rubyTypeInferencer.inferType(node2));
        }
    }

    private void analyze(Node node, Map<String, RubyType> map, boolean bl, String string) {
        String string22;
        if (node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) {
            string = AstUtilities.getName(node);
        }
        if (node == this.knowledge.getTarget()) {
            this.targetReached = true;
        }
        if (this.targetReached && node.getPosition().getStartOffset() > this.knowledge.getAstOffset()) {
            return;
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
                HashMap<Node, RubyType> hashMap = new HashMap<Node, RubyType>();
                RubyTypeAnalyzer.collectMultipleAsgnVars(multipleAsgnNode, RubyTypeInferencer.create(this.knowledge), hashMap);
                for (Node node2 : hashMap.keySet()) {
                    if (!(node2 instanceof INameNode)) continue;
                    String string3 = AstUtilities.getName(node2);
                    this.maybePutTypeForSymbol(map, string3, (RubyType)hashMap.get(node2), bl, string);
                }
                return;
            }
            case LOCALASGNNODE: {
                Object object = RubyTypeInferencer.create(this.knowledge).inferTypesOfRHS(node);
                string22 = RubyTypeInferencer.getLocalVarPath(new AstPath(this.knowledge.getRoot(), node), AstUtilities.getName(node));
                this.maybePutTypeForSymbol(map, string22, (RubyType)object, bl, string);
                break;
            }
            case CONSTDECLNODE: {
                Object object = RubyTypeInferencer.create(this.knowledge).inferTypesOfRHS(node);
                string22 = AstUtilities.getFqnName(this.knowledge.getRoot(), node);
                this.maybePutTypeForSymbol(map, string22, (RubyType)object, bl, string);
                break;
            }
            case INSTASGNNODE: 
            case GLOBALASGNNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case DASGNNODE: {
                Object object = RubyTypeInferencer.create(this.knowledge).inferTypesOfRHS(node);
                string22 = AstUtilities.getName(node);
                this.maybePutTypeForSymbol(map, string22, (RubyType)object, bl, string);
                break;
            }
        }
        if (node.getNodeType() == NodeType.IFNODE) {
            this.analyzeIfNode((IfNode)node, map, string);
        } else {
            for (String string22 : node.childNodes()) {
                if (string22.isInvisible()) continue;
                this.analyze((Node)string22, map, bl, string);
            }
        }
    }

    private void analyzeIfNode(IfNode ifNode, Map<String, RubyType> map, String string) {
        Node node = ifNode.getThenBody();
        HashMap<String, RubyType> hashMap = new HashMap<String, RubyType>();
        if (node != null) {
            this.analyze(node, hashMap, true, string);
        }
        Node node2 = ifNode.getElseBody();
        HashMap<String, RubyType> hashMap2 = new HashMap<String, RubyType>();
        if (node2 != null) {
            this.analyze(node2, hashMap2, true, string);
        }
        HashMap<String, RubyType> hashMap3 = new HashMap<String, RubyType>();
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.maybePutTypeForSymbol(hashMap3, (String)entry.getKey(), (RubyType)entry.getValue(), false, string);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.maybePutTypeForSymbol(hashMap3, (String)entry.getKey(), (RubyType)entry.getValue(), false, string);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            String string2 = (String)entry.getKey();
            boolean bl = hashMap.containsKey(string2) && hashMap2.containsKey(string2);
            this.maybePutTypeForSymbol(map, string2, (RubyType)entry.getValue(), bl, string);
        }
    }

    private static void initFileTypeVars(ContextKnowledge contextKnowledge) {
        FileObject fileObject = RubyUtils.getFileObject((Parser.Result)contextKnowledge.getParserResult());
        if (fileObject == null) {
            return;
        }
        String string = fileObject.getExt();
        if (string.equals("rb")) {
            String string2 = fileObject.getName();
            if (string2.endsWith("_controller")) {
                for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                    String string3 = RAILS_CONTROLLER_VARS[i];
                    String string4 = RAILS_CONTROLLER_VARS[i + 1];
                    contextKnowledge.maybePutTypeForSymbol(string3, string4, true);
                }
            }
        } else if (string.equals("rhtml") || string.equals("erb")) {
            for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                String string5 = RAILS_CONTROLLER_VARS[i];
                String string6 = RAILS_CONTROLLER_VARS[i + 1];
                contextKnowledge.maybePutTypeForSymbol(string5, string6, true);
            }
        } else if (string.equals("rjs")) {
            contextKnowledge.maybePutTypeForSymbol("page", "ActionView::Helpers::PrototypeHelper::JavaScriptGenerator::GeneratorMethods", true);
        } else if (string.equals("builder") || string.equals("rxml")) {
            contextKnowledge.maybePutTypeForSymbol("xml", "Builder::XmlMarkup", true);
        }
    }

    private void maybePutTypeForSymbol(Map<String, RubyType> map, String string, RubyType rubyType, boolean bl, String string2) {
        RubyType rubyType2 = map.get(string);
        if (string.startsWith("@") && string2 != null && !this.analyzedMethods.contains(string2)) {
            this.analyzedMethods.add(string2);
            bl = false;
        }
        if (rubyType2 == null || bl) {
            rubyType2 = new RubyType();
            map.put(string, rubyType2);
        }
        rubyType2.append(rubyType);
    }
}

