/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.ruby.options.FmtOptions;

public final class CodeStyle {
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle get(Preferences preferences) {
        return new CodeStyle(preferences);
    }

    public static CodeStyle get(Document document) {
        return new CodeStyle(CodeStylePreferences.get((Document)document).getPreferences());
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
    }

    public int getIndentSize() {
        int n = this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
        if (n <= 0) {
            boolean bl = this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
            n = bl ? this.preferences.getInt("spaces-per-tab", FmtOptions.getDefaultAsInt("spaces-per-tab")) : this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
        }
        return n;
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }
}

