/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.ext.MacroCallback;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmExpandedTokenProcessor
implements CndTokenProcessor<Token<CppTokenId>>,
MacroCallback {
    private final CndTokenProcessor<Token<CppTokenId>> tp;
    private final Document doc;
    private final int lastOffset;
    private boolean inMacro;
    private int skipTill = -1;
    private final CsmFile file;
    private List<CsmReference> macros;

    private CsmExpandedTokenProcessor(Document document, CsmFile csmFile, CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor, int n, List<CsmReference> list) {
        this.tp = cndTokenProcessor;
        this.doc = document;
        this.lastOffset = n;
        this.file = csmFile;
        this.macros = list;
    }

    public static CndTokenProcessor<Token<CppTokenId>> create(Document document, CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor, int n) {
        List list;
        CsmFile csmFile;
        if (document != null && (csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true)) != null && (list = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile)) != null) {
            return CsmExpandedTokenProcessor.create(document, csmFile, cndTokenProcessor, n, list);
        }
        return cndTokenProcessor;
    }

    private static CndTokenProcessor<Token<CppTokenId>> create(Document document, CsmFile csmFile, CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor, int n, List<CsmReference> list) {
        CsmMacroExpansion.expand((Document)document, (CsmFile)csmFile, (int)0, (int)0);
        return new CsmExpandedTokenProcessor(document, csmFile, cndTokenProcessor, n, list);
    }

    public void start(int n, int n2, int n3) {
        this.tp.start(n, n2, n3);
    }

    public void end(int n, int n2) {
        this.tp.end(n, n2);
    }

    public boolean isStopped() {
        return this.tp.isStopped();
    }

    @Override
    public boolean isMacroExpansion() {
        return this.inMacro;
    }

    public boolean isMacro(Token token, int n) {
        return CndLexerUtilities.isCppIdentifierStart((char)token.text().charAt(0)) && ReferencesSupport.findMacro(this.macros, n) != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean token(Token<CppTokenId> token, int n) {
        if (this.skipTill <= n) {
            this.skipTill = -1;
        }
        if (this.skipTill < 0 && (this.isMacro(token, n) || this.inMacro)) {
            TokenSequence tokenSequence = null;
            String string = CsmMacroExpansion.expand((Document)this.doc, (CsmFile)this.file, (int)n, (int)(n + token.length()));
            if (string != null) {
                if (string.equals("")) {
                    if (this.lastOffset == -1 || n + token.length() < this.lastOffset) {
                        return false;
                    }
                } else if (this.inMacro) {
                    this.inMacro = false;
                } else {
                    TokenSequence tokenSequence2;
                    void var8_9;
                    this.inMacro = true;
                    int[] nArray = CsmMacroExpansion.getMacroExpansionSpan((Document)this.doc, (int)n, (boolean)false);
                    if (nArray[0] < this.lastOffset && this.lastOffset <= nArray[1]) {
                        this.skipTill = nArray[1];
                        this.inMacro = false;
                        return this.tp.token(token, n);
                    }
                    TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)CndLexerUtilities.getLanguage((Document)this.doc));
                    List list = tokenHierarchy.embeddedTokenSequences(n + token.length(), true);
                    int bl = list.size() - 1;
                    while (var8_9 >= 0) {
                        tokenSequence2 = (TokenSequence)list.get((int)var8_9);
                        Language language = tokenSequence2.languagePath().innerLanguage();
                        if (CndLexerUtilities.isCppLanguage((Language)language, (boolean)false)) {
                            TokenSequence tokenSequence3;
                            tokenSequence = tokenSequence3 = tokenSequence2;
                        }
                        --var8_9;
                    }
                    if (tokenSequence != null) {
                        tokenSequence.moveStart();
                        if (tokenSequence.moveNext()) {
                            void var8_15;
                            tokenSequence2 = tokenSequence.token();
                            if (!tokenSequence.moveNext()) {
                                if (((Object)tokenSequence2.text()).toString().equals(((Object)token.text()).toString()) && ((CppTokenId)tokenSequence2.id()).equals((Object)token.id())) {
                                    boolean bl2 = this.tp.token(token, n);
                                } else {
                                    boolean bl3 = this.tp.token((Token)tokenSequence2, n);
                                }
                            } else {
                                boolean bl5 = this.tp.token((Token)tokenSequence2, n);
                                bl5 = this.tp.token(tokenSequence.token(), n);
                                while (tokenSequence.moveNext()) {
                                    boolean bl6 = this.tp.token(tokenSequence.token(), n);
                                }
                            }
                            return (boolean)var8_15;
                        }
                    }
                }
            }
        }
        if (!this.isWhitespace(token)) {
            this.inMacro = false;
        }
        return this.tp.token(token, n);
    }

    private boolean isWhitespace(Token<CppTokenId> token) {
        switch ((CppTokenId)token.id()) {
            case NEW_LINE: 
            case WHITESPACE: 
            case ESCAPED_WHITESPACE: 
            case ESCAPED_LINE: {
                return true;
            }
        }
        return false;
    }
}

