/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmIncludeHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    private static final boolean NEED_TO_TRACE_UNRESOLVED_INCLUDE = CndUtils.getBoolean((String)"cnd.modelimpl.trace.failed.include", (boolean)false);
    private static final boolean TRACE_INCLUDES = CndUtils.getBoolean((String)"cnd.trace.includes", (boolean)false);
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    @Override
    protected boolean isValidToken(TokenItem<CppTokenId> tokenItem, HyperlinkType hyperlinkType) {
        return CsmIncludeHyperlinkProvider.isSupportedToken(tokenItem, hyperlinkType);
    }

    public static boolean isSupportedToken(TokenItem<CppTokenId> tokenItem, HyperlinkType hyperlinkType) {
        if (tokenItem != null) {
            if (hyperlinkType == HyperlinkType.ALT_HYPERLINK) {
                return !"whitespace".equals(((CppTokenId)tokenItem.id()).primaryCategory()) && !"comment".equals(((CppTokenId)tokenItem.id()).primaryCategory());
            }
            switch ((CppTokenId)tokenItem.id()) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void performAction(Document document, JTextComponent jTextComponent, int n, HyperlinkType hyperlinkType) {
        this.goToInclude(document, jTextComponent, n, hyperlinkType);
    }

    public boolean goToInclude(Document document, JTextComponent jTextComponent, int n, HyperlinkType hyperlinkType) {
        if (!this.preJump(document, jTextComponent, n, "opening-include-element", hyperlinkType)) {
            return false;
        }
        CsmOffsetable csmOffsetable = this.findTargetObject(document, n);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-include-element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmOffsetable findTargetObject(Document document, int n) {
        IncludeTarget includeTarget;
        CsmInclude csmInclude = this.findInclude(document, n);
        IncludeTarget includeTarget2 = includeTarget = csmInclude == null ? null : new IncludeTarget(csmInclude);
        if (csmInclude != null && NEED_TO_TRACE_UNRESOLVED_INCLUDE && csmInclude.getIncludeFile() == null) {
            System.setProperty("cnd.modelimpl.trace.trace_now", "yes");
            try {
                csmInclude.getIncludeFile();
            }
            finally {
                System.setProperty("cnd.modelimpl.trace.trace_now", "no");
            }
        }
        return includeTarget;
    }

    private CsmInclude findInclude(Document document, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (csmFile != null) {
            return ReferencesSupport.findInclude(csmFile, n);
        }
        return null;
    }

    @Override
    protected String getTooltipText(Document document, TokenItem<CppTokenId> tokenItem, int n, HyperlinkType hyperlinkType) {
        boolean bl;
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        CsmInclude csmInclude = null;
        if (csmFile != null) {
            csmInclude = ReferencesSupport.findInclude(csmFile, n);
        }
        CharSequence charSequence = csmInclude == null ? null : CsmDisplayUtilities.getTooltipText((CsmObject)csmInclude);
        boolean bl2 = bl = hyperlinkType == HyperlinkType.ALT_HYPERLINK;
        if (charSequence != null) {
            StringBuilder stringBuilder;
            List list = CsmFileInfoQuery.getDefault().getIncludeStack(csmFile);
            if (bl || csmInclude.getIncludeFile() == null) {
                stringBuilder = new StringBuilder(charSequence);
                stringBuilder.append("<br><pre>");
                this.appendPaths(stringBuilder, this.i18n("SourceUserPaths"), CsmFileInfoQuery.getDefault().getUserIncludePaths(csmFile));
                this.appendPaths(stringBuilder, this.i18n("SourceSystemPaths"), CsmFileInfoQuery.getDefault().getSystemIncludePaths(csmFile));
                this.appendInclStack(stringBuilder, list);
                stringBuilder.append("</pre>");
            } else {
                stringBuilder = new StringBuilder(this.getAlternativeHyperlinkTip(document, "AltIncludeHyperlinkHint", charSequence));
            }
            if (bl && (TRACE_INCLUDES || NEED_TO_TRACE_UNRESOLVED_INCLUDE)) {
                InputOutput inputOutput = IOProvider.getDefault().getIO("Test Inlcudes", false);
                OutputWriter outputWriter = inputOutput.getOut();
                if (!list.isEmpty()) {
                    try {
                        outputWriter.println("path to file " + csmFile.getAbsolutePath(), (OutputListener)new RefLink(csmFile));
                        for (CsmInclude csmInclude2 : list) {
                            outputWriter.println(csmInclude2.getText() + " from file " + csmInclude2.getContainingFile().getAbsolutePath(), (OutputListener)new RefLink(csmInclude2));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                outputWriter.println(stringBuilder.toString().replaceAll("<br>", "\n"));
                outputWriter.flush();
            }
            charSequence = stringBuilder.toString();
        }
        return charSequence == null ? null : ((Object)charSequence).toString();
    }

    private void appendInclStack(StringBuilder stringBuilder, List<CsmInclude> list) {
        if (!list.isEmpty()) {
            stringBuilder.append("<i>").append(this.i18n("PathToCurFile")).append("</i>\n");
            for (CsmInclude csmInclude : list) {
                String string = this.i18n("PathToHeaderOnLine", csmInclude.getContainingFile().getAbsolutePath(), csmInclude.getStartPosition().getLine());
                stringBuilder.append(string).append('\n');
            }
        }
    }

    private void appendPaths(StringBuilder stringBuilder, String string, List<String> list) {
        if (!list.isEmpty()) {
            stringBuilder.append("<i>").append(string).append("</i>\n");
            for (String string2 : list) {
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append("<font color='red'>");
                    stringBuilder.append(string2);
                    stringBuilder.append("</font>");
                }
                stringBuilder.append('\n');
            }
        }
    }

    private String i18n(String string) {
        return NbBundle.getMessage(CsmIncludeHyperlinkProvider.class, (String)string);
    }

    private String i18n(String string, Object object, Object object2) {
        return NbBundle.getMessage(CsmIncludeHyperlinkProvider.class, (String)string, (Object)object, (Object)object2);
    }

    private static final class RefLink
    implements OutputListener {
        private final CsmUID<? extends CsmObject> uid;

        public RefLink(CsmInclude csmInclude) {
            this.uid = UIDs.get((Object)csmInclude);
        }

        public RefLink(CsmFile csmFile) {
            this.uid = UIDs.get((Object)csmFile);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            CsmObject csmObject = (CsmObject)this.uid.getObject();
            if (csmObject != null) {
                CsmUtilities.openSource((CsmObject)csmObject);
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }

    private static final class IncludeTarget
    implements CsmOffsetable {
        private CsmInclude include;

        public IncludeTarget(CsmInclude csmInclude) {
            this.include = csmInclude;
        }

        public CsmFile getContainingFile() {
            return this.include.getIncludeFile();
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public CharSequence getText() {
            return this.include.getIncludeName();
        }
    }
}

