/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmExpandedTokenProcessor;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceContextImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileReferencesImpl
extends CsmFileReferences {
    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor) {
        this.accept(csmScope, visitor, CsmReferenceKind.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(CsmScope csmScope, CsmFileReferences.Visitor visitor, Set<CsmReferenceKind> set) {
        FileReferencesContext fileReferencesContext = new FileReferencesContext(csmScope);
        try {
            this._accept(csmScope, visitor, set, fileReferencesContext);
        }
        finally {
            fileReferencesContext.clean();
        }
    }

    private void _accept(CsmScope csmScope, CsmFileReferences.Visitor visitor, Set<CsmReferenceKind> set, FileReferencesContext fileReferencesContext) {
        int n;
        int n2;
        if (!CsmKindUtilities.isOffsetable((Object)csmScope) && !CsmKindUtilities.isFile((CsmObject)csmScope)) {
            return;
        }
        CsmFile csmFile = null;
        csmFile = CsmKindUtilities.isFile((CsmObject)csmScope) ? (CsmFile)csmScope : ((CsmOffsetable)csmScope).getContainingFile();
        BaseDocument baseDocument = ReferencesSupport.getDocument(csmFile);
        if (baseDocument == null || !csmFile.isValid()) {
            return;
        }
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            n2 = 0;
            n = Math.max(0, baseDocument.getLength() - 1);
        } else {
            n2 = ((CsmOffsetable)csmScope).getStartOffset();
            n = ((CsmOffsetable)csmScope).getEndOffset();
        }
        List<CsmReferenceContext> list = this.getIdentifierReferences(csmFile, baseDocument, n2, n, set, fileReferencesContext);
        for (CsmReferenceContext csmReferenceContext : list) {
            if (this.isThis(csmReferenceContext.getReference())) continue;
            visitor.visit(csmReferenceContext);
        }
    }

    protected boolean isThis(CsmReference csmReference) {
        TokenItem<CppTokenId> tokenItem = ReferencesSupport.getRefTokenIfPossible(csmReference);
        if (tokenItem != null) {
            return tokenItem.id() == CppTokenId.THIS;
        }
        return super.isThis(csmReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Collection<CsmReference> collection, CsmFileReferences.ReferenceVisitor referenceVisitor) {
        FileReferencesContext fileReferencesContext = null;
        try {
            for (CsmReference csmReference : collection) {
                if (fileReferencesContext == null) {
                    fileReferencesContext = new FileReferencesContext((CsmScope)csmReference.getContainingFile());
                }
                if (csmReference instanceof ReferenceImpl) {
                    ((ReferenceImpl)csmReference).setFileReferencesContext(fileReferencesContext);
                }
                referenceVisitor.visit(csmReference);
            }
        }
        finally {
            if (fileReferencesContext != null) {
                fileReferencesContext.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CsmReferenceContext> getIdentifierReferences(CsmFile csmFile, BaseDocument baseDocument, int n, int n2, Set<CsmReferenceKind> set, FileReferencesContext fileReferencesContext) {
        ExpandedReferencesProcessor expandedReferencesProcessor = ExpandedReferencesProcessor.create(baseDocument, csmFile, set, fileReferencesContext);
        baseDocument.readLock();
        try {
            CndTokenUtilities.processTokens((CndTokenProcessor)expandedReferencesProcessor, (Document)baseDocument, (int)n, (int)n2);
        }
        finally {
            baseDocument.readUnlock();
        }
        return expandedReferencesProcessor.getReferences();
    }

    private static boolean isInDeadBlock(int n, Collection<CsmOffsetable> collection) {
        for (CsmOffsetable csmOffsetable : collection) {
            if (csmOffsetable.getStartOffset() > n) {
                return false;
            }
            if (csmOffsetable.getEndOffset() <= n) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockConsumer {
        private final CppTokenId openBracket;
        private final CppTokenId closeBracket;
        private int depth;

        public BlockConsumer(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
            this.openBracket = cppTokenId;
            this.closeBracket = cppTokenId2;
            this.depth = 0;
        }

        public boolean isLastToken(Token<CppTokenId> token) {
            boolean bl = false;
            if (token.id() == this.openBracket) {
                ++this.depth;
            } else if (token.id() == this.closeBracket) {
                --this.depth;
                bl = this.depth <= 0;
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferenceContextBuilder {
        private static final int FULLCOPY_INTERVAL = 50;
        private ReferenceContextImpl context;
        private final List<CppTokenId> brackets;
        private final List<Integer> pushes;
        private int snapshots;

        public ReferenceContextBuilder() {
            this.context = new ReferenceContextImpl();
            this.brackets = new ArrayList<CppTokenId>();
            this.pushes = new ArrayList<Integer>();
            this.pushes.add(0);
        }

        public ReferenceContextBuilder(ReferenceContextBuilder referenceContextBuilder) {
            this.context = new ReferenceContextImpl(referenceContextBuilder.context);
            this.brackets = new ArrayList<CppTokenId>(referenceContextBuilder.brackets);
            this.pushes = new ArrayList<Integer>(referenceContextBuilder.pushes);
            this.snapshots = referenceContextBuilder.snapshots;
        }

        public void open(CppTokenId cppTokenId) {
            if (ReferenceContextBuilder.peek(this.pushes) == 0 && ReferenceContextBuilder.peek(this.brackets) != null) {
                this.context.push(ReferenceContextBuilder.peek(this.brackets), null);
                ReferenceContextBuilder.pop(this.pushes);
                this.pushes.add(1);
            }
            this.brackets.add(cppTokenId);
            this.pushes.add(0);
        }

        public void close(CppTokenId cppTokenId) {
            if (ReferenceContextBuilder.match(ReferenceContextBuilder.peek(this.brackets), cppTokenId)) {
                ReferenceContextBuilder.pop(this.brackets);
                for (int i = 0; i < ReferenceContextBuilder.peek(this.pushes); ++i) {
                    this.context.pop();
                }
                ReferenceContextBuilder.pop(this.pushes);
            }
        }

        public void other(CppTokenId cppTokenId) {
            if (cppTokenId == CppTokenId.SEMICOLON && ReferenceContextBuilder.peek(this.brackets) == CppTokenId.LT) {
                this.close(CppTokenId.GT);
            }
            for (int i = 0; i < ReferenceContextBuilder.peek(this.pushes); ++i) {
                this.context.pop();
            }
            ReferenceContextBuilder.pop(this.pushes);
            this.pushes.add(0);
        }

        public void reference(CsmReference csmReference, CppTokenId cppTokenId) {
            int n = 0;
            if (cppTokenId == null) {
                this.other(CppTokenId.IDENTIFIER);
                this.context.push(ReferenceContextBuilder.peek(this.brackets), csmReference);
                ++n;
            } else {
                if (ReferenceContextBuilder.peek(this.pushes) == 0 && ReferenceContextBuilder.peek(this.brackets) != null) {
                    this.context.push(ReferenceContextBuilder.peek(this.brackets), null);
                    ++n;
                }
                this.context.push(cppTokenId, csmReference);
                ++n;
            }
            this.pushes.add(ReferenceContextBuilder.pop(this.pushes) + n);
        }

        private static <T> T peek(List<T> list) {
            if (list.isEmpty()) {
                return null;
            }
            return list.get(list.size() - 1);
        }

        private static <T> T pop(List<T> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.remove(list.size() - 1);
        }

        private static boolean match(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
            return cppTokenId == CppTokenId.LBRACE && cppTokenId2 == CppTokenId.RBRACE || cppTokenId == CppTokenId.LBRACKET && cppTokenId2 == CppTokenId.RBRACKET || cppTokenId == CppTokenId.LPAREN && cppTokenId2 == CppTokenId.RPAREN || cppTokenId == CppTokenId.LT && cppTokenId2 == CppTokenId.GT;
        }

        public CsmReferenceContext getContext() {
            ReferenceContextImpl referenceContextImpl;
            if (50 <= this.snapshots++) {
                referenceContextImpl = new ReferenceContextImpl(this.context, true);
                this.snapshots = 0;
            } else {
                referenceContextImpl = this.context;
            }
            this.context = new ReferenceContextImpl(referenceContextImpl, false);
            return referenceContextImpl;
        }

        public String toString() {
            return String.valueOf(this.context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferencesProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        final List<CsmReferenceContext> references = new ArrayList<CsmReferenceContext>();
        private final Collection<CsmOffsetable> deadBlocks;
        private final boolean needAfterDereferenceUsages;
        private final boolean skipPreprocDirectives;
        private final CsmFile csmFile;
        private final BaseDocument doc;
        private final ReferenceContextBuilder contextBuilder;
        private final FileReferencesContext fileReferncesContext;
        private CppTokenId derefToken;
        private BlockConsumer blockConsumer;
        private boolean afterParen = false;
        private boolean skipReferences = false;

        ReferencesProcessor(CsmFile csmFile, BaseDocument baseDocument, boolean bl, boolean bl2, Collection<CsmOffsetable> collection, FileReferencesContext fileReferencesContext) {
            this.deadBlocks = collection;
            this.needAfterDereferenceUsages = bl2;
            this.skipPreprocDirectives = bl;
            this.csmFile = csmFile;
            this.doc = baseDocument;
            this.contextBuilder = new ReferenceContextBuilder();
            this.fileReferncesContext = fileReferencesContext;
        }

        private ReferencesProcessor(ReferencesProcessor referencesProcessor) {
            this.deadBlocks = referencesProcessor.deadBlocks;
            this.needAfterDereferenceUsages = referencesProcessor.needAfterDereferenceUsages;
            this.skipPreprocDirectives = referencesProcessor.skipPreprocDirectives;
            this.csmFile = referencesProcessor.csmFile;
            this.doc = referencesProcessor.doc;
            this.fileReferncesContext = referencesProcessor.fileReferncesContext;
            this.contextBuilder = new ReferenceContextBuilder(referencesProcessor.contextBuilder);
            this.derefToken = referencesProcessor.derefToken;
            this.afterParen = referencesProcessor.afterParen;
            this.skipReferences = referencesProcessor.skipReferences;
        }

        private void skipReferences(boolean bl) {
            this.skipReferences = bl;
        }

        public boolean token(Token<CppTokenId> token, int n) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_DIRECTIVE: {
                    bl2 = !this.skipPreprocDirectives;
                    break;
                }
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: 
                case THIS: {
                    boolean bl3 = bl = !this.needAfterDereferenceUsages && this.derefToken != null;
                    if (!bl && !this.deadBlocks.isEmpty()) {
                        bl = FileReferencesImpl.isInDeadBlock(n, this.deadBlocks);
                    }
                    ReferenceImpl referenceImpl = ReferencesSupport.createReferenceImpl(this.csmFile, this.doc, n, (TokenItem<CppTokenId>)CndTokenUtilities.createTokenItem(token, (int)n), this.derefToken == null ? null : null);
                    this.contextBuilder.reference(referenceImpl, this.derefToken);
                    referenceImpl.setFileReferencesContext(this.fileReferncesContext);
                    this.derefToken = null;
                    if (bl || this.skipReferences) break;
                    this.references.add(this.contextBuilder.getContext());
                    break;
                }
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    this.derefToken = (CppTokenId)token.id();
                    break;
                }
                case LBRACE: {
                    if (this.afterParen) {
                        this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    } else {
                        this.contextBuilder.open((CppTokenId)token.id());
                    }
                    this.derefToken = null;
                    break;
                }
                case LBRACKET: 
                case LPAREN: 
                case LT: {
                    this.contextBuilder.open((CppTokenId)token.id());
                    this.derefToken = null;
                    break;
                }
                case RBRACE: 
                case RBRACKET: 
                case RPAREN: 
                case GT: {
                    this.contextBuilder.close((CppTokenId)token.id());
                    this.derefToken = null;
                    break;
                }
                case __ATTRIBUTE__: 
                case __ATTRIBUTE: 
                case _DECLSPEC: 
                case __DECLSPEC: 
                case ASM: 
                case __ASM: 
                case __ASM__: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LPAREN, CppTokenId.RPAREN);
                    this.derefToken = null;
                    break;
                }
                case _ASM: {
                    this.blockConsumer = new BlockConsumer(CppTokenId.LBRACE, CppTokenId.RBRACE);
                    this.derefToken = null;
                    break;
                }
                case WHITESPACE: 
                case NEW_LINE: 
                case BLOCK_COMMENT: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case TEMPLATE: {
                    break;
                }
                default: {
                    this.contextBuilder.other((CppTokenId)token.id());
                    this.derefToken = null;
                }
            }
            switch ((CppTokenId)token.id()) {
                case LPAREN: {
                    this.afterParen = true;
                    break;
                }
                case WHITESPACE: 
                case NEW_LINE: 
                case BLOCK_COMMENT: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: {
                    break;
                }
                default: {
                    this.afterParen = false;
                }
            }
            return bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExpandedReferencesProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        private CsmExpandedTokenProcessor expandedTokenProcessor;
        private ReferencesProcessor originalReferencesProcessor;
        private ReferencesProcessor macroReferencesProcessor;
        private boolean inMacro = false;

        public static ExpandedReferencesProcessor create(BaseDocument baseDocument, CsmFile csmFile, Set<CsmReferenceKind> set, FileReferencesContext fileReferencesContext) {
            boolean bl = set.contains(CsmReferenceKind.AFTER_DEREFERENCE_USAGE);
            boolean bl2 = !set.contains(CsmReferenceKind.IN_PREPROCESSOR_DIRECTIVE);
            List list = !set.contains(CsmReferenceKind.IN_DEAD_BLOCK) ? CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile) : Collections.emptyList();
            ReferencesProcessor referencesProcessor = new ReferencesProcessor(csmFile, baseDocument, bl2, bl, list, fileReferencesContext);
            return new ExpandedReferencesProcessor(referencesProcessor, null);
        }

        public List<CsmReferenceContext> getReferences() {
            return this.originalReferencesProcessor.references;
        }

        private ExpandedReferencesProcessor(ReferencesProcessor referencesProcessor, CsmExpandedTokenProcessor csmExpandedTokenProcessor) {
            this.originalReferencesProcessor = referencesProcessor;
            this.expandedTokenProcessor = csmExpandedTokenProcessor;
        }

        public boolean token(Token<CppTokenId> token, int n) {
            boolean bl;
            if (this.expandedTokenProcessor == null) {
                return this.originalReferencesProcessor.token(token, n);
            }
            if (this.expandedTokenProcessor.isMacro(token, n)) {
                if (this.inMacro) {
                    this.originalReferencesProcessor.references.addAll(this.macroReferencesProcessor.references);
                }
                this.macroReferencesProcessor = new ReferencesProcessor(this.originalReferencesProcessor);
                this.originalReferencesProcessor.skipReferences(true);
                bl = this.expandedTokenProcessor.token(token, n);
                this.originalReferencesProcessor.skipReferences(false);
                this.inMacro = true;
            } else {
                bl = this.expandedTokenProcessor.token(token, n);
            }
            if (this.inMacro && !this.expandedTokenProcessor.isMacroExpansion()) {
                this.originalReferencesProcessor.references.addAll(this.macroReferencesProcessor.references);
                this.inMacro = false;
            }
            if (this.inMacro) {
                this.macroReferencesProcessor.token(token, n);
            }
            return bl;
        }
    }
}

