/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.checker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.checker.ElBeanContextChecker;
import org.netbeans.modules.web.core.syntax.checker.ElContextChecker;
import org.netbeans.modules.web.core.syntax.checker.ElStartContextChecker;
import org.netbeans.modules.web.core.syntax.completion.JspELExpression;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspElChecker {
    protected static Rule.ErrorRule DEFAULT_ERROR_RULE = new Rule(HintSeverity.ERROR, true);
    protected static final int DEFAULT_ERROR_HINT_PRIORITY = 50;
    private static final Map<Integer, ElContextChecker> CHECKERS = new HashMap<Integer, ElContextChecker>();

    public ELExpression parseExpression(Document document, int n) {
        JspELExpression jspELExpression = new JspELExpression(JspSyntaxSupport.get(document));
        jspELExpression.parse(n);
        return jspELExpression;
    }

    public void check(List<Hint> list, Document document, FileObject fileObject, Map<Class<? extends ELExpression>, ELExpression> map) {
        JspELExpression jspELExpression = (JspELExpression)map.get(JspELExpression.class);
        int n = jspELExpression.getParseType();
        if (n == 5) {
            String string = jspELExpression.getBeanName();
            Hint hint = new Hint((org.netbeans.modules.csl.api.Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(JspElChecker.class, (String)"MSG_UNKNOWN_BEAN_CONTEXT", (Object)string), fileObject, new OffsetRange(jspELExpression.getStartOffset(), jspELExpression.getStartOffset() + string.length()), Collections.emptyList(), 50);
            list.add(hint);
            return;
        }
    }

    static {
        CHECKERS.put(1, new ElStartContextChecker());
        CHECKERS.put(2, new ElBeanContextChecker());
        CHECKERS.put(3, CHECKERS.get(2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Rule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private Rule(HintSeverity hintSeverity, boolean bl) {
            this.severity = hintSeverity;
            this.showInTasklist = bl;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext ruleContext) {
            return true;
        }

        public String getDisplayName() {
            return "jsp";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

