/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.JavaJspCompletionProvider;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.ImageUtilities;

public class AttrSupports {
    private static final Logger logger = Logger.getLogger(AttrSupports.class.getName());

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncodingSupport
    extends AttributeValueSupport.Default {
        public EncodingSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageLanguage
    extends AttributeValueSupport.Default {
        public PageLanguage() {
            super(false, "page", "language");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("java");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrueFalseSupport
    extends AttributeValueSupport.Default {
        public TrueFalseSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("false");
            arrayList.add("true");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilenameSupport
    extends AttributeValueSupport.Default {
        static final ImageIcon PACKAGE_ICON = ImageUtilities.loadImageIcon((String)"org/openide/loaders/defaultFolder.gif", (boolean)false);

        public FilenameSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        public void result(JspCompletionQuery.CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            String string2 = "";
            String string3 = string;
            int n2 = string.lastIndexOf(47);
            if (n2 == 0) {
                string2 = "/";
                string3 = string.substring(1);
            } else if (n2 > 0) {
                string2 = string.substring(0, n2);
                string3 = n2 == string.length() ? "" : string.substring(n2 + 1);
            }
            int n3 = n - string.length() + n2 + 1;
            try {
                FileObject fileObject = jspSyntaxSupport.getFileObject();
                FileObject fileObject2 = JspUtils.guessWebModuleRoot(fileObject);
                String string4 = JspUtils.resolveRelativeURL("/" + fileObject.getPath(), string2);
                string4 = string2.startsWith("/") ? fileObject2.getPath() + string2 : string4.substring(1);
                FileSystem fileSystem = fileObject.getFileSystem();
                FileObject fileObject3 = fileSystem.findResource(string4);
                if (fileObject3 != null) {
                    completionResultSet.addAllItems(this.files(n3, fileObject3, string3, jspSyntaxSupport));
                    if (!(fileObject3.equals(fileObject2) || string2.startsWith("/") || string2.length() != 0 && string2.lastIndexOf("../") + 3 != string2.length())) {
                        completionResultSet.addItem(JspCompletionItem.createGoUpFileCompletionItem(n3, Color.BLUE, PACKAGE_ICON));
                    }
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            completionResultSet.setAnchorOffset(n3);
        }

        private List<JspCompletionItem> files(int n, FileObject fileObject, String string, JspSyntaxSupport jspSyntaxSupport) {
            ArrayList<JspCompletionItem> arrayList = new ArrayList<JspCompletionItem>();
            TreeMap<String, JspCompletionItem> treeMap = new TreeMap<String, JspCompletionItem>();
            TreeMap<String, JspCompletionItem> treeMap2 = new TreeMap<String, JspCompletionItem>();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                String string2 = fileObject2.getNameExt();
                if (!string2.startsWith(string) || "cvs".equalsIgnoreCase(string2)) continue;
                if (fileObject2.isFolder()) {
                    treeMap.put(fileObject2.getNameExt(), JspCompletionItem.createFileCompletionItem(fileObject2.getNameExt() + "/", n, Color.BLUE, PACKAGE_ICON));
                    continue;
                }
                Image image = JspUtils.getIcon(fileObject2);
                if (image != null) {
                    treeMap2.put(fileObject2.getNameExt(), JspCompletionItem.createFileCompletionItem(fileObject2.getNameExt(), n, Color.BLACK, new ImageIcon(image)));
                    continue;
                }
                treeMap2.put(fileObject2.getNameExt(), JspCompletionItem.createFileCompletionItem(fileObject2.getNameExt(), n, Color.BLACK, null));
            }
            arrayList.addAll(treeMap.values());
            arrayList.addAll(treeMap2.values());
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaglibTagdir
    extends AttributeValueSupport.Default {
        public TaglibTagdir() {
            super(false, "taglib", "tagdir");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            FileObject fileObject;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileObject fileObject2 = jspSyntaxSupport.getFileObject();
            FileObject fileObject3 = JspUtils.guessWebModuleRoot(fileObject2);
            if (fileObject3 != null && (fileObject = JspUtils.findRelativeFileObject(fileObject3, "WEB-INF/tags")) != null) {
                if (this.isValidTagDir(fileObject)) {
                    arrayList.add(JspUtils.findRelativeContextPath(fileObject3, fileObject));
                }
                Enumeration enumeration = fileObject.getFolders(true);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject4 = (FileObject)enumeration.nextElement();
                    if (!this.isValidTagDir(fileObject4)) continue;
                    arrayList.add(JspUtils.findRelativeContextPath(fileObject3, fileObject4));
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        private boolean isValidTagDir(FileObject fileObject) {
            return fileObject.getChildren(false).hasMoreElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaglibURI
    extends AttributeValueSupport.Default {
        public TaglibURI() {
            super(false, "taglib", "uri");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Map map = jspSyntaxSupport.getTagLibraryMappings();
            if (map != null) {
                for (String string : map.keySet()) {
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetPropertyProperty
    extends GetSetPropertyProperty {
        public SetPropertyProperty() {
            super(true, "jsp:setProperty", "property");
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            List<String> list = this.possibleValues(jspSyntaxSupport, tagDirective, true);
            list.add(0, "*");
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetPropertyProperty
    extends GetSetPropertyProperty {
        public GetPropertyProperty() {
            super(true, "jsp:getProperty", "property");
        }

        @Override
        public List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            return this.possibleValues(jspSyntaxSupport, tagDirective, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GetSetPropertyProperty
    extends AttributeValueSupport.Default {
        public GetSetPropertyProperty(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = (String)tagDirective.getAttributes().get("name");
            if (string != null) {
                String string2 = null;
                PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
                for (int i = 0; i < beanDataArray.length; ++i) {
                    if (beanDataArray[i] == null || beanDataArray[i].getId() == null || !beanDataArray[i].getId().equals(string)) continue;
                    string2 = beanDataArray[i].getClassName();
                    break;
                }
                if (string2 != null) {
                    URLClassLoader uRLClassLoader = null;
                    try {
                        FileObject fileObject = NbEditorUtilities.getDataObject((Document)jspSyntaxSupport.getDocument()).getPrimaryFile();
                        uRLClassLoader = JspUtils.getModuleClassLoader(fileObject);
                        Class<?> clazz = Class.forName(string2, false, uRLClassLoader);
                        Introspector.flushFromCaches(clazz);
                        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                            if (bl && propertyDescriptorArray[i].getWriteMethod() != null) {
                                arrayList.add(propertyDescriptorArray[i].getName());
                            }
                            if (bl || propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getName().equals("class")) continue;
                            arrayList.add(propertyDescriptorArray[i].getName());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IntrospectionException introspectionException) {
                    }
                    finally {
                        if (uRLClassLoader != null && uRLClassLoader instanceof Closeable) {
                            try {
                                ((Closeable)uRLClassLoader).close();
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(AttrSupports.class.getName()).log(Level.INFO, null, iOException);
                            }
                        }
                    }
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetSetPropertyName
    extends AttributeValueSupport.Default {
        public GetSetPropertyName(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
            if (beanDataArray != null) {
                for (int i = 0; i < beanDataArray.length; ++i) {
                    arrayList.add(beanDataArray[i].getId());
                }
            }
            return arrayList;
        }
    }

    @Deprecated
    public static class PackageListSupport
    extends ClassNameSupport {
        public PackageListSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected String getFakedClassBody(String string) {
            int n = string.lastIndexOf(",");
            if (n > -1) {
                string = string.substring(n + 1);
            }
            return "import " + string;
        }
    }

    @Deprecated
    public static class ClassNameSupport
    extends AttributeValueSupport.Default {
        public ClassNameSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            return new ArrayList();
        }

        protected String getFakedClassBody(String string) {
            return "class Foo extends " + string;
        }

        public void result(JspCompletionQuery.CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            String string2 = this.getFakedClassBody(string);
            int n2 = string2.length();
            logger.fine("JSP CC: delegating CC query to java file:\n" + string2.substring(0, n2) + "|" + string2.substring(n2) + "\n");
            JavaJspCompletionProvider.CompletionQueryDelegatedToJava completionQueryDelegatedToJava = new JavaJspCompletionProvider.CompletionQueryDelegatedToJava(n, n2, 1);
            completionQueryDelegatedToJava.create(jTextComponent.getDocument(), string2);
            List<? extends CompletionItem> list = completionQueryDelegatedToJava.getCompletionItems();
            completionResultSet.addAllItems(list);
            completionResultSet.setAnchorOffset(n - (string.length() - string.lastIndexOf(46)) + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class YesNoTrueFalseSupport
    extends AttributeValueSupport.Default {
        public YesNoTrueFalseSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("false");
            arrayList.add("no");
            arrayList.add("true");
            arrayList.add("yes");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableScopeSupport
    extends AttributeValueSupport.Default {
        public VariableScopeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("AT_BEGIN");
            arrayList.add("AT_END");
            arrayList.add("NESTED");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PluginTypeSupport
    extends AttributeValueSupport.Default {
        public PluginTypeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("bean");
            arrayList.add("applet");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RootVersionSupport
    extends AttributeValueSupport.Default {
        public RootVersionSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1.2");
            arrayList.add("2.0");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BodyContentSupport
    extends AttributeValueSupport.Default {
        public BodyContentSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("scriptless");
            arrayList.add("tagdependent");
            arrayList.add("empty");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScopeSupport
    extends AttributeValueSupport.Default {
        public ScopeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        @Override
        protected List<String> possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("application");
            arrayList.add("page");
            arrayList.add("request");
            arrayList.add("session");
            return arrayList;
        }
    }
}

