/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.util.Mutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GizmoProjectOptions {
    private AuxiliaryConfiguration aux;
    private static final String GizmoData = "gizmo-options";
    private static final String GizmoDataCollectorEnabled = "gizmo-datacollector-enabled";
    private static final String GizmoDataCollectorName = "gizmo-datacollector-name";
    private static final String GizmoSelectedToolsName = "gizmo-selected-tools-names";
    private static final String GizmoToolName = "tool-name";
    private static final String GizmoUserIntreactionRequiredActionsEnabled = "gizmo-user-interaction-required-actions-enabled";
    private final String namespace;
    private final boolean shared;

    public GizmoProjectOptions(Project project, boolean bl) {
        this.shared = bl;
        this.aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        AntBasedProjectType antBasedProjectType = (AntBasedProjectType)project.getLookup().lookup(AntBasedProjectType.class);
        this.namespace = antBasedProjectType.getPrimaryConfigurationDataElementNamespace(bl);
    }

    public GizmoProjectOptions(Project project) {
        this(project, false);
    }

    public boolean getDataCollectorEnabled() {
        String string = this.doLoad(GizmoDataCollectorEnabled);
        return this.str2bool(string);
    }

    public void setDataCollectorEnabled(Boolean bl) {
        this.doSave(GizmoDataCollectorEnabled, bl.toString());
    }

    public String[] getSelectedTools() {
        String[] stringArray = this.doLoadChildrenContent(GizmoSelectedToolsName);
        return stringArray;
    }

    public void setSelectedTools(String[] stringArray) {
        this.doSave(GizmoSelectedToolsName, GizmoToolName, stringArray);
    }

    public boolean getUserInteractionRequiredActionsEnabled() {
        String string = this.doLoad(GizmoUserIntreactionRequiredActionsEnabled);
        return this.str2bool(string);
    }

    public void setUserInteractionRequiredActionsEnabled(Boolean bl) {
        this.doSave(GizmoUserIntreactionRequiredActionsEnabled, bl.toString());
    }

    public String getDataCollectorName() {
        String string = this.doLoad(GizmoDataCollectorName);
        return string;
    }

    public void setDataCollectorName(String string) {
        this.doSave(GizmoDataCollectorName, string);
    }

    private boolean str2bool(String string) {
        return string == null || string.length() == 0 ? false : Boolean.parseBoolean(string);
    }

    private Element getConfigurationFragment() {
        Element element = this.aux.getConfigurationFragment(GizmoData, this.namespace, this.shared);
        if (element == null) {
            element = GizmoProjectOptions.createDocument(this.namespace, this.shared ? "project" : "project-private").createElementNS(this.namespace, GizmoData);
        }
        if (element == null) {
            System.err.println("GizmoProjectOptions: Failed to load and create configuration fragment (gizmo-options : " + this.namespace + ")");
        }
        return element;
    }

    private Element getNode(Element element, String string) {
        Element element2;
        NodeList nodeList = element.getElementsByTagNameNS(this.namespace, string);
        if (nodeList.getLength() == 0) {
            element2 = element.getOwnerDocument().createElementNS(this.namespace, string);
            element.appendChild(element2);
        } else {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private String doLoad(final String string) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element element = GizmoProjectOptions.this.getConfigurationFragment();
                if (element == null) {
                    return null;
                }
                return GizmoProjectOptions.this.getNode(element, string).getTextContent();
            }
        });
    }

    private String[] doLoadChildrenContent(final String string) {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            public String[] run() {
                Element element = GizmoProjectOptions.this.getConfigurationFragment();
                if (element == null) {
                    return null;
                }
                Element element2 = GizmoProjectOptions.this.getNode(element, string);
                NodeList nodeList = element2.getChildNodes();
                if (nodeList == null || nodeList.getLength() == 0) {
                    return null;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    if (nodeList.item(i).getNodeType() != 1) continue;
                    arrayList.add(nodeList.item(i).getTextContent());
                }
                return arrayList.toArray(new String[0]);
            }
        });
    }

    private void doSave(final String string, final String string2, final String[] stringArray) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Element element = GizmoProjectOptions.this.getConfigurationFragment();
                if (element != null) {
                    Element element2 = GizmoProjectOptions.this.getNode(element, string);
                    Element element3 = element.getOwnerDocument().createElementNS(GizmoProjectOptions.this.namespace, string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Element element4 = element.getOwnerDocument().createElement(string2);
                        element4.setTextContent(stringArray[i]);
                        element3.appendChild(element4);
                    }
                    element.removeChild(element2);
                    element.appendChild(element3);
                    GizmoProjectOptions.this.aux.putConfigurationFragment(element, GizmoProjectOptions.this.shared);
                }
            }
        });
    }

    private void doSave(final String string, final String string2) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Element element = GizmoProjectOptions.this.getConfigurationFragment();
                if (element != null) {
                    Element element2 = GizmoProjectOptions.this.getNode(element, string);
                    element2.setTextContent(string2);
                    GizmoProjectOptions.this.aux.putConfigurationFragment(element, GizmoProjectOptions.this.shared);
                }
            }
        });
    }

    private static Document createDocument(String string, String string2) throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation().createDocument(string, string2, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(parserConfigurationException);
        }
    }
}

