/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.actions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteBinaryService;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.gizmo.GizmoConfigurationOptions;
import org.netbeans.modules.cnd.gizmo.GizmoServiceInfoAccessor;
import org.netbeans.modules.cnd.gizmo.api.GizmoOptionsProvider;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.support.NativeExecutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class GizmoRunActionHandler
implements ProjectActionHandler,
DLightTargetListener {
    private static final String GNU_FAMILIY = "gc++filt";
    private static final String SS_FAMILIY = "dem";
    private ProjectActionEvent pae;
    private List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private DLightToolkitManagement.DLightSessionHandler session;
    private InputOutput io;
    private long startTimeMillis;

    public void init(ProjectActionEvent projectActionEvent, ProjectActionEvent[] projectActionEventArray) {
        this.pae = projectActionEvent;
    }

    public void execute(InputOutput inputOutput) {
        String string;
        String string2;
        Object object;
        PathMap pathMap;
        MakeConfiguration makeConfiguration = this.pae.getConfiguration();
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        GizmoOptions gizmoOptions = GizmoOptionsProvider.getOptions((Configuration)makeConfiguration);
        gizmoOptions.init((Configuration)makeConfiguration);
        DLightConfiguration dLightConfiguration = gizmoOptions.getDLightConfiguration();
        Map map = this.pae.getProfile().getEnvironment().getenvAsMap();
        NativeExecutableTargetConfiguration nativeExecutableTargetConfiguration = new NativeExecutableTargetConfiguration(this.pae.getExecutable(), this.pae.getProfile().getArgsArray(), map);
        String string3 = this.pae.getExecutable();
        String string4 = this.pae.getProfile().getRunDirectory();
        boolean bl = dLightConfiguration.getCollectorProviders().contains("SunStudio");
        if (executionEnvironment.isRemote()) {
            pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
            string4 = pathMap.getRemotePath(string4, true);
            if (bl) {
                nativeExecutableTargetConfiguration.putInfo("GizmoProjectExecutable", string3);
            } else {
                object = RemoteBinaryService.getRemoteBinary((ExecutionEnvironment)executionEnvironment, (String)string3);
                nativeExecutableTargetConfiguration.putInfo("GizmoProjectExecutable", object.toIDString());
            }
        } else {
            nativeExecutableTargetConfiguration.putInfo("GizmoProjectExecutable", string3);
        }
        nativeExecutableTargetConfiguration.setExecutionEnvironment(executionEnvironment);
        if (executionEnvironment.isRemote() && ServerList.get((ExecutionEnvironment)executionEnvironment).getX11Forwarding() && !map.containsKey("DISPLAY")) {
            nativeExecutableTargetConfiguration.setX11Forwarding(true);
        }
        nativeExecutableTargetConfiguration.putInfo("service.storage.execution.env.key", ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment));
        nativeExecutableTargetConfiguration.putInfo(GizmoServiceInfoAccessor.getDefault().getGIZMO_RUN(), "gizmo.run");
        nativeExecutableTargetConfiguration.putInfo("gizmo.platform", this.pae.getConfiguration().getDevelopmentHost().getBuildPlatformDisplayName());
        nativeExecutableTargetConfiguration.putInfo("GizmoProjectFolder", FileUtil.toFile((FileObject)this.pae.getProject().getProjectDirectory()).getAbsolutePath());
        nativeExecutableTargetConfiguration.putInfo("sunstudio.datafilter.collectedobjects", System.getProperty("sunstudio.datafilter.collectedobjects", ""));
        nativeExecutableTargetConfiguration.putInfo("sunstudio.hotspotfunctionsfilter", System.getProperty("sunstudio.hotspotfunctionsfilter", ""));
        pathMap = makeConfiguration.getCompilerSet().getCompilerSet();
        object = pathMap.getDirectory();
        String string5 = SS_FAMILIY;
        if (pathMap.isGnuCompiler()) {
            string5 = GNU_FAMILIY;
        }
        String string6 = (String)object + "/" + string5;
        nativeExecutableTargetConfiguration.putInfo("GizmoDemangleUtility", string6);
        nativeExecutableTargetConfiguration.putInfo("GizmoCppCompiler", pathMap.isGnuCompiler() ? CppSymbolDemanglerFactory.CPPCompiler.GNU.toString() : CppSymbolDemanglerFactory.CPPCompiler.SS.toString());
        nativeExecutableTargetConfiguration.putInfo("GizmoCppCompilerBinPath", (String)object);
        nativeExecutableTargetConfiguration.setWorkingDirectory(string4);
        int n = this.pae.getProfile().getConsoleType().getValue();
        if (n == 0) {
            n = RunProfile.getDefaultConsoleType();
        }
        if (n == 1 && (string2 = this.pae.getProfile().getTerminalPath()) != null) {
            string = IpeUtils.getBaseName((String)string2);
            if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(string)) {
                nativeExecutableTargetConfiguration.useExternalTerminal(ExternalTerminalProvider.getTerminal((ExecutionEnvironment)executionEnvironment, (String)string));
            }
        }
        this.io = inputOutput;
        nativeExecutableTargetConfiguration.setIO(inputOutput);
        nativeExecutableTargetConfiguration.setOutConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new SimpleOutputConvertorFactory());
        string2 = dLightConfiguration.getConfigurationOptions(false);
        if (string2 instanceof GizmoConfigurationOptions) {
            ((GizmoConfigurationOptions)((Object)string2)).configure(this.pae.getProject());
        }
        string = new NativeExecutableTarget(nativeExecutableTargetConfiguration);
        string.addTargetListener((DLightTargetListener)this);
        final Future future = DLightToolkitManagement.getInstance().createSession((DLightTarget)string, dLightConfiguration, IpeUtils.getBaseName((String)this.pae.getExecutable()));
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                try {
                    GizmoRunActionHandler.this.session = (DLightToolkitManagement.DLightSessionHandler)future.get();
                    DLightToolkitManagement.getInstance().startSession(GizmoRunActionHandler.this.session);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
            }
        }, (String)("DLight Session for " + string.toString()));
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        if (this.session != null) {
            DLightToolkitManagement.getInstance().stopSession(this.session);
            this.session = null;
        }
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        if (!this.listeners.contains(executionListener)) {
            this.listeners.add(executionListener);
        }
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case INIT: 
            case STARTING: {
                break;
            }
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.status);
                break;
            }
            case FAILED: 
            case STOPPED: {
                this.targetFailed();
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.status);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.status);
            }
        }
    }

    private void targetStarted(int n) {
        this.startTimeMillis = System.currentTimeMillis();
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionStarted(n);
        }
    }

    private void targetFailed() {
        StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunFailedToStart", new Object[0]));
        this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunFailedToStart", new Object[0]));
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(-1);
        }
    }

    private void targetFinished(Integer n) {
        int n2 = -1;
        this.io.getOut().println();
        if (n == null) {
            StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunTerminated", new Object[0]));
            this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunTerminated", new Object[0]));
        } else {
            n2 = n;
            boolean bl = n2 == 0;
            StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage(bl ? "Status.RunSuccessful" : "Status.RunFailed", new Object[0]));
            String string = GizmoRunActionHandler.formatTime(System.currentTimeMillis() - this.startTimeMillis);
            if (bl) {
                this.io.getOut().println(GizmoRunActionHandler.getMessage("Output.RunSuccessful", string));
            } else {
                this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunFailed", n2, string));
            }
        }
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(n2);
        }
    }

    private static String formatTime(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        if (l4 > 0L) {
            stringBuilder.append(' ').append(l4).append(GizmoRunActionHandler.getMessage("Time.Hour", new Object[0]));
        }
        if (l3 > 0L) {
            stringBuilder.append(' ').append(l3 % 60L).append(GizmoRunActionHandler.getMessage("Time.Minute", new Object[0]));
        }
        if (l2 > 0L) {
            stringBuilder.append(' ').append(l2 % 60L).append(GizmoRunActionHandler.getMessage("Time.Second", new Object[0]));
        }
        if (l4 == 0L && l3 == 0L && l2 == 0L) {
            stringBuilder.append(' ').append(l).append(GizmoRunActionHandler.getMessage("Time.Millisecond", new Object[0]));
        }
        return stringBuilder.toString();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(GizmoRunActionHandler.class, (String)string, (Object[])objectArray);
    }

    private static class SimpleOutputConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private SimpleOutputConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            return LineConvertors.proxy((LineConvertor[])new LineConvertor[]{LineConvertors.filePattern(null, (Pattern)Pattern.compile("^file://([^:]*[^ ])(:)([0-9]*).*"), null, (int)1, (int)3), LineConvertors.httpUrl()});
        }
    }
}

