/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.input;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.extexecution.input.LineParsingHelper;
import org.openide.util.Parameters;
import org.openide.windows.OutputWriter;

public final class InputProcessors {
    private static final Logger LOGGER = Logger.getLogger(InputProcessors.class.getName());

    private InputProcessors() {
    }

    @NonNull
    public static InputProcessor bridge(@NonNull LineProcessor lineProcessor) {
        return new Bridge(lineProcessor);
    }

    @NonNull
    public static InputProcessor proxy(InputProcessor ... inputProcessorArray) {
        return new ProxyInputProcessor(inputProcessorArray);
    }

    @NonNull
    public static InputProcessor copying(@NonNull Writer writer) {
        return new CopyingInputProcessor(writer);
    }

    @NonNull
    public static InputProcessor printing(@NonNull OutputWriter outputWriter, boolean bl) {
        return InputProcessors.printing(outputWriter, null, bl);
    }

    @NonNull
    public static InputProcessor printing(@NonNull OutputWriter outputWriter, @NullAllowed LineConvertor lineConvertor, boolean bl) {
        return new PrintingInputProcessor(outputWriter, lineConvertor, bl);
    }

    @NonNull
    public static InputProcessor ansiStripping(@NonNull InputProcessor inputProcessor) {
        return new AnsiStrippingInputProcessor(inputProcessor);
    }

    private static class AnsiStrippingInputProcessor
    implements InputProcessor {
        private final InputProcessor delegate;
        private boolean closed;

        public AnsiStrippingInputProcessor(InputProcessor inputProcessor) {
            this.delegate = inputProcessor;
        }

        public void processInput(char[] cArray) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            String string = new String(cArray);
            if (AnsiStrippingInputProcessor.containsAnsiColors(string)) {
                string = AnsiStrippingInputProcessor.stripAnsiColors(string);
            }
            this.delegate.processInput(string.toCharArray());
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.closed = true;
            this.delegate.close();
        }

        private static boolean containsAnsiColors(String string) {
            return string.indexOf("\u001b[") != -1;
        }

        private static String stripAnsiColors(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n = 0;
            int n2 = string.length();
            block0: while (n < n2) {
                int n3;
                int n4 = string.indexOf("\u001b[", n);
                if (n4 == -1) {
                    n4 = string.length();
                }
                int n5 = n3 = n4 == -1 ? n2 : n4;
                while (n < n3) {
                    stringBuilder.append(string.charAt(n));
                    ++n;
                }
                if (n4 == -1) continue;
                while (n < n2) {
                    n3 = string.charAt(n);
                    if (n3 == 109) {
                        ++n;
                        continue block0;
                    }
                    ++n;
                }
            }
            return stringBuilder.toString();
        }
    }

    private static class CopyingInputProcessor
    implements InputProcessor {
        private final Writer writer;
        private boolean closed;

        public CopyingInputProcessor(Writer writer) {
            this.writer = writer;
        }

        public void processInput(char[] cArray) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            LOGGER.log(Level.FINEST, Arrays.toString(cArray));
            this.writer.write(cArray);
            this.writer.flush();
        }

        public void reset() {
        }

        public void close() throws IOException {
            this.closed = true;
            this.writer.close();
        }
    }

    private static class PrintingInputProcessor
    implements InputProcessor {
        private final OutputWriter out;
        private final LineConvertor convertor;
        private final boolean resetEnabled;
        private final LineParsingHelper helper = new LineParsingHelper();
        private boolean closed;

        public PrintingInputProcessor(OutputWriter outputWriter, LineConvertor lineConvertor, boolean bl) {
            assert (outputWriter != null);
            this.out = outputWriter;
            this.convertor = lineConvertor;
            this.resetEnabled = bl;
        }

        public void processInput(char[] cArray) {
            String[] stringArray;
            assert (cArray != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (String string : stringArray = this.helper.parse(cArray)) {
                LOGGER.log(Level.FINEST, "{0}\\n", string);
                this.convert(string);
                this.out.flush();
            }
            String string = this.helper.getTrailingLine(true);
            if (string != null) {
                LOGGER.log(Level.FINEST, string);
                this.out.print(string);
                this.out.flush();
            }
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.resetEnabled) {
                return;
            }
            this.out.reset();
        }

        public void close() throws IOException {
            this.closed = true;
            this.out.close();
        }

        private void convert(String string) {
            if (this.convertor == null) {
                this.out.println(string);
                return;
            }
            List<ConvertedLine> list = this.convertor.convert(string);
            if (list == null) {
                this.out.println(string);
                return;
            }
            for (ConvertedLine convertedLine : list) {
                if (convertedLine.getListener() == null) {
                    this.out.println(convertedLine.getText());
                    continue;
                }
                try {
                    this.out.println(convertedLine.getText(), convertedLine.getListener());
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                    this.out.println(convertedLine.getText());
                }
            }
        }
    }

    private static class ProxyInputProcessor
    implements InputProcessor {
        private final List<InputProcessor> processors = new ArrayList<InputProcessor>();
        private boolean closed;

        public ProxyInputProcessor(InputProcessor ... inputProcessorArray) {
            for (InputProcessor inputProcessor : inputProcessorArray) {
                if (inputProcessor == null) continue;
                this.processors.add(inputProcessor);
            }
        }

        public void processInput(char[] cArray) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (InputProcessor inputProcessor : this.processors) {
                inputProcessor.processInput(cArray);
            }
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (InputProcessor inputProcessor : this.processors) {
                inputProcessor.reset();
            }
        }

        public void close() throws IOException {
            this.closed = true;
            for (InputProcessor inputProcessor : this.processors) {
                inputProcessor.close();
            }
        }
    }

    private static class Bridge
    implements InputProcessor {
        private final LineProcessor lineProcessor;
        private final LineParsingHelper helper = new LineParsingHelper();
        private boolean closed;

        public Bridge(LineProcessor lineProcessor) {
            Parameters.notNull((CharSequence)"lineProcessor", (Object)lineProcessor);
            this.lineProcessor = lineProcessor;
        }

        public final void processInput(char[] cArray) {
            String[] stringArray;
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            for (String string : stringArray = this.helper.parse(cArray)) {
                this.lineProcessor.processLine(string);
            }
        }

        public final void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            this.flush();
            this.lineProcessor.reset();
        }

        public final void close() {
            this.closed = true;
            this.flush();
            this.lineProcessor.close();
        }

        private void flush() {
            String string = this.helper.getTrailingLine(true);
            if (string != null) {
                this.lineProcessor.processLine(string);
            }
        }
    }
}

