/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class DebuggerEngineProvider {
    public abstract String[] getLanguages();

    public abstract String getEngineTypeID();

    public abstract Object[] getServices();

    public abstract void setDestructor(DebuggerEngine.Destructor var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextAware
    extends DebuggerEngineProvider
    implements ContextAwareService<DebuggerEngineProvider> {
        private String serviceName;
        private ContextProvider context;
        private DebuggerEngineProvider delegate;

        private ContextAware(String string) {
            this.serviceName = string;
        }

        private ContextAware(String string, ContextProvider contextProvider) {
            this.serviceName = string;
            this.context = contextProvider;
        }

        private synchronized DebuggerEngineProvider getDelegate() {
            if (this.delegate == null) {
                this.delegate = (DebuggerEngineProvider)ContextAwareSupport.createInstance(this.serviceName, this.context);
            }
            return this.delegate;
        }

        @Override
        public DebuggerEngineProvider forContext(ContextProvider contextProvider) {
            if (contextProvider == this.context) {
                return this;
            }
            return new ContextAware(this.serviceName, contextProvider);
        }

        @Override
        public String[] getLanguages() {
            return this.getDelegate().getLanguages();
        }

        @Override
        public String getEngineTypeID() {
            return this.getDelegate().getEngineTypeID();
        }

        @Override
        public Object[] getServices() {
            return this.getDelegate().getServices();
        }

        @Override
        public void setDestructor(DebuggerEngine.Destructor destructor) {
            this.getDelegate().setDestructor(destructor);
        }

        static ContextAwareService createService(Map map) throws ClassNotFoundException {
            String string = (String)map.get("serviceName");
            return new ContextAware(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

