/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.filter.FilterNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FiltersNode
extends ContainerNode {
    private static final String FILTERS_STRING = NbBundle.getMessage(FiltersNode.class, (String)"FiltersNode_FiltersString");

    public FiltersNode(ContainerNode containerNode) {
        super(FILTERS_STRING, (Icon)Utils.PACKAGE_ICON, containerNode);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Children
    extends GreedySelectorChildren<FiltersNode> {
        private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();

        public Children() {
            this.scope.add(ClassIndex.SearchScope.SOURCE);
            this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
        }

        protected List<SelectorNode> prepareChildren(FiltersNode filtersNode) {
            HashSet<SelectorNode> hashSet = new HashSet<SelectorNode>();
            try {
                Project project = (Project)filtersNode.getLookup().lookup(Project.class);
                ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project);
                Collection<FileObject> collection = WebProjectUtils.getDeploymentDescriptorFileObjects(project, true);
                for (FileObject fileObject : collection) {
                    this.enumerateFilters(filtersNode, classpathInfo, hashSet, fileObject);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new ArrayList<SelectorNode>(hashSet);
        }

        private void enumerateFilters(final FiltersNode filtersNode, final ClasspathInfo classpathInfo, final Collection<SelectorNode> collection, FileObject fileObject) throws IOException, IllegalArgumentException {
            final WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Filter filter : webApp.getFilter()) {
                hashMap.put(filter.getFilterName(), filter.getFilterClass());
            }
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (FilterMapping filterMapping : webApp.getFilterMapping()) {
                        TypeElement typeElement;
                        String string = (String)hashMap.get(filterMapping.getFilterName());
                        TypeElement typeElement2 = typeElement = string != null ? compilationController.getElements().getTypeElement(string) : null;
                        if (typeElement == null) continue;
                        String string2 = filterMapping.getUrlPattern();
                        if (string2 == null) {
                            String string3 = filterMapping.getServletName();
                            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                                if (!string3.equals(servletMapping.getServletName())) continue;
                                string2 = servletMapping.getUrlPattern();
                                break;
                            }
                        }
                        if (string2 == null) continue;
                        collection.add(new FilterNode(classpathInfo, typeElement, filterMapping.getFilterName(), string2, filtersNode));
                    }
                }
            }, true);
        }
    }
}

