/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.TimedWeakReference;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.ParserAccessor;
import org.netbeans.modules.parsing.impl.ResultIteratorAccessor;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.impl.indexing.lucene.LMListener;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserManager {
    private static Map<String, Reference<Parser>> cachedParsers = new HashMap<String, Reference<Parser>>();

    private ParserManager() {
    }

    public static void parse(Collection<Source> collection, UserTask userTask) throws ParseException {
        if (collection.size() == 1) {
            TaskProcessor.runUserTask(new UserTaskAction(collection.iterator().next(), userTask), collection);
        } else {
            TaskProcessor.runUserTask(new MultiUserTaskAction(collection, userTask), collection);
        }
    }

    public static Future<Void> parseWhenScanFinished(Collection<Source> collection, UserTask userTask) throws ParseException {
        if (collection.size() == 1) {
            return TaskProcessor.runWhenScanFinished(new UserTaskAction(collection.iterator().next(), userTask), collection);
        }
        return TaskProcessor.runWhenScanFinished(new MultiUserTaskAction(collection, userTask), collection);
    }

    public static void parse(String string, UserTask userTask) throws ParseException {
        Parser parser = ParserManager.findParser(string);
        TaskProcessor.runUserTask(new MimeTaskAction(parser, userTask), Collections.<Source>emptyList());
    }

    public static Future<Void> parseWhenScanFinished(String string, UserTask userTask) throws ParseException {
        Parser parser = ParserManager.findParser(string);
        return TaskProcessor.runWhenScanFinished(new MimeTaskAction(parser, userTask), Collections.<Source>emptyList());
    }

    private static Parser findParser(String string) {
        Parser parser = null;
        Reference<Parser> reference = cachedParsers.get(string);
        if (reference != null) {
            parser = reference.get();
        }
        if (parser == null) {
            Lookup lookup = MimeLookup.getLookup((String)string);
            ParserFactory parserFactory = (ParserFactory)lookup.lookup(ParserFactory.class);
            if (parserFactory == null) {
                throw new IllegalArgumentException("No parser for mime type: " + string);
            }
            parser = parserFactory.createParser(Collections.<Snapshot>emptyList());
            cachedParsers.put(string, new TimedWeakReference<Parser>(parser));
        }
        return parser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MimeTaskAction
    implements Mutex.ExceptionAction<Void> {
        private final UserTask userTask;
        private final Parser parser;

        public MimeTaskAction(Parser parser, UserTask userTask) {
            assert (userTask != null);
            assert (parser != null);
            this.userTask = userTask;
            this.parser = parser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run() throws Exception {
            this.parser.parse(null, this.userTask, null);
            Parser.Result result = this.parser.getResult(this.userTask);
            try {
                this.userTask.run(new ResultIterator(result));
            }
            finally {
                ParserAccessor.getINSTANCE().invalidate(result);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazySnapshots
    implements Collection<Snapshot> {
        private final Collection<? extends Source> sources;

        public LazySnapshots(Collection<? extends Source> collection) {
            assert (collection != null);
            this.sources = collection;
        }

        @Override
        public int size() {
            return this.sources.size();
        }

        @Override
        public boolean isEmpty() {
            return this.sources.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)object;
            return this.sources.contains(snapshot.getSource());
        }

        @Override
        public Iterator<Snapshot> iterator() {
            return new LazySnapshotsIt(this.sources.iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.sources.size()];
            this.fill(objectArray);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            Class<Snapshot> clazz = objectArray.getClass().getComponentType();
            if (!clazz.isAssignableFrom(Snapshot.class)) {
                throw new ArrayStoreException("Can't store Snapshot instances to an array of " + clazz.getName());
            }
            int n = this.sources.size();
            if (objectArray.length < n) {
                Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
                objectArray = objectArray2;
            }
            this.fill(objectArray);
            return objectArray;
        }

        private void fill(Object[] objectArray) {
            Iterator<? extends Source> iterator = this.sources.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                SourceCache sourceCache = SourceAccessor.getINSTANCE().getCache(iterator.next());
                objectArray[n] = sourceCache.getSnapshot();
                ++n;
            }
        }

        @Override
        public boolean add(Snapshot snapshot) {
            throw new UnsupportedOperationException("Read only collection.");
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Read only collection.");
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Snapshot> collection) {
            throw new UnsupportedOperationException("Read only collection.");
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Read only collection.");
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Read only collection.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Read only collection.");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class LazySnapshotsIt
        implements Iterator<Snapshot> {
            private final Iterator<? extends Source> sourcesIt;

            public LazySnapshotsIt(Iterator<? extends Source> iterator) {
                assert (iterator != null);
                this.sourcesIt = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.sourcesIt.hasNext();
            }

            @Override
            public Snapshot next() {
                SourceCache sourceCache = SourceAccessor.getINSTANCE().getCache(this.sourcesIt.next());
                return sourceCache.getSnapshot();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read only collection.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiUserTaskAction
    implements Mutex.ExceptionAction<Void> {
        private final UserTask userTask;
        private final Collection<Source> sources;

        public MultiUserTaskAction(Collection<Source> collection, UserTask userTask) {
            assert (collection != null);
            assert (userTask != null);
            this.userTask = userTask;
            this.sources = collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run() throws Exception {
            LMListener lMListener = new LMListener();
            Parser parser = null;
            LazySnapshots lazySnapshots = new LazySnapshots(this.sources);
            for (Source source : this.sources) {
                Object object;
                Object object2;
                if (parser == null && (object2 = (ParserFactory)(object = MimeLookup.getLookup((String)source.getMimeType())).lookup(ParserFactory.class)) != null) {
                    parser = ((ParserFactory)object2).createParser(lazySnapshots);
                }
                object = new SourceCache(source, null);
                object2 = new ResultIterator((SourceCache)object, parser, this.userTask);
                try {
                    this.userTask.run((ResultIterator)object2);
                }
                finally {
                    ResultIteratorAccessor.getINSTANCE().invalidate((ResultIterator)object2);
                }
                if (!lMListener.isLowMemory()) continue;
                parser = null;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserTaskAction
    implements Mutex.ExceptionAction<Void> {
        private final UserTask userTask;
        private final Source source;

        public UserTaskAction(Source source, UserTask userTask) {
            assert (source != null);
            assert (userTask != null);
            this.userTask = userTask;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run() throws Exception {
            SourceCache sourceCache = SourceAccessor.getINSTANCE().getCache(this.source);
            ResultIterator resultIterator = new ResultIterator(sourceCache, this.userTask);
            try {
                this.userTask.run(resultIterator);
            }
            finally {
                ResultIteratorAccessor.getINSTANCE().invalidate(resultIterator);
            }
            return null;
        }
    }
}

