/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskProcessor {
    private static final Logger LOGGER;
    private static final int SLOW_CANCEL_LIMIT = 50;
    private static final int DEFAULT_REPARSE_DELAY = 500;
    public static int reparseDelay;
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<Source, Collection<Request>> finishedRequests;
    private static final Map<Source, Collection<Request>> waitingRequests;
    private static final Collection<SchedulerTask> toRemove;
    static final WorkerThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final List<DeferredTask> todo;
    public static final Object INTERNAL_LOCK;
    private static final ReentrantLock parserLock;
    private static int lockCount;
    private static final Pattern excludedTasks;
    private static final Pattern includedTasks;
    private static final Set<StackTraceElement> warnedAboutRunInEQ;
    private static final AtomicReference<Request> rst;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUserTask(Mutex.ExceptionAction<Void> exceptionAction, Collection<Source> collection) throws ParseException {
        Object object;
        Parameters.notNull((CharSequence)"task", exceptionAction);
        if (collection.size() == 1) {
            SourceAccessor.getINSTANCE().assignListeners(collection.iterator().next());
        }
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && SwingUtilities.isEventDispatchThread() && (object = Util.findCaller(Thread.currentThread().getStackTrace(), TaskProcessor.class, ParserManager.class, "org.netbeans.api.java.source.JavaSource")) != null && warnedAboutRunInEQ.add((StackTraceElement)object)) {
            LOGGER.warning("ParserManager.parse called in AWT event thread by: " + object);
        }
        object = currentRequest.getTaskToCancel();
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
            parserLock.lock();
            try {
                try {
                    if (lockCount < 1) {
                        for (Source source : collection) {
                            SourceAccessor.getINSTANCE().invalidate(source, false);
                        }
                    }
                    ++lockCount;
                    exceptionAction.run();
                }
                catch (Exception exception) {
                    ParseException parseException = new ParseException();
                    parseException.initCause(exception);
                    throw parseException;
                }
                Object var7_8 = null;
                --lockCount;
                parserLock.unlock();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                --lockCount;
                parserLock.unlock();
                throw throwable;
            }
            Object var9_11 = null;
            currentRequest.cancelCompleted((Request)object);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            currentRequest.cancelCompleted((Request)object);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static Future<Void> runWhenScanFinished(Mutex.ExceptionAction<Void> var0, Collection<Source> var1_1) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addPhaseCompletionTasks(Collection<SchedulerTask> collection, SourceCache sourceCache, boolean bl, Class<? extends Scheduler> clazz) {
        TaskProcessor.addPhaseCompletionTasks(collection, sourceCache, sourceCache.getSnapshot().getSource(), bl, clazz);
    }

    private static void addPhaseCompletionTasks(Collection<SchedulerTask> collection, SourceCache sourceCache, Source source, boolean bl, Class<? extends Scheduler> clazz) {
        Parameters.notNull((CharSequence)"task", collection);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"cache", (Object)sourceCache);
        ArrayList<Request> arrayList = new ArrayList<Request>();
        for (SchedulerTask schedulerTask : collection) {
            String string = schedulerTask.getClass().getName();
            if (excludedTasks != null && excludedTasks.matcher(string).matches() && (includedTasks == null || !includedTasks.matcher(string).matches())) continue;
            arrayList.add(new Request(schedulerTask, sourceCache, true, bl, clazz));
        }
        if (!arrayList.isEmpty()) {
            TaskProcessor.handleAddRequests(source, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePhaseCompletionTasks(Collection<? extends SchedulerTask> collection, Source source) {
        Parameters.notNull((CharSequence)"task", collection);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            Collection<Request> collection2 = finishedRequests.get(source);
            boolean bl = false;
            for (SchedulerTask schedulerTask : collection) {
                String string = schedulerTask.getClass().getName();
                if (excludedTasks != null && excludedTasks.matcher(string).matches() && (includedTasks == null || !includedTasks.matcher(string).matches())) continue;
                if (collection2 != null) {
                    Iterator<Request> iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        Request request = iterator.next();
                        if (request.task != schedulerTask) continue;
                        iterator.remove();
                        bl = true;
                    }
                }
                if (!bl) {
                    toRemove.add(schedulerTask);
                    requests.add(Request.NONE);
                }
                SourceAccessor.getINSTANCE().taskRemoved(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rescheduleTasks(Collection<SchedulerTask> collection, Source source, Class<? extends Scheduler> clazz) {
        Parameters.notNull((CharSequence)"task", collection);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            Request request = currentRequest.getTaskToCancel(collection);
            try {
                Collection<Request> collection2 = finishedRequests.get(source);
                if (collection2 != null) {
                    for (SchedulerTask schedulerTask : collection) {
                        if (request != null && request.task == schedulerTask) continue;
                        ArrayList<Request> arrayList = new ArrayList<Request>();
                        Iterator<Request> iterator = collection2.iterator();
                        while (iterator.hasNext()) {
                            Request request2 = iterator.next();
                            if (schedulerTask != request2.task) continue;
                            iterator.remove();
                            request2.schedulerType = clazz;
                            arrayList.add(request2);
                            if (collection2.size() != 0) break;
                            finishedRequests.remove(source);
                            break;
                        }
                        requests.addAll(arrayList);
                    }
                }
                Object var12_11 = null;
                if (request != null) {
                    currentRequest.cancelCompleted(request);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (request != null) {
                    currentRequest.cancelCompleted(request);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePhaseCompletionTask(Collection<SchedulerTask> collection, Collection<SchedulerTask> collection2, Source source, SourceCache sourceCache, Class<? extends Scheduler> clazz) {
        Parameters.notNull((CharSequence)"add", collection);
        Parameters.notNull((CharSequence)"remove", collection2);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"cache", (Object)sourceCache);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            TaskProcessor.removePhaseCompletionTasks(collection2, source);
            TaskProcessor.addPhaseCompletionTasks(collection, sourceCache, source, false, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Request resetState(Source source, boolean bl, boolean bl2) {
        assert (source != null);
        Request request = currentRequest.getTaskToCancel(bl);
        if (request == null) return request;
        try {
            request.task.cancel();
            Object var5_4 = null;
            if (!bl2) return request;
            Request request2 = rst.getAndSet(request);
            if ($assertionsDisabled || request2 == null) return request;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl2) throw throwable;
            Request request3 = rst.getAndSet(request);
            if ($assertionsDisabled || request3 == null) throw throwable;
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStateImpl(Source source) {
        Request request = rst.getAndSet(null);
        currentRequest.cancelCompleted(request);
        if (source != null) {
            Object object = INTERNAL_LOCK;
            synchronized (object) {
                Collection<Request> collection;
                boolean bl = SourceAccessor.getINSTANCE().testAndCleanFlags(source, SourceFlags.RESCHEDULE_FINISHED_TASKS, EnumSet.of(SourceFlags.RESCHEDULE_FINISHED_TASKS, SourceFlags.CHANGE_EXPECTED));
                if (bl && (collection = finishedRequests.remove(source)) != null && collection.size() > 0) {
                    requests.addAll(collection);
                }
                if ((collection = waitingRequests.remove(source)) != null && collection.size() > 0) {
                    requests.addAll(collection);
                }
            }
        }
    }

    static void acquireParserLock() {
        parserLock.lock();
    }

    static void releaseParserLock() {
        parserLock.unlock();
    }

    static boolean holdsParserLock() {
        return parserLock.isHeldByCurrentThread();
    }

    static void scheduleSpecialTask(SchedulerTask schedulerTask) {
        assert (schedulerTask != null);
        Request request = new Request(schedulerTask, null, false, true, null);
        TaskProcessor.handleAddRequests(null, Collections.singletonList(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequests(Source source, List<Request> list) {
        assert (list != null);
        if (list.isEmpty()) {
            return;
        }
        if (source != null) {
            SourceAccessor.getINSTANCE().assignListeners(source);
        }
        int n = Integer.MAX_VALUE;
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            for (Request request : list) {
                toRemove.remove(request.task);
                n = Math.min(n, request.task.getPriority());
            }
            requests.addAll(list);
        }
        object = currentRequest.getTaskToCancel(n);
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
            Object var8_7 = null;
            currentRequest.cancelCompleted((Request)object);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            currentRequest.cancelCompleted((Request)object);
            throw throwable;
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<Source> iterable) {
        assert (iterable != null);
        Class<AbstractDocument> clazz = AbstractDocument.class;
        try {
            Method method = clazz.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread thread = Thread.currentThread();
            for (Source source : iterable) {
                try {
                    Object object;
                    Document document = source.getDocument(true);
                    if (!(document instanceof AbstractDocument) || (object = method.invoke((Object)document, new Object[0])) != thread) continue;
                    return true;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return false;
    }

    static /* synthetic */ Collection access$700() {
        return toRemove;
    }

    static /* synthetic */ Map access$800() {
        return finishedRequests;
    }

    static /* synthetic */ PriorityBlockingQueue access$900() {
        return requests;
    }

    static /* synthetic */ CurrentRequestReference access$1000() {
        return currentRequest;
    }

    static /* synthetic */ Logger access$1300() {
        return LOGGER;
    }

    static /* synthetic */ Map access$1500() {
        return waitingRequests;
    }

    static /* synthetic */ int access$1608() {
        return lockCount++;
    }

    static /* synthetic */ int access$1610() {
        return lockCount--;
    }

    static {
        Object object;
        LOGGER = Logger.getLogger(TaskProcessor.class.getName());
        reparseDelay = 500;
        requests = new PriorityBlockingQueue<Request>(10, new RequestPriorityComparator());
        finishedRequests = new WeakHashMap<Source, Collection<Request>>();
        waitingRequests = new WeakHashMap<Source, Collection<Request>>();
        toRemove = new LinkedList<SchedulerTask>();
        factory = new WorkerThreadFactory();
        currentRequest = new CurrentRequestReference();
        todo = Collections.synchronizedList(new LinkedList());
        INTERNAL_LOCK = new InternalLock();
        parserLock = new ReentrantLock(true);
        lockCount = 0;
        warnedAboutRunInEQ = new HashSet<StackTraceElement>();
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        Pattern pattern = null;
        try {
            object = System.getProperty("org.netbeans.modules.parsing.impl.Source.excludedTasks");
            if (object != null) {
                pattern = Pattern.compile((String)object);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Exceptions.printStackTrace((Throwable)patternSyntaxException);
        }
        excludedTasks = pattern;
        object = null;
        try {
            String string = System.getProperty("org.netbeans.modules.parsing.impl.Source.includedTasks");
            if (string != null) {
                object = Pattern.compile(string);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Exceptions.printStackTrace((Throwable)patternSyntaxException);
        }
        includedTasks = object;
        rst = new AtomicReference();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeferredTask {
        final Collection<Source> sources;
        final Mutex.ExceptionAction<Void> task;
        final ScanSync sync;

        public DeferredTask(Collection<Source> collection, Mutex.ExceptionAction<Void> exceptionAction, ScanSync scanSync) {
            assert (collection != null);
            assert (exceptionAction != null);
            assert (scanSync != null);
            this.sources = collection;
            this.task = exceptionAction;
            this.sync = scanSync;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ScanSync
    implements Future<Void> {
        private Mutex.ExceptionAction<Void> task;
        private final CountDownLatch sync;
        private final AtomicBoolean canceled;

        public ScanSync(Mutex.ExceptionAction<Void> exceptionAction) {
            assert (exceptionAction != null);
            this.task = exceptionAction;
            this.sync = new CountDownLatch(1);
            this.canceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean bl) {
            if (this.sync.getCount() == 0L) {
                return false;
            }
            List list = todo;
            synchronized (list) {
                boolean bl2 = this.canceled.getAndSet(true);
                if (!bl2) {
                    Iterator iterator = todo.iterator();
                    while (iterator.hasNext()) {
                        DeferredTask deferredTask = (DeferredTask)iterator.next();
                        if (deferredTask.task != this.task) continue;
                        iterator.remove();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled.get();
        }

        @Override
        public synchronized boolean isDone() {
            return this.sync.getCount() == 0L;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.sync.await();
            return null;
        }

        @Override
        public Void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            this.sync.await(l, timeUnit);
            return null;
        }

        private void taskFinished() {
            this.sync.countDown();
        }

        static /* synthetic */ void access$500(ScanSync scanSync) {
            scanSync.taskFinished();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private Parser activeParser;
        private long cancelTime;
        private boolean canceled;
        private static final Object CRR_LOCK = new CRRLock();

        private CurrentRequestReference() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setCurrentTask(Request request) throws InterruptedException {
            boolean bl = false;
            assert (!parserLock.isHeldByCurrentThread());
            assert (request == null || request.cache == null || !Thread.holdsLock(INTERNAL_LOCK));
            Object object = CRR_LOCK;
            synchronized (object) {
                while (this.canceledReference != null) {
                    CRR_LOCK.wait();
                }
                bl = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.activeParser = null;
                this.reference = request;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearCurrentTask() {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.reference = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCurrentParser(Parser parser) {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.activeParser = parser;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(int n) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null && n < this.reference.task.getPriority()) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(Collection<? extends SchedulerTask> collection) {
            assert (collection != null);
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null && collection.contains(this.reference.task)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(boolean bl) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Parser parser;
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    } else if (this.canceledReference == null) {
                        this.canceledReference = request = Request.DUMMY;
                        this.cancelTime = System.currentTimeMillis();
                    }
                    parser = this.activeParser;
                }
                if (parser != null && bl) {
                    parser.cancel();
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getTaskToCancel(Request[] requestArray) {
            assert (requestArray != null);
            assert (requestArray.length == 1);
            boolean bl = false;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    requestArray[0] = this.reference;
                    if (requestArray[0] != null) {
                        boolean bl2 = bl = requestArray[0].cache == null;
                        assert (this.canceledReference == null);
                        if (!bl) {
                            this.canceledReference = requestArray[0];
                            this.reference = null;
                        }
                        this.canceled = bl;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCanceled() {
            Object object = CRR_LOCK;
            synchronized (object) {
                return this.canceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getCancelTime() {
            Object object = CRR_LOCK;
            synchronized (object) {
                return this.cancelTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelCompleted(Request request) {
            if (request != null) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    CRR_LOCK.notify();
                }
            }
        }

        private static class CRRLock {
            private CRRLock() {
            }
        }
    }

    static class WorkerThreadFactory
    implements ThreadFactory {
        private Thread t;

        WorkerThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            assert (this.t == null);
            this.t = new Thread(runnable, "Parsing & Indexing Loop (" + System.getProperty("netbeans.buildnumber") + ")");
            return this.t;
        }

        public boolean isDispatchThread(Thread thread) {
            assert (thread != null);
            return this.t == thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestPriorityComparator
    implements Comparator<Request> {
        private RequestPriorityComparator() {
        }

        @Override
        public int compare(Request request, Request request2) {
            assert (request != null && request2 != null);
            return request.task.getPriority() - request2.task.getPriority();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request {
        static final Request DUMMY = new Request();
        static final Request NONE = new Request();
        private final SchedulerTask task;
        private final SourceCache cache;
        private final boolean reschedule;
        private final boolean bridge;
        private Class<? extends Scheduler> schedulerType;

        public Request(SchedulerTask schedulerTask, SourceCache sourceCache, boolean bl, boolean bl2, Class<? extends Scheduler> clazz) {
            assert (schedulerTask != null);
            this.task = schedulerTask;
            this.cache = sourceCache;
            this.reschedule = bl;
            this.bridge = bl2;
            this.schedulerType = clazz;
        }

        private Request() {
            this(new ParserResultTask(){

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public Class<? extends Scheduler> getSchedulerClass() {
                    return null;
                }

                @Override
                public void cancel() {
                }

                public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
                }
            }, null, false, false, null);
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request to perform: %s on: %s", this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
            }
            return String.format("One time request to perform: %s on: %s", this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
        }

        public int hashCode() {
            return this.task == null ? 0 : this.task.getPriority();
        }

        public boolean equals(Object object) {
            if (object instanceof Request) {
                Request request = (Request)object;
                return this.reschedule == request.reschedule && (this.cache == null ? request.cache == null : this.cache.equals(request.cache)) && (this.task == null ? request.task == null : this.task.equals(request.task));
            }
            return false;
        }

        static /* synthetic */ Class access$600(Request request) {
            return request.schedulerType;
        }

        static /* synthetic */ boolean access$1700(Request request) {
            return request.reschedule;
        }

        static /* synthetic */ boolean access$1800(Request request) {
            return request.bridge;
        }
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class InternalLock {
        private InternalLock() {
        }
    }
}

