/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryPathNotifier {
    private static final BinaryPathNotifier instance = new BinaryPathNotifier();
    private static final Logger LOG = Logger.getLogger(BinaryPathNotifier.class.getName());
    private final List<FileChangeListener> listeners = new CopyOnWriteArrayList<FileChangeListener>();
    private final Set<File> interestedIn = new HashSet<File>();
    private final FileChangeListener listener = new FL();

    private BinaryPathNotifier() {
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        Parameters.notNull((CharSequence)"listener", (Object)fileChangeListener);
        this.listeners.add(fileChangeListener);
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        Parameters.notNull((CharSequence)"listener", (Object)fileChangeListener);
        this.listeners.remove(fileChangeListener);
    }

    public void registerRoots(Iterable<? extends URL> iterable) {
        Parameters.notNull((CharSequence)"roots", iterable);
        for (URL uRL : iterable) {
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            try {
                File file;
                if (uRL2 == null || !this.interestedIn.add(file = new File(uRL2.toURI()))) continue;
                FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)file);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.warning("Cannot register root: " + uRL);
            }
        }
    }

    public void unregisterRoots(Iterable<? extends URL> iterable) {
        Parameters.notNull((CharSequence)"roots", iterable);
        for (URL uRL : iterable) {
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            try {
                File file;
                if (uRL2 == null || !this.interestedIn.remove(file = new File(uRL2.toURI()))) continue;
                FileUtil.removeFileChangeListener((FileChangeListener)this.listener, (File)file);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.warning("Cannot unregister root: " + uRL);
            }
        }
    }

    public static BinaryPathNotifier getDefault() {
        return instance;
    }

    private class FL
    extends FileChangeAdapter {
        private FL() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            for (FileChangeListener fileChangeListener : BinaryPathNotifier.this.listeners) {
                fileChangeListener.fileDataCreated(fileEvent);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            for (FileChangeListener fileChangeListener : BinaryPathNotifier.this.listeners) {
                fileChangeListener.fileChanged(fileEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            for (FileChangeListener fileChangeListener : BinaryPathNotifier.this.listeners) {
                fileChangeListener.fileDeleted(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            for (FileChangeListener fileChangeListener : BinaryPathNotifier.this.listeners) {
                fileChangeListener.fileRenamed(fileRenameEvent);
            }
        }
    }
}

