/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.db.sql.editor.SQLTokenContext;

public class SQLSyntax
extends Syntax {
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_QUOTE = 7;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_OPERATOR = 12;
    private static final int ISA_MINUS = 13;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT_END = 21;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_DOUBLE = 30;
    private static final int ISA_DOT = 33;
    private static final int ISA_COMMA = 34;
    private static final int ISA_SEMICOLON = 35;
    private static final int ISA_LPAREN = 36;
    private static final int ISA_RPAREN = 37;
    private static final int ISA_BACK_SLASH_IN_STRING = 38;
    private static final int ISA_HASH = 39;
    private int startQuoteChar = -1;
    private static final String MEDIUMINT = "MEDIUMINT";

    public SQLSyntax() {
        this.tokenContextPath = SQLTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            int n = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (n) {
                        case 39: {
                            this.state = 6;
                            break block0;
                        }
                        case 47: {
                            this.state = 11;
                            break block0;
                        }
                        case 35: {
                            this.state = 39;
                            break block0;
                        }
                        case 33: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.OPERATOR;
                        }
                        case 45: {
                            this.state = 13;
                            break block0;
                        }
                        case 48: {
                            this.state = 27;
                            break block0;
                        }
                        case 46: {
                            this.state = 33;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit((char)n)) {
                        this.state = 28;
                        break;
                    }
                    this.state = 10;
                    if (!SQLSyntax.isStartQuoteChar(n)) break;
                    this.startQuoteChar = n;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)n)) break;
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 4: {
                    if (n != 10) break;
                    this.state = -1;
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 5: {
                    if (n != 42) break;
                    this.state = 21;
                    break;
                }
                case 6: {
                    switch (n) {
                        case 92: {
                            this.state = 38;
                            break block0;
                        }
                        case 39: {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.STRING;
                        }
                    }
                    break;
                }
                case 38: {
                    this.state = 6;
                    break;
                }
                case 10: {
                    if (this.startQuoteChar != -1) {
                        if (!SQLSyntax.isEndQuoteChar(this.startQuoteChar, n)) break;
                        ++this.offset;
                    } else if (Character.isLetterOrDigit((char)n) || n == 95) break;
                    this.state = -1;
                    this.startQuoteChar = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID != null) {
                        return tokenID;
                    }
                    return SQLTokenContext.IDENTIFIER;
                }
                case 11: {
                    switch (n) {
                        case 42: {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
                case 13: {
                    switch (n) {
                        case 45: {
                            this.state = 4;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
                case 39: {
                    if (Character.isWhitespace((char)n)) {
                        this.state = 4;
                        break;
                    }
                    this.state = 10;
                    break;
                }
                case 21: {
                    switch (n) {
                        case 47: {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 27: {
                    switch (n) {
                        case 46: {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit((char)n)) {
                        this.state = 28;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (n) {
                        case 46: {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit((char)n)) {
                        this.state = 28;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 30: {
                    if (n >= 48 && n <= 57) {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 33: {
                    if (Character.isDigit((char)n)) {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    this.startQuoteChar = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID != null) {
                        return tokenID;
                    }
                    return SQLTokenContext.IDENTIFIER;
                }
                case 4: {
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return SQLTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 38: {
                    return SQLTokenContext.INCOMPLETE_STRING;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 30: {
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 33: {
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return SQLTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int n) {
        switch (n) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_QUOTE";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 12: {
                return "ISA_OPERATOR";
            }
            case 13: {
                return "ISA_MINUS";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT_END";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 33: {
                return "ISA_DOT";
            }
            case 34: {
                return "ISA_COMMA";
            }
        }
        return super.getStateName(n);
    }

    public void loadInitState() {
        this.startQuoteChar = -1;
        super.loadInitState();
    }

    public Syntax.StateInfo createStateInfo() {
        return new SQLStateInfo();
    }

    public void loadState(Syntax.StateInfo stateInfo) {
        this.startQuoteChar = ((SQLStateInfo)stateInfo).getStartQuoteChar();
        super.loadState(stateInfo);
    }

    public void storeState(Syntax.StateInfo stateInfo) {
        ((SQLStateInfo)stateInfo).setStartQuoteChar(this.startQuoteChar);
        super.storeState(stateInfo);
    }

    public int compareState(Syntax.StateInfo stateInfo) {
        if (stateInfo != null && ((SQLStateInfo)stateInfo).getStartQuoteChar() == this.startQuoteChar) {
            return super.compareState(stateInfo);
        }
        return 1;
    }

    private static boolean isStartQuoteChar(int n) {
        return n == 34 || n == 96 || n == 91;
    }

    private static boolean isEndQuoteChar(int n, int n2) {
        return n == 34 && n2 == n || n == 96 && n2 == n || n == 91 && n2 == 93;
    }

    public TokenID matchKeyword(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (SQLKeywords.isSQL99Keyword((String)string) || MEDIUMINT.equalsIgnoreCase(string)) {
            return SQLTokenContext.KEYWORD;
        }
        return null;
    }

    private static final class SQLStateInfo
    extends Syntax.BaseStateInfo {
        private int startQuoteChar;

        private SQLStateInfo() {
        }

        public int getStartQuoteChar() {
            return this.startQuoteChar;
        }

        public void setStartQuoteChar(int n) {
            this.startQuoteChar = n;
        }
    }
}

