/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ConnectionAction
extends SQLExecutionBaseAction {
    protected String getDisplayName(SQLExecution sQLExecution) {
        return NbBundle.getMessage(ConnectionAction.class, (String)"LBL_DatabaseConnection");
    }

    protected void actionPerformed(SQLExecution sQLExecution) {
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ConnectionContextAwareDelegate(this, lookup);
    }

    private static final class DatabaseConnectionRenderer
    extends DefaultListCellRenderer {
        private DatabaseConnectionRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3 = null;
            String string = null;
            if (object instanceof DatabaseConnection) {
                object2 = (DatabaseConnection)object;
                string = object2.getDisplayName();
                object3 = string;
            } else {
                object3 = object;
            }
            object2 = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object3, n, bl, bl2);
            ((JComponent)object2).setToolTipText(string);
            return object2;
        }
    }

    private static final class DatabaseConnectionModel
    extends AbstractListModel
    implements ComboBoxModel,
    ConnectionListener,
    PropertyChangeListener {
        private ConnectionListener listener = (ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, (Object)ConnectionManager.getDefault());
        private List<DatabaseConnection> connectionList;
        private SQLExecution sqlExecution;

        public DatabaseConnectionModel() {
            ConnectionManager.getDefault().addConnectionListener(this.listener);
            this.connectionList = new ArrayList<DatabaseConnection>();
            this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
        }

        public Object getElementAt(int n) {
            return this.connectionList.get(n);
        }

        public int getSize() {
            return this.connectionList.size();
        }

        public void setSelectedItem(Object object) {
            if (this.sqlExecution != null) {
                this.sqlExecution.setDatabaseConnection((DatabaseConnection)object);
            }
        }

        public Object getSelectedItem() {
            return this.sqlExecution != null ? this.sqlExecution.getDatabaseConnection() : null;
        }

        public void setSQLExecution(SQLExecution sQLExecution) {
            if (this.sqlExecution != null) {
                this.sqlExecution.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.sqlExecution = sQLExecution;
            if (this.sqlExecution != null) {
                this.sqlExecution.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.fireContentsChanged(this, 0, 0);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("databaseConnection")) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        DatabaseConnectionModel.this.fireContentsChanged(this, 0, 0);
                    }
                });
            }
        }

        public void connectionsChanged() {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    DatabaseConnectionModel.this.connectionList.clear();
                    DatabaseConnectionModel.this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
                    DatabaseConnection databaseConnection = (DatabaseConnection)DatabaseConnectionModel.this.getSelectedItem();
                    if (databaseConnection != null && !DatabaseConnectionModel.this.connectionList.contains(databaseConnection)) {
                        DatabaseConnectionModel.this.setSelectedItem(null);
                    }
                    DatabaseConnectionModel.this.fireContentsChanged(this, 0, DatabaseConnectionModel.this.connectionList.size());
                }
            });
        }
    }

    private static final class ToolbarPresenter
    extends JPanel {
        private final Lookup actionContext;
        private JComboBox combo;
        private JLabel comboLabel;
        private DatabaseConnectionModel model;

        public ToolbarPresenter(Lookup lookup) {
            this.initComponents();
            this.actionContext = lookup;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            int n = this.comboLabel.getWidth() * 2;
            return new Dimension(n, dimension.height);
        }

        public void setSQLExecution(SQLExecution sQLExecution) {
            this.model.setSQLExecution(sQLExecution);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(4, 0));
            this.setBorder(new EmptyBorder(0, 2, 0, 8));
            this.setOpaque(false);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

                public Component getDefaultComponent(Container container) {
                    JEditorPane[] jEditorPaneArray;
                    EditorCookie editorCookie = (EditorCookie)ToolbarPresenter.this.actionContext.lookup(EditorCookie.class);
                    if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
                        for (JEditorPane jEditorPane : jEditorPaneArray) {
                            if (!jEditorPane.isShowing()) continue;
                            return jEditorPane;
                        }
                    }
                    return null;
                }
            });
            this.combo = new JComboBox();
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    DatabaseConnection databaseConnection = (DatabaseConnection)ToolbarPresenter.this.combo.getSelectedItem();
                    ToolbarPresenter.this.combo.setToolTipText(databaseConnection != null ? databaseConnection.getDisplayName() : null);
                }
            });
            this.combo.setOpaque(false);
            this.model = new DatabaseConnectionModel();
            this.combo.setModel(this.model);
            this.combo.setRenderer(new DatabaseConnectionRenderer());
            String string = NbBundle.getMessage(ConnectionAction.class, (String)"LBL_DatabaseConnection");
            this.combo.getAccessibleContext().setAccessibleName(string);
            this.combo.getAccessibleContext().setAccessibleDescription(string);
            this.combo.setPreferredSize(new Dimension(Math.min(this.combo.getPreferredSize().width, 400), this.combo.getPreferredSize().height));
            this.add((Component)this.combo, "Center");
            this.comboLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.comboLabel, (String)NbBundle.getMessage(ConnectionAction.class, (String)"LBL_ConnectionAction"));
            this.comboLabel.setOpaque(false);
            this.comboLabel.setLabelFor(this.combo);
            this.add((Component)this.comboLabel, "West");
        }

        public void setEnabled(boolean bl) {
            this.combo.setEnabled(bl);
            super.setEnabled(bl);
        }
    }

    private static final class ConnectionContextAwareDelegate
    extends SQLExecutionBaseAction.ContextAwareDelegate {
        private final Lookup actionContext;
        private ToolbarPresenter toolbarPresenter;

        public ConnectionContextAwareDelegate(ConnectionAction connectionAction, Lookup lookup) {
            super(connectionAction, lookup);
            this.actionContext = lookup;
        }

        public Component getToolbarPresenter() {
            this.toolbarPresenter = new ToolbarPresenter(this.actionContext);
            this.toolbarPresenter.setSQLExecution(this.getSQLExecution());
            return this.toolbarPresenter;
        }

        public void setEnabled(boolean bl) {
            if (this.toolbarPresenter != null) {
                this.toolbarPresenter.setEnabled(bl);
            }
            super.setEnabled(bl);
        }

        protected void setSQLExecution(final SQLExecution sQLExecution) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ConnectionContextAwareDelegate.this.toolbarPresenter != null) {
                        ConnectionContextAwareDelegate.this.toolbarPresenter.setSQLExecution(sQLExecution);
                    }
                }
            });
            super.setSQLExecution(sQLExecution);
        }
    }
}

