/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLLexer
implements Lexer<SQLTokenId> {
    private final LexerRestartInfo<SQLTokenId> info;
    private final LexerInput input;
    private final TokenFactory<SQLTokenId> factory;
    private State state = State.INIT;
    private int startQuoteChar = -1;
    private static final String MEDIUMINT = "MEDIUMINT";

    public SQLLexer(LexerRestartInfo<SQLTokenId> lexerRestartInfo) {
        this.info = lexerRestartInfo;
        this.input = lexerRestartInfo.input();
        this.factory = lexerRestartInfo.tokenFactory();
    }

    public Token<SQLTokenId> nextToken() {
        int n;
        while ((n = this.input.read()) != -1) {
            block0 : switch (this.state) {
                case INIT: {
                    switch (n) {
                        case 39: {
                            this.state = State.ISI_STRING;
                            break block0;
                        }
                        case 47: {
                            this.state = State.ISA_SLASH;
                            break block0;
                        }
                        case 35: {
                            this.state = State.ISA_HASH;
                            break block0;
                        }
                        case 33: 
                        case 42: 
                        case 43: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                        }
                        case 40: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.LPAREN);
                        }
                        case 41: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.RPAREN);
                        }
                        case 44: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.COMMA);
                        }
                        case 45: {
                            this.state = State.ISA_MINUS;
                            break block0;
                        }
                        case 48: {
                            this.state = State.ISA_ZERO;
                            break block0;
                        }
                        case 46: {
                            this.state = State.ISA_DOT;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        this.state = State.ISI_WHITESPACE;
                        break;
                    }
                    if (Character.isDigit(n)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    if (SQLLexer.isStartQuoteChar(n)) {
                        this.startQuoteChar = n;
                    }
                    this.state = State.ISI_IDENTIFIER;
                    break;
                }
                case ISI_WHITESPACE: {
                    if (Character.isWhitespace(n)) break;
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.WHITESPACE);
                }
                case ISI_LINE_COMMENT: {
                    if (n != 10) break;
                    this.state = State.INIT;
                    return this.factory.createToken((TokenId)SQLTokenId.LINE_COMMENT);
                }
                case ISI_BLOCK_COMMENT: {
                    if (n != 42) break;
                    this.state = State.ISA_STAR_IN_BLOCK_COMMENT;
                    break;
                }
                case ISI_STRING: {
                    switch (n) {
                        case 92: {
                            this.state = State.ISA_BACK_SLASH_IN_STRING;
                            break block0;
                        }
                        case 39: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.STRING);
                        }
                    }
                    break;
                }
                case ISA_BACK_SLASH_IN_STRING: {
                    this.state = State.ISI_STRING;
                    break;
                }
                case ISI_IDENTIFIER: {
                    if (this.startQuoteChar != -1) {
                        if (!SQLLexer.isEndQuoteChar(this.startQuoteChar, n)) {
                            break;
                        }
                    } else {
                        if (Character.isLetterOrDigit(n) || n == 95) break;
                        this.input.backup(1);
                    }
                    this.state = State.INIT;
                    this.startQuoteChar = -1;
                    return this.factory.createToken((TokenId)SQLLexer.testKeyword(this.input.readText()));
                }
                case ISA_SLASH: {
                    switch (n) {
                        case 42: {
                            this.state = State.ISI_BLOCK_COMMENT;
                            break block0;
                        }
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case ISA_MINUS: {
                    switch (n) {
                        case 45: {
                            this.state = State.ISI_LINE_COMMENT;
                            break block0;
                        }
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.OPERATOR);
                }
                case ISA_HASH: {
                    if (Character.isWhitespace(n)) {
                        this.state = State.ISI_LINE_COMMENT;
                        break;
                    }
                    this.state = State.ISI_IDENTIFIER;
                    break;
                }
                case ISA_STAR_IN_BLOCK_COMMENT: {
                    switch (n) {
                        case 47: {
                            this.state = State.INIT;
                            return this.factory.createToken((TokenId)SQLTokenId.BLOCK_COMMENT);
                        }
                    }
                    this.state = State.ISI_BLOCK_COMMENT;
                    break;
                }
                case ISA_ZERO: {
                    switch (n) {
                        case 46: {
                            this.state = State.ISI_DOUBLE;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case ISI_INT: {
                    switch (n) {
                        case 46: {
                            this.state = State.ISI_DOUBLE;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) {
                        this.state = State.ISI_INT;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.INT_LITERAL);
                }
                case ISI_DOUBLE: {
                    if (n >= 48 && n <= 57) {
                        this.state = State.ISI_DOUBLE;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOUBLE_LITERAL);
                }
                case ISA_DOT: {
                    if (Character.isDigit(n)) {
                        this.state = State.ISI_DOUBLE;
                        break;
                    }
                    this.state = State.INIT;
                    this.input.backup(1);
                    return this.factory.createToken((TokenId)SQLTokenId.DOT);
                }
            }
        }
        SQLTokenId sQLTokenId = null;
        PartType partType = PartType.COMPLETE;
        switch (this.state) {
            case ISI_WHITESPACE: {
                sQLTokenId = SQLTokenId.WHITESPACE;
                break;
            }
            case ISI_IDENTIFIER: {
                this.startQuoteChar = -1;
                sQLTokenId = SQLLexer.testKeyword(this.input.readText());
                break;
            }
            case ISI_LINE_COMMENT: {
                sQLTokenId = SQLTokenId.LINE_COMMENT;
                break;
            }
            case ISI_BLOCK_COMMENT: 
            case ISA_STAR_IN_BLOCK_COMMENT: {
                sQLTokenId = SQLTokenId.BLOCK_COMMENT;
                partType = PartType.START;
                break;
            }
            case ISI_STRING: 
            case ISA_BACK_SLASH_IN_STRING: {
                sQLTokenId = SQLTokenId.INCOMPLETE_STRING;
                partType = PartType.START;
                break;
            }
            case ISA_ZERO: 
            case ISI_INT: {
                sQLTokenId = SQLTokenId.INT_LITERAL;
                break;
            }
            case ISI_DOUBLE: {
                sQLTokenId = SQLTokenId.DOUBLE_LITERAL;
                break;
            }
            case ISA_DOT: {
                sQLTokenId = SQLTokenId.DOT;
                break;
            }
            case ISA_SLASH: {
                sQLTokenId = SQLTokenId.OPERATOR;
                break;
            }
            case ISA_MINUS: {
                sQLTokenId = SQLTokenId.OPERATOR;
            }
        }
        if (sQLTokenId != null) {
            this.state = State.INIT;
            return this.factory.createToken((TokenId)sQLTokenId, this.input.readLength(), partType);
        }
        if (this.state != State.INIT) {
            throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state) + " at end of file");
        }
        return null;
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private static boolean isStartQuoteChar(int n) {
        return n == 34 || n == 96 || n == 91;
    }

    private static boolean isEndQuoteChar(int n, int n2) {
        return n == 34 && n2 == n || n == 96 && n2 == n || n == 91 && n2 == 93;
    }

    private static SQLTokenId testKeyword(CharSequence charSequence) {
        if (SQLKeywords.isSQL99Keyword((String)((Object)charSequence).toString()) || MEDIUMINT.equalsIgnoreCase(((Object)charSequence).toString())) {
            return SQLTokenId.KEYWORD;
        }
        return SQLTokenId.IDENTIFIER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        ISI_WHITESPACE,
        ISI_LINE_COMMENT,
        ISI_BLOCK_COMMENT,
        ISI_STRING,
        ISI_IDENTIFIER,
        ISA_SLASH,
        ISA_HASH,
        ISA_MINUS,
        ISA_STAR_IN_BLOCK_COMMENT,
        ISA_ZERO,
        ISI_INT,
        ISI_DOUBLE,
        ISA_DOT,
        ISA_BACK_SLASH_IN_STRING;

    }
}

