/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

final class ServerResolver {
    private static final Logger LOGGER = Logger.getLogger(ServerResolver.class.getName());
    private static final Pattern SERVER_ARGUMENT = Pattern.compile("[^#+\\s*]\\s*[^\\S+]ARGV.*\\[0\\]\\s*=\\s*\"(\\S+)\\s*\"");

    ServerResolver() {
    }

    public static RubyInstance getExplicitlySpecifiedServer(RailsProject railsProject) {
        FileObject fileObject = railsProject.getProjectDirectory().getFileObject("script/server");
        if (fileObject == null) {
            return null;
        }
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return null;
                }
                try {
                    editorCookie.prepareDocument().waitFinished(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StyledDocument styledDocument = editorCookie.getDocument();
                if (styledDocument == null) {
                    return null;
                }
                String string = styledDocument.getText(0, styledDocument.getLength());
                String string2 = ServerResolver.getSpecifiedServer(string);
                if (string2 != null) {
                    RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)railsProject);
                    RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string2.toUpperCase(), rubyPlatform);
                    if (rubyInstance == null) {
                        LOGGER.info("Found explicitly set server [" + string2 + "] in server/script, " + "but the server was not found on project's platform [ " + rubyPlatform + "] or recognized " + "as a known server");
                        return null;
                    }
                    return rubyInstance;
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    static String getSpecifiedServer(String string) {
        Matcher matcher = SERVER_ARGUMENT.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }
}

