/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FoldersListSettings {
    private static final FoldersListSettings INSTANCE = new FoldersListSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String LOGICAL_VIEW = "logicalView";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";

    public static FoldersListSettings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FoldersListSettings.class);
    }

    public String displayName() {
        return NbBundle.getMessage(FoldersListSettings.class, (String)"TXT_RailsProjectFolderList");
    }

    public boolean getLogicalView() {
        return FoldersListSettings.getPreferences().getBoolean(LOGICAL_VIEW, true);
    }

    public void setLogicalView(boolean bl) {
        FoldersListSettings.getPreferences().putBoolean(LOGICAL_VIEW, bl);
    }

    public int getNewProjectCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int n) {
        FoldersListSettings.getPreferences().putInt(NEW_PROJECT_COUNT, n);
    }

    public int getNewApplicationCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_APP_COUNT, 0);
    }

    public void setNewApplicationCount(int n) {
        FoldersListSettings.getPreferences().putInt(NEW_APP_COUNT, n);
    }

    public File getLastUsedArtifactFolder() {
        return new File(FoldersListSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File file) {
        assert (file != null) : "Folder can not be null";
        String string = file.getAbsolutePath();
        FoldersListSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, string);
    }
}

