/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.pojson.JsonUtils;
import org.codeviation.pojson.StoreInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojsonFormater {
    private Factory<StoreInfo, Class> sif;
    private String indent;
    private Writer w;

    public PojsonFormater(Factory<StoreInfo, Class> factory, String string, Writer writer) {
        this.sif = factory;
        this.indent = string;
        this.w = writer;
    }

    void write(Object object, int n) throws IOException {
        PojsonFormater.indent(this.w, this.indent, n);
        this.writeAny(object, n);
    }

    private void writeAny(Object object, int n) throws IOException {
        if (object == null) {
            this.w.write("null");
            return;
        }
        StoreInfo storeInfo = this.sif.create(object.getClass());
        switch (storeInfo.getKind()) {
            case ARRAY: {
                this.writeArray(storeInfo, JsonUtils.getIterator(object), n);
                break;
            }
            case OBJECT: {
                this.writeObject(storeInfo, object, n);
                break;
            }
            case VALUE: {
                this.writeValue(object);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown store kind");
            }
        }
    }

    private void writeObject(StoreInfo storeInfo, Object object, int n) throws IOException {
        if (object == null) {
            this.w.write("null");
            return;
        }
        this.w.write(123);
        if (object instanceof Map) {
            this.writeMap(storeInfo, (Map)object, n);
        } else {
            this.writePojo(storeInfo, object, n);
        }
        PojsonFormater.indent(this.w, this.indent, n);
        this.w.write(125);
    }

    private void writeMap(StoreInfo storeInfo, Map<?, ?> map, int n) throws IOException {
        boolean bl = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (!bl) {
                this.w.write(44);
                if (this.indent != null) {
                    this.w.write(10);
                }
            } else {
                if (this.indent != null) {
                    this.w.write(10);
                }
                bl = false;
            }
            PojsonFormater.key(this.w, entry.getKey().toString(), this.indent, n + 1);
            this.writeAny(obj, n + 1);
        }
        if (!bl && this.indent != null) {
            this.w.write(10);
        }
    }

    private void writePojo(StoreInfo storeInfo, Object object, int n) throws IOException {
        try {
            boolean bl = true;
            for (Field field : storeInfo.getFields()) {
                field.setAccessible(true);
                Object object2 = field.get(object);
                if (object2 == null && storeInfo.isSkipNullValues(field)) continue;
                if (!bl) {
                    this.w.write(44);
                    if (this.indent != null) {
                        this.w.write(10);
                    }
                } else {
                    if (this.indent != null) {
                        this.w.write(10);
                    }
                    bl = false;
                }
                PojsonFormater.key(this.w, storeInfo.getPojsonFieldName(field), this.indent, n + 1);
                this.writeAny(object2, n + 1);
            }
            if (!bl && this.indent != null) {
                this.w.write(10);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
    }

    private void writeValue(Object object) throws IOException {
        this.w.write(JsonUtils.toJsonString(object));
    }

    private <T> void writeArray(StoreInfo storeInfo, Iterator iterator, int n) throws IOException {
        if (iterator == null) {
            this.w.write("null");
            return;
        }
        this.w.write(91);
        boolean bl = true;
        while (iterator.hasNext()) {
            if (this.indent != null) {
                this.w.write(10);
            }
            bl = false;
            PojsonFormater.indent(this.w, this.indent, n + 1);
            this.writeAny(iterator.next(), n + 1);
            if (!iterator.hasNext()) continue;
            this.w.write(44);
        }
        if (!bl && this.indent != null) {
            this.w.write(10);
            PojsonFormater.indent(this.w, this.indent, n);
        }
        this.w.write(93);
    }

    private static void key(Writer writer, String string, String string2, int n) throws IOException {
        PojsonFormater.indent(writer, string2, n);
        writer.write(JsonUtils.quote(string));
        writer.write(58);
        if (string2 != null) {
            writer.write(32);
        }
    }

    private static void indent(Writer writer, String string, int n) throws IOException {
        if (string == null || n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }
}

