/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bracesmatching;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.bracesmatching.SpiAccessor;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterMatcher {
    private static final Logger LOG = Logger.getLogger(MasterMatcher.class.getName());
    public static final String PROP_SEARCH_DIRECTION = "nbeditor-bracesMatching-searchDirection";
    public static final String D_BACKWARD = "backward-preferred";
    public static final String D_FORWARD = "forward-preferred";
    public static final String PROP_CARET_BIAS = "nbeditor-bracesMatching-caretBias";
    public static final String B_BACKWARD = "backward";
    public static final String B_FORWARD = "forward";
    public static final String PROP_MAX_BACKWARD_LOOKAHEAD = "nbeditor-bracesMatching-maxBackwardLookahead";
    public static final String PROP_MAX_FORWARD_LOOKAHEAD = "nbeditor-bracesMatching-maxForwardLookahead";
    private static final int DEFAULT_MAX_LOOKAHEAD = 1;
    private static final int MAX_MAX_LOOKAHEAD = 256;
    public static final String PROP_SHOW_SEARCH_PARAMETERS = "debug-showSearchParameters-dont-ever-use-it-or-you-will-die";
    private static final AttributeSet CARET_BIAS_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, Color.BLACK});
    private static final AttributeSet MAX_LOOKAHEAD_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, Color.BLUE});
    private static final RequestProcessor PR = new RequestProcessor("EditorBracesMatching", 5, true);
    static final Map<Thread, Result> THREAD_RESULTS = Collections.synchronizedMap(new HashMap());
    private final String LOCK = new String("MasterMatcher.LOCK");
    private final JTextComponent component;
    private RequestProcessor.Task task = null;
    private Result lastResult = null;

    public static synchronized MasterMatcher get(JTextComponent jTextComponent) {
        MasterMatcher masterMatcher = (MasterMatcher)jTextComponent.getClientProperty(MasterMatcher.class);
        if (masterMatcher == null) {
            masterMatcher = new MasterMatcher(jTextComponent);
            jTextComponent.putClientProperty(MasterMatcher.class, masterMatcher);
        }
        return masterMatcher;
    }

    public static boolean isTaskCanceled() {
        Result result = THREAD_RESULTS.get(Thread.currentThread());
        assert (result != null) : "MatcherContext.isTaskCanceled() should only be called from the matcher task's thread";
        return result.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(Document document, int n, OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2, AttributeSet attributeSet3, AttributeSet attributeSet4) {
        assert (document != null) : "The document parameter must not be null";
        assert (offsetsBag != null) : "The highlights parameter must not be null";
        assert (attributeSet != null) : "The matchedColoring parameter must not be null";
        assert (attributeSet2 != null) : "The mismatchedColoring parameter must not be null";
        assert (attributeSet3 != null) : "The matchedMulticharColoring parameter must not be null";
        assert (attributeSet4 != null) : "The mismatchedMulticharColoring parameter must not be null";
        assert (n >= 0) : "The caretOffset parameter must be >= 0";
        String string = this.LOCK;
        synchronized (string) {
            Object object = this.getAllowedDirection();
            Object object2 = this.getCaretBias();
            int n2 = this.getMaxLookahead(true);
            int n3 = this.getMaxLookahead(false);
            if (this.task != null) {
                if (this.lastResult.getCaretOffset() == n && this.lastResult.getAllowedDirection() == object && this.lastResult.getCaretBias() == object2 && this.lastResult.getMaxBwdLookahead() == n2 && this.lastResult.getMaxFwdLookahead() == n2) {
                    this.lastResult.addHighlightingJob(offsetsBag, attributeSet, attributeSet2, attributeSet3, attributeSet4);
                } else {
                    this.lastResult.cancel();
                    this.task = null;
                }
            }
            if (this.task == null) {
                this.lastResult = new Result(document, n, object, object2, n2, n3);
                this.lastResult.addHighlightingJob(offsetsBag, attributeSet, attributeSet2, attributeSet3, attributeSet4);
                this.task = PR.post((Runnable)this.lastResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(Document document, int n, Caret caret, boolean bl) {
        assert (document != null) : "The document parameter must not be null";
        assert (caret != null) : "The caret parameter must not be null";
        assert (n >= 0) : "The caretOffset parameter must be >= 0";
        RequestProcessor.Task task = null;
        String string = this.LOCK;
        synchronized (string) {
            Object object = this.getAllowedDirection();
            Object object2 = this.getCaretBias();
            int n2 = this.getMaxLookahead(true);
            int n3 = this.getMaxLookahead(false);
            boolean bl2 = DocumentUtilities.isReadLocked((Document)document);
            if (this.task != null) {
                if (!bl2 && this.lastResult.getCaretOffset() == n && this.lastResult.getAllowedDirection() == object && this.lastResult.getCaretBias() == object2 && this.lastResult.getMaxBwdLookahead() == n2 && this.lastResult.getMaxFwdLookahead() == n2) {
                    this.lastResult.addNavigationJob(caret, bl);
                    task = this.task;
                } else {
                    this.lastResult.cancel();
                    this.task = null;
                }
            }
            if (this.task == null) {
                this.lastResult = new Result(document, n, object, object2, n2, n3);
                this.lastResult.addNavigationJob(caret, bl);
                if (bl2) {
                    this.lastResult.run();
                } else {
                    task = this.task = PR.post((Runnable)this.lastResult);
                }
            }
        }
        if (task != null) {
            task.waitFinished();
        }
    }

    private MasterMatcher(JTextComponent jTextComponent) {
        this.component = jTextComponent;
    }

    private Object getAllowedDirection() {
        Object object = this.component.getClientProperty(PROP_SEARCH_DIRECTION);
        return object != null ? object : D_BACKWARD;
    }

    private Object getCaretBias() {
        Object object = this.component.getClientProperty(PROP_CARET_BIAS);
        return object != null ? object : B_BACKWARD;
    }

    private int getMaxLookahead(boolean bl) {
        String string = bl ? PROP_MAX_BACKWARD_LOOKAHEAD : PROP_MAX_FORWARD_LOOKAHEAD;
        int n = 1;
        Object object = this.component.getClientProperty(string);
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object != null) {
            try {
                n = Integer.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, "Can't parse the value of " + string + ": '" + object + "'", numberFormatException);
            }
        }
        if (n >= 0 && n <= 256) {
            return n;
        }
        LOG.warning("Invalid value of " + string + ": " + n);
        return 256;
    }

    private static void highlightAreas(int[] nArray, int[] nArray2, OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2) {
        offsetsBag.clear();
        if (nArray2 != null && nArray2.length >= 2) {
            MasterMatcher.placeHighlights(nArray, true, offsetsBag, attributeSet);
            MasterMatcher.placeHighlights(nArray2, false, offsetsBag, attributeSet);
        } else if (nArray != null && nArray.length >= 2) {
            MasterMatcher.placeHighlights(nArray, true, offsetsBag, attributeSet2);
        }
    }

    private static void placeHighlights(int[] nArray, boolean bl, OffsetsBag offsetsBag, AttributeSet attributeSet) {
        int n = bl && nArray.length > 2 ? 1 : 0;
        for (int i = n; i < nArray.length / 2; ++i) {
            try {
                offsetsBag.addHighlight(nArray[i * 2], nArray[i * 2 + 1], attributeSet);
                continue;
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, null, throwable);
            }
        }
    }

    private static boolean isMultiChar(int[] nArray, boolean bl) {
        if (nArray != null) {
            int n = bl && nArray.length > 2 ? 1 : 0;
            for (int i = n; i < nArray.length / 2; ++i) {
                if (nArray[i * 2 + 1] - nArray[i * 2] <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static void navigateAreas(int[] nArray, int[] nArray2, int n, Object object, Caret caret, boolean bl) {
        if (nArray2 != null && nArray2.length >= 2) {
            int n2;
            int n3 = -1;
            int n4 = -1;
            for (n2 = 0; n2 < nArray2.length / 2; ++n2) {
                if (nArray2[n2 * 2] <= nArray[0] && (n3 == -1 || nArray2[n2 * 2] > nArray2[n3 * 2])) {
                    n3 = n2;
                }
                if (nArray2[n2 * 2] < nArray[1] || n4 != -1 && nArray2[n2 * 2] >= nArray2[n4 * 2]) continue;
                n4 = n2;
            }
            if (n3 != -1) {
                if (bl) {
                    int n5;
                    if (n < nArray[1]) {
                        n2 = nArray[0];
                        n5 = nArray2[2 * n3 + 1];
                    } else {
                        n2 = nArray[1];
                        n5 = nArray2[2 * n3];
                    }
                    if (caret.getDot() == caret.getMark()) {
                        caret.setDot(n2);
                    }
                    caret.moveDot(n5);
                } else if (B_BACKWARD.equalsIgnoreCase(object.toString())) {
                    caret.setDot(nArray2[2 * n3 + 1]);
                } else {
                    caret.setDot(nArray2[2 * n3]);
                }
            } else if (n4 != -1) {
                if (bl) {
                    int n6;
                    if (n > nArray[0]) {
                        n2 = nArray[1];
                        n6 = nArray2[2 * n4];
                    } else {
                        n2 = nArray[0];
                        n6 = nArray2[2 * n4 + 1];
                    }
                    if (caret.getDot() == caret.getMark()) {
                        caret.setDot(n2);
                    }
                    caret.moveDot(n6);
                } else if (B_BACKWARD.equalsIgnoreCase(object.toString())) {
                    caret.setDot(nArray2[2 * n4 + 1]);
                } else {
                    caret.setDot(nArray2[2 * n4]);
                }
            }
        }
    }

    private static Collection<? extends BracesMatcherFactory> findFactories(final Document document, final int n, final boolean bl) {
        final MimePath[] mimePathArray = new MimePath[]{null};
        document.render(new Runnable(){

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                if (tokenHierarchy.isActive()) {
                    List list = tokenHierarchy.embeddedTokenSequences(n, bl);
                    if (!list.isEmpty()) {
                        String string = ((TokenSequence)list.get(list.size() - 1)).languagePath().mimePath();
                        mimePathArray[0] = MimePath.parse((String)string);
                    }
                } else {
                    String string = (String)document.getProperty("mimeType");
                    mimePathArray[0] = string != null ? MimePath.parse((String)string) : MimePath.EMPTY;
                }
            }
        });
        List list = mimePathArray[0] == null ? Collections.emptyList() : MimeLookup.getLookup((MimePath)mimePathArray[0]).lookupAll(BracesMatcherFactory.class);
        return list;
    }

    private final class Result
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private final Object allowedDirection;
        private final Object caretBias;
        private final int maxBwdLookahead;
        private final int maxFwdLookahead;
        private volatile boolean canceled = false;
        private final List<Object[]> highlightingJobs = new ArrayList<Object[]>();
        private final List<Object[]> navigationJobs = new ArrayList<Object[]>();

        public Result(Document document, int n, Object object, Object object2, int n2, int n3) {
            this.document = document;
            this.caretOffset = n;
            this.allowedDirection = object;
            this.caretBias = object2;
            this.maxBwdLookahead = n2;
            this.maxFwdLookahead = n3;
        }

        public void addHighlightingJob(OffsetsBag offsetsBag, AttributeSet attributeSet, AttributeSet attributeSet2, AttributeSet attributeSet3, AttributeSet attributeSet4) {
            this.highlightingJobs.add(new Object[]{offsetsBag, attributeSet, attributeSet2, attributeSet3, attributeSet4});
        }

        public void addNavigationJob(Caret caret, boolean bl) {
            this.navigationJobs.add(new Object[]{caret, bl});
        }

        public int getCaretOffset() {
            return this.caretOffset;
        }

        public Object getAllowedDirection() {
            return this.allowedDirection;
        }

        public Object getCaretBias() {
            return this.caretBias;
        }

        public int getMaxBwdLookahead() {
            return this.maxBwdLookahead;
        }

        public int getMaxFwdLookahead() {
            return this.maxFwdLookahead;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            THREAD_RESULTS.put(Thread.currentThread(), this);
            try {
                this._run();
            }
            finally {
                THREAD_RESULTS.remove(Thread.currentThread());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _run() {
            Object object;
            if (this.canceled) {
                return;
            }
            if (this.caretOffset > this.document.getLength()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Invalid offset, braces matching request ignored. Offset = " + this.caretOffset + ", doc.getLength() = " + this.document.getLength());
                }
                return;
            }
            int[] nArray = null;
            int[] nArray2 = null;
            try {
                object = new BracesMatcher[1];
                if (MasterMatcher.D_BACKWARD.equalsIgnoreCase(this.allowedDirection.toString())) {
                    nArray = this.findOrigin(true, (BracesMatcher[])object);
                    if (nArray == null && !this.canceled) {
                        nArray = this.findOrigin(false, (BracesMatcher[])object);
                    }
                } else if (MasterMatcher.D_FORWARD.equalsIgnoreCase(this.allowedDirection.toString()) && (nArray = this.findOrigin(false, (BracesMatcher[])object)) == null && !this.canceled) {
                    nArray = this.findOrigin(true, (BracesMatcher[])object);
                }
                if (nArray != null && !this.canceled) {
                    nArray2 = object[0].findMatches();
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                    if (!(throwable2 instanceof InterruptedException)) continue;
                    return;
                }
                LOG.log(Level.FINE, null, throwable);
                return;
            }
            object = MasterMatcher.this.LOCK;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                MasterMatcher.this.task = null;
            }
            object = nArray;
            int[] nArray3 = nArray2;
            this.document.render(new Runnable((int[])object, nArray3){
                final /* synthetic */ int[] val$_origin;
                final /* synthetic */ int[] val$_matches;
                {
                    this.val$_origin = nArray;
                    this.val$_matches = nArray2;
                }

                public void run() {
                    try {
                        for (Object[] objectArray : Result.this.highlightingJobs) {
                            AttributeSet attributeSet;
                            AttributeSet attributeSet2;
                            if (MasterMatcher.isMultiChar(this.val$_origin, true) || MasterMatcher.isMultiChar(this.val$_matches, false)) {
                                attributeSet2 = (AttributeSet)objectArray[3];
                                attributeSet = (AttributeSet)objectArray[4];
                            } else {
                                attributeSet2 = (AttributeSet)objectArray[1];
                                attributeSet = (AttributeSet)objectArray[2];
                            }
                            MasterMatcher.highlightAreas(this.val$_origin, this.val$_matches, (OffsetsBag)objectArray[0], attributeSet2, attributeSet);
                            if (!Boolean.valueOf((String)MasterMatcher.this.component.getClientProperty(MasterMatcher.PROP_SHOW_SEARCH_PARAMETERS)).booleanValue()) continue;
                            Result.this.showSearchParameters((OffsetsBag)objectArray[0]);
                        }
                        for (Object[] objectArray : Result.this.navigationJobs) {
                            MasterMatcher.navigateAreas(this.val$_origin, this.val$_matches, Result.this.caretOffset, Result.this.caretBias, (Caret)objectArray[0], (Boolean)objectArray[1]);
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.FINE, null, exception);
                        for (Object[] objectArray : Result.this.highlightingJobs) {
                            ((OffsetsBag)objectArray[0]).clear();
                        }
                    }
                }
            });
        }

        private int[] findOrigin(boolean bl, BracesMatcher[] bracesMatcherArray) throws InterruptedException {
            Object object;
            int n;
            Element element = DocumentUtilities.getParagraphElement((Document)this.document, (int)this.caretOffset);
            int n2 = this.caretOffset;
            int n3 = 0;
            if (bl) {
                n = this.maxBwdLookahead;
                if (MasterMatcher.B_FORWARD.equalsIgnoreCase(this.caretBias.toString())) {
                    if (n2 < element.getEndOffset() - 1) {
                        ++n2;
                        ++n;
                    }
                } else if (n == 0) {
                    n = 1;
                }
                if ((n3 = n2 - element.getStartOffset()) > n) {
                    n3 = n;
                }
            } else {
                n = this.maxFwdLookahead;
                if (MasterMatcher.B_BACKWARD.equalsIgnoreCase(this.caretBias.toString())) {
                    if (n2 > element.getStartOffset()) {
                        --n2;
                        ++n;
                    }
                } else if (n == 0) {
                    n = 1;
                }
                if ((n3 = element.getEndOffset() - 1 - n2) > n) {
                    n3 = n;
                }
            }
            Collection<Object> collection = Collections.emptyList();
            if (n3 > 0) {
                collection = MasterMatcher.findFactories(this.document, n2, bl);
            }
            if (!collection.isEmpty()) {
                object = SpiAccessor.get().createCaretContext(this.document, n2, bl, n3);
                for (BracesMatcherFactory bracesMatcherFactory : collection) {
                    bracesMatcherArray[0] = bracesMatcherFactory.createMatcher((MatcherContext)object);
                    if (bracesMatcherArray[0] == null) continue;
                    break;
                }
            }
            if (bracesMatcherArray[0] != null) {
                object = null;
                try {
                    object = bracesMatcherArray[0].findOrigin();
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.FINE, null, badLocationException);
                }
                if (object != null) {
                    if (((Object)object).length == 0) {
                        object = null;
                    } else if (((Object)object).length % 2 != 0) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Invalid BracesMatcher implementation, findOrigin() should return nothing or offset pairs. Offending BracesMatcher: " + bracesMatcherArray[0]);
                        }
                        object = null;
                    } else {
                        for (int i = 0; i < ((Object)object).length / 2; ++i) {
                            if (object[2 * i] >= 0 && object[2 * i + 1] <= this.document.getLength() && object[2 * i] <= object[2 * i + 1]) continue;
                            if (LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Invalid origin offsets [" + (int)object[2 * i] + ", " + (int)object[2 * i + 1] + "]. " + "Offending BracesMatcher: " + bracesMatcherArray[0]);
                            }
                            object = null;
                            break;
                        }
                    }
                    if (object != null) {
                        if (bl) {
                            if (object[1] < this.caretOffset - n3 || object[0] > this.caretOffset) {
                                if (LOG.isLoggable(Level.WARNING)) {
                                    LOG.warning("Origin offsets out of range, origin = [" + (int)object[0] + ", " + (int)object[1] + "], " + "caretOffset = " + this.caretOffset + ", lookahead = " + n3 + ", searching backwards. " + "Offending BracesMatcher: " + bracesMatcherArray[0]);
                                }
                                object = null;
                            }
                        } else if (object[1] < this.caretOffset || object[0] > this.caretOffset + n3) {
                            if (LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Origin offsets out of range, origin = [" + (int)object[0] + ", " + (int)object[1] + "], " + "caretOffset = " + this.caretOffset + ", lookahead = " + n3 + ", searching forward. " + "Offending BracesMatcher: " + bracesMatcherArray[0]);
                            }
                            object = null;
                        }
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (object != null) {
                        LOG.fine("[" + (int)object[0] + ", " + (int)object[1] + "] for caret = " + this.caretOffset + ", lookahead = " + (bl ? "-" : "") + n3);
                    } else {
                        LOG.fine("[null] for caret = " + this.caretOffset + ", lookahead = " + (bl ? "-" : "") + n3);
                    }
                }
                return object;
            }
            return null;
        }

        private void showSearchParameters(OffsetsBag offsetsBag) {
            Element element = DocumentUtilities.getParagraphElement((Document)this.document, (int)this.caretOffset);
            if (MasterMatcher.B_BACKWARD.equalsIgnoreCase(this.caretBias.toString())) {
                if (this.caretOffset > element.getStartOffset()) {
                    offsetsBag.addHighlight(this.caretOffset - 1, this.caretOffset, CARET_BIAS_HIGHLIGHT);
                }
            } else if (this.caretOffset < element.getEndOffset() - 1) {
                offsetsBag.addHighlight(this.caretOffset, this.caretOffset + 1, CARET_BIAS_HIGHLIGHT);
            }
            int n = Math.min(this.maxBwdLookahead, this.caretOffset - element.getStartOffset());
            int n2 = Math.min(this.maxFwdLookahead, element.getEndOffset() - 1 - this.caretOffset);
            offsetsBag.addHighlight(this.caretOffset - n, this.caretOffset, MAX_LOOKAHEAD_HIGHLIGHT);
            offsetsBag.addHighlight(this.caretOffset, this.caretOffset + n2, MAX_LOOKAHEAD_HIGHLIGHT);
        }
    }
}

