/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.TokenBalance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BraceCompletion {
    private static Set<JavaTokenId> STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET = EnumSet.of(JavaTokenId.LBRACE, JavaTokenId.RBRACE, JavaTokenId.SEMICOLON);

    BraceCompletion() {
    }

    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        TokenSequence<JavaTokenId> tokenSequence;
        if (!BraceCompletion.completionSettingEnabled()) {
            return;
        }
        if ((c == ')' || c == ']' || c == '(' || c == '[' || c == ';') && (tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, false)) != null) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case RPAREN: 
                case RBRACKET: {
                    BraceCompletion.skipClosingBracket(baseDocument, caret, c, tokenSequence);
                    break;
                }
                case LPAREN: 
                case LBRACKET: {
                    BraceCompletion.completeOpeningBracket(baseDocument, n, caret, c, tokenSequence);
                    break;
                }
                case SEMICOLON: {
                    BraceCompletion.moveSemicolon(baseDocument, n, caret, tokenSequence);
                }
            }
        }
    }

    private static void moveSemicolon(BaseDocument baseDocument, int n, Caret caret, TokenSequence<JavaTokenId> tokenSequence) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        int n3 = n;
        int n4 = tokenSequence.index();
        block4: while (tokenSequence.moveNext() && tokenSequence.offset() <= n2) {
            Token token = tokenSequence.token();
            switch ((JavaTokenId)token.id()) {
                case RPAREN: {
                    n3 = tokenSequence.offset();
                    continue block4;
                }
                case WHITESPACE: {
                    continue block4;
                }
            }
            return;
        }
        tokenSequence.moveIndex(n4);
        tokenSequence.moveNext();
        if (BraceCompletion.isForLoopSemicolon(tokenSequence) || BraceCompletion.posWithinAnyQuote(baseDocument, n)) {
            return;
        }
        baseDocument.remove(n, 1);
        baseDocument.insertString(n3, ";", null);
        caret.setDot(n3 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isForLoopSemicolon(TokenSequence<JavaTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        if (token == null || token.id() != JavaTokenId.SEMICOLON) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = tokenSequence.index();
        try {
            while (tokenSequence.movePrevious()) {
                token = tokenSequence.token();
                switch ((JavaTokenId)token.id()) {
                    case LPAREN: {
                        if (n == 0) {
                            block20: while (tokenSequence.movePrevious()) {
                                token = tokenSequence.token();
                                switch ((JavaTokenId)token.id()) {
                                    case WHITESPACE: 
                                    case BLOCK_COMMENT: 
                                    case JAVADOC_COMMENT: 
                                    case LINE_COMMENT: {
                                        continue block20;
                                    }
                                    case FOR: {
                                        boolean bl2 = true;
                                        return bl2;
                                    }
                                }
                                boolean bl3 = false;
                                return bl3;
                            }
                            boolean bl4 = false;
                            return bl4;
                        }
                        --n;
                        break;
                    }
                    case RPAREN: {
                        ++n;
                        break;
                    }
                    case LBRACE: {
                        if (n2 == 0) {
                            boolean bl5 = false;
                            return bl5;
                        }
                        --n2;
                        break;
                    }
                    case RBRACE: {
                        ++n2;
                        break;
                    }
                    case SEMICOLON: {
                        if (bl) {
                            boolean bl6 = false;
                            return bl6;
                        }
                        bl = true;
                    }
                }
            }
        }
        finally {
            tokenSequence.moveIndex(n3);
            tokenSequence.moveNext();
        }
        return false;
    }

    static void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (!BraceCompletion.completionSettingEnabled()) {
            return;
        }
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, false);
        if (tokenSequence == null) {
            return;
        }
        if (c == '(' || c == '[') {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case RPAREN: {
                    if (BraceCompletion.tokenBalance(baseDocument, JavaTokenId.LPAREN) == 0) break;
                    baseDocument.remove(n, 1);
                    break;
                }
                case RBRACKET: {
                    if (BraceCompletion.tokenBalance(baseDocument, JavaTokenId.LBRACKET) == 0) break;
                    baseDocument.remove(n, 1);
                }
            }
        } else if (c == '\"') {
            if (tokenSequence.token().id() == JavaTokenId.STRING_LITERAL && tokenSequence.offset() == n) {
                baseDocument.remove(n, 1);
            }
        } else if (c == '\'' && tokenSequence.token().id() == JavaTokenId.CHAR_LITERAL && tokenSequence.offset() == n) {
            baseDocument.remove(n, 1);
        }
    }

    static int tokenBalance(BaseDocument baseDocument, JavaTokenId javaTokenId) {
        TokenBalance tokenBalance = TokenBalance.get((Document)baseDocument);
        if (!tokenBalance.isTracked(JavaTokenId.language())) {
            tokenBalance.addTokenPair(JavaTokenId.language(), JavaTokenId.LPAREN, JavaTokenId.RPAREN);
            tokenBalance.addTokenPair(JavaTokenId.language(), JavaTokenId.LBRACKET, JavaTokenId.RBRACKET);
            tokenBalance.addTokenPair(JavaTokenId.language(), JavaTokenId.LBRACE, JavaTokenId.RBRACE);
        }
        int n = tokenBalance.balance(JavaTokenId.language(), javaTokenId);
        assert (n != Integer.MAX_VALUE);
        return n;
    }

    static boolean isAddRightBrace(BaseDocument baseDocument, int n) throws BadLocationException {
        if (!BraceCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BraceCompletion.tokenBalance(baseDocument, JavaTokenId.LBRACE) <= 0) {
            return false;
        }
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, true);
        if (tokenSequence == null) {
            return false;
        }
        boolean bl = true;
        do {
            if (tokenSequence.offset() < n2) {
                return false;
            }
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: {
                    break;
                }
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    if (!bl || n <= tokenSequence.offset() || n >= tokenSequence.offset() + tokenSequence.token().length()) break;
                    return false;
                }
                case LBRACE: {
                    return true;
                }
            }
            bl = false;
        } while (tokenSequence.movePrevious());
        return false;
    }

    static int getRowOrBlockEnd(BaseDocument baseDocument, int n, boolean[] blArray) throws BadLocationException {
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1 || n >= n2) {
            return n;
        }
        ++n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, false);
        if (tokenSequence == null) {
            return n;
        }
        while (tokenSequence.offset() < n2) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case SEMICOLON: {
                    return tokenSequence.offset() + 1;
                }
                case LPAREN: {
                    ++n3;
                    break;
                }
                case RPAREN: {
                    if (n3-- == 0) {
                        return tokenSequence.offset();
                    }
                }
                case LBRACE: {
                    ++n4;
                    break;
                }
                case RBRACE: {
                    if (n4-- == 0) {
                        return tokenSequence.offset();
                    }
                }
                case LBRACKET: {
                    ++n5;
                    break;
                }
                case RBRACKET: {
                    if (n5-- != 0) break;
                    return tokenSequence.offset();
                }
            }
            if (tokenSequence.moveNext()) continue;
        }
        blArray[0] = false;
        return n2;
    }

    private static TokenSequence<JavaTokenId> javaTokenSequence(Document document, int n, boolean bl) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, bl);
        for (int i = list.size() - 1; i >= 0; --i) {
            TokenSequence tokenSequence = (TokenSequence)list.get(i);
            if (tokenSequence.languagePath().innerLanguage() != JavaTokenId.language()) continue;
            TokenSequence tokenSequence2 = tokenSequence;
            return tokenSequence2;
        }
        return null;
    }

    private static int braceBalance(BaseDocument baseDocument) throws BadLocationException {
        return BraceCompletion.tokenBalance(baseDocument, JavaTokenId.LBRACE);
    }

    private static void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c, TokenSequence<JavaTokenId> tokenSequence) throws BadLocationException {
        JavaTokenId javaTokenId = BraceCompletion.bracketCharToId(c);
        int n = caret.getDot();
        if (BraceCompletion.isSkipClosingBracket(baseDocument, n, javaTokenId)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument baseDocument, int n, JavaTokenId javaTokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, false);
        if (tokenSequence != null && tokenSequence.token().id() == javaTokenId) {
            JavaTokenId javaTokenId2 = BraceCompletion.matching(javaTokenId);
            do {
                if (!STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET.contains(tokenSequence.token().id()) && (tokenSequence.token().id() != JavaTokenId.WHITESPACE || !((Object)tokenSequence.token().text()).toString().contains("\n"))) continue;
                while (tokenSequence.token().id() != javaTokenId && tokenSequence.movePrevious()) {
                }
                break;
            } while (tokenSequence.moveNext());
            int n2 = 0;
            int n3 = -1;
            int n4 = tokenSequence.index();
            boolean bl2 = false;
            while (!bl2 && tokenSequence.movePrevious()) {
                JavaTokenId javaTokenId3 = (JavaTokenId)tokenSequence.token().id();
                switch (javaTokenId3) {
                    case LPAREN: 
                    case LBRACKET: {
                        if (javaTokenId3 != javaTokenId2 || ++n3 != 0) break;
                        if (n2 != 0) {
                            n3 = 1;
                        }
                        bl2 = tokenSequence.offset() < n;
                        break;
                    }
                    case RPAREN: 
                    case RBRACKET: {
                        if (javaTokenId3 != javaTokenId) break;
                        --n3;
                        break;
                    }
                    case LBRACE: {
                        if (++n2 <= 0) break;
                        bl2 = true;
                        break;
                    }
                    case RBRACE: {
                        --n2;
                    }
                }
            }
            bl = n3 != 0;
        }
        return bl;
    }

    private static void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c, TokenSequence<JavaTokenId> tokenSequence) throws BadLocationException {
        if (BraceCompletion.isCompletablePosition(baseDocument, n + 1)) {
            baseDocument.insertString(n + 1, String.valueOf(BraceCompletion.matching(c)), null);
            caret.setDot(n + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        if (n == 1) {
            char c = baseDocument.getChars(n - 1, 1)[0];
            return c == '\\';
        }
        char[] cArray = baseDocument.getChars(n - 2, 2);
        return cArray[0] != '\\' && cArray[1] == '\\';
    }

    static boolean completeQuote(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        boolean bl;
        boolean bl2;
        if (!BraceCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BraceCompletion.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n, true);
        JavaTokenId javaTokenId = tokenSequence != null ? (JavaTokenId)tokenSequence.token().id() : null;
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        boolean bl3 = n2 < n;
        boolean bl4 = bl2 = javaTokenId != null && (tokenSequence.offset() + tokenSequence.token().length() > n || tokenSequence.token().partType() == PartType.START);
        if (bl2 && (javaTokenId == JavaTokenId.BLOCK_COMMENT || javaTokenId == JavaTokenId.JAVADOC_COMMENT || javaTokenId == JavaTokenId.LINE_COMMENT)) {
            return false;
        }
        boolean bl5 = BraceCompletion.isQuoteCompletablePosition(baseDocument, n);
        boolean bl6 = bl = bl2 && (javaTokenId == JavaTokenId.STRING_LITERAL || javaTokenId == JavaTokenId.CHAR_LITERAL);
        if (bl) {
            if (bl3) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c && n > 0) {
                tokenSequence.move(n - 1);
                if (tokenSequence.moveNext() && ((javaTokenId = (JavaTokenId)tokenSequence.token().id()) == JavaTokenId.STRING_LITERAL || javaTokenId == JavaTokenId.CHAR_LITERAL)) {
                    baseDocument.insertString(n, String.valueOf(c), null);
                    baseDocument.remove(n, 1);
                    return true;
                }
            }
        }
        if (bl5 && !bl || bl3) {
            baseDocument.insertString(n, String.valueOf(c) + c, null);
            return true;
        }
        return false;
    }

    private static boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private static boolean isQuoteCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n == n2 || n2 == -1) {
            return false;
        }
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n2);
        if (n3 == -1) {
            return false;
        }
        char c = baseDocument.getChars(n3, 1)[0];
        return c == ')' || c == ',' || c == '+' || c == '}' || c == ';';
    }

    static boolean completionSettingEnabled() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
        return preferences.getBoolean("pair-characters-completion", false);
    }

    private static char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    private static JavaTokenId matching(JavaTokenId javaTokenId) {
        switch (javaTokenId) {
            case LPAREN: {
                return JavaTokenId.RPAREN;
            }
            case LBRACKET: {
                return JavaTokenId.RBRACKET;
            }
            case RPAREN: {
                return JavaTokenId.LPAREN;
            }
            case RBRACKET: {
                return JavaTokenId.LBRACKET;
            }
        }
        return null;
    }

    private static JavaTokenId bracketCharToId(char c) {
        switch (c) {
            case '(': {
                return JavaTokenId.LPAREN;
            }
            case ')': {
                return JavaTokenId.RPAREN;
            }
            case '[': {
                return JavaTokenId.LBRACKET;
            }
            case ']': {
                return JavaTokenId.RBRACKET;
            }
            case '{': {
                return JavaTokenId.LBRACE;
            }
            case '}': {
                return JavaTokenId.RBRACE;
            }
        }
        throw new IllegalArgumentException("Not a bracket char '" + c + '\'');
    }

    static boolean posWithinString(BaseDocument baseDocument, int n) {
        return BraceCompletion.posWithinQuotes(baseDocument, n, '\"', JavaTokenId.STRING_LITERAL);
    }

    static boolean posWithinQuotes(BaseDocument baseDocument, int n, char c, JavaTokenId javaTokenId) {
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n - 1, false);
        if (tokenSequence != null) {
            return tokenSequence.token().id() == javaTokenId && (n - tokenSequence.offset() == 1 || n > 0 && (DocumentUtilities.getText((Document)baseDocument).charAt(n - 1) != c || n >= 2 && DocumentUtilities.getText((Document)baseDocument).charAt(n - 2) == '\\'));
        }
        return false;
    }

    static boolean posWithinAnyQuote(BaseDocument baseDocument, int n) {
        JavaTokenId javaTokenId;
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n - 1, false);
        if (tokenSequence != null && ((javaTokenId = (JavaTokenId)tokenSequence.token().id()) == JavaTokenId.STRING_LITERAL || javaTokenId == JavaTokenId.CHAR_LITERAL)) {
            char c = DocumentUtilities.getText((Document)baseDocument).charAt(n - 1);
            return n - tokenSequence.offset() == 1 || c != '\"' && c != '\'';
        }
        return false;
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument baseDocument, int n) {
        int n2;
        try {
            n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        TokenSequence<JavaTokenId> tokenSequence = BraceCompletion.javaTokenSequence((Document)baseDocument, n2, true);
        if (tokenSequence != null) {
            return tokenSequence.token().id() == JavaTokenId.STRING_LITERAL;
        }
        return false;
    }
}

