/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SelectCodeElementAction
extends BaseAction {
    private boolean selectNext;

    public SelectCodeElementAction(String string, boolean bl) {
        super(string);
        this.selectNext = bl;
        String string2 = this.getShortDescription();
        if (string2 != null) {
            this.putValue("ShortDescription", string2);
        }
    }

    public String getShortDescription() {
        String string;
        String string2 = (String)this.getValue("Name");
        if (string2 == null) {
            return null;
        }
        try {
            string = NbBundle.getBundle(JavaKit.class).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string = string2;
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            if (n2 > n || this.selectNext) {
                SelectionHandler selectionHandler = (SelectionHandler)jTextComponent.getClientProperty(SelectionHandler.class);
                if (selectionHandler == null) {
                    selectionHandler = new SelectionHandler(jTextComponent);
                    jTextComponent.addCaretListener(selectionHandler);
                    jTextComponent.putClientProperty(SelectionHandler.class, selectionHandler);
                }
                if (this.selectNext) {
                    selectionHandler.selectNext();
                } else {
                    selectionHandler.selectPrevious();
                }
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;

        SelectionInfo(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectionHandler
    implements CaretListener,
    Task<CompilationController>,
    Runnable {
        private JTextComponent target;
        private SelectionInfo[] selectionInfos;
        private int selIndex = -1;
        private boolean ignoreNextCaretUpdate;

        SelectionHandler(JTextComponent jTextComponent) {
            this.target = jTextComponent;
        }

        public void selectNext() {
            if (this.selectionInfos == null) {
                JavaSource javaSource = JavaSource.forDocument((Document)this.target.getDocument());
                try {
                    javaSource.runUserActionTask((Task)this, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.run();
        }

        public synchronized void selectPrevious() {
            if (this.selIndex > 0) {
                this.select(this.selectionInfos[--this.selIndex]);
            }
        }

        private void select(SelectionInfo selectionInfo) {
            Caret caret = this.target.getCaret();
            this.markIgnoreNextCaretUpdate();
            caret.setDot(selectionInfo.getStartOffset());
            this.markIgnoreNextCaretUpdate();
            caret.moveDot(selectionInfo.getEndOffset());
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (!this.ignoreNextCaretUpdate) {
                SelectionHandler selectionHandler = this;
                synchronized (selectionHandler) {
                    this.selectionInfos = null;
                    this.selIndex = -1;
                }
            }
            this.ignoreNextCaretUpdate = false;
        }

        public void run(CompilationController compilationController) {
            try {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                this.selectionInfos = this.initSelectionPath(this.target, compilationController);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private SelectionInfo[] initSelectionPath(JTextComponent jTextComponent, CompilationController compilationController) {
            ArrayList<SelectionInfo> arrayList = new ArrayList<SelectionInfo>();
            SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
            TreePath treePath = compilationController.getTreeUtilities().pathFor(jTextComponent.getCaretPosition());
            for (Tree tree : treePath) {
                int n = (int)sourcePositions.getStartPosition(treePath.getCompilationUnit(), tree);
                int n2 = (int)sourcePositions.getEndPosition(treePath.getCompilationUnit(), tree);
                arrayList.add(new SelectionInfo(n, n2));
            }
            return arrayList.toArray(new SelectionInfo[arrayList.size()]);
        }

        @Override
        public void run() {
            if (this.selIndex < this.selectionInfos.length - 1) {
                this.select(this.selectionInfos[++this.selIndex]);
            }
        }
    }
}

