/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IsOverriddenAnnotationAction
extends AbstractAction {
    public IsOverriddenAnnotationAction() {
        this.putValue("Name", NbBundle.getMessage(IsOverriddenAnnotationAction.class, (String)"CTL_IsOverriddenAnnotationAction"));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.invokeDefaultAction((JTextComponent)actionEvent.getSource())) {
            Action action;
            int n;
            Action[] actionArray = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)actionEvent.getSource());
            if (actionArray == null) {
                return;
            }
            for (n = 0; n < actionArray.length && actionArray[n] != this; ++n) {
            }
            if (actionArray.length > ++n && (action = actionArray[n]) != null && action.isEnabled()) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    private FileObject getFile(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    private IsOverriddenAnnotation findAnnotation(JTextComponent jTextComponent, AnnotationDesc annotationDesc, int n) {
        FileObject fileObject = this.getFile(jTextComponent);
        if (fileObject == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + jTextComponent + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder annotationsHolder = AnnotationsHolder.get(fileObject);
        if (annotationsHolder == null) {
            IsOverriddenAnnotationHandler.LOG.log(Level.INFO, "component=" + jTextComponent + " does not have attached a IsOverriddenAnnotationHandler");
            return null;
        }
        for (IsOverriddenAnnotation isOverriddenAnnotation : annotationsHolder.getAnnotations()) {
            if (isOverriddenAnnotation.getPosition().getOffset() != n || !annotationDesc.getShortDescription().equals(isOverriddenAnnotation.getShortDescription())) continue;
            return isOverriddenAnnotation;
        }
        return null;
    }

    boolean invokeDefaultAction(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            final int n = jTextComponent.getCaretPosition();
            final Annotations annotations = ((BaseDocument)document).getAnnotations();
            final IsOverriddenAnnotation[] isOverriddenAnnotationArray = new IsOverriddenAnnotation[1];
            final Point[] pointArray = new Point[1];
            document.render(new Runnable(){

                public void run() {
                    try {
                        int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n3);
                        AnnotationDesc annotationDesc = annotations.getActiveAnnotation(n3);
                        pointArray[0] = jTextComponent.modelToView(n2).getLocation();
                        isOverriddenAnnotationArray[0] = IsOverriddenAnnotationAction.this.findAnnotation(jTextComponent, annotationDesc, n2);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            if (isOverriddenAnnotationArray[0] == null) {
                return false;
            }
            JumpList.checkAddEntry((JTextComponent)jTextComponent, (int)n);
            isOverriddenAnnotationArray[0].mouseClicked(jTextComponent, pointArray[0]);
            return true;
        }
        return false;
    }
}

