/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.EmbeddedLexerBasedHighlightSequence;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerBasedHighlightLayer
extends AbstractHighlightsContainer {
    private Map<Token, ColoringAttributes.Coloring> colorings;
    private Map<ColoringAttributes.Coloring, AttributeSet> CACHE = new HashMap<ColoringAttributes.Coloring, AttributeSet>();
    private Document doc;

    public static LexerBasedHighlightLayer getLayer(Class clazz, Document document) {
        LexerBasedHighlightLayer lexerBasedHighlightLayer = (LexerBasedHighlightLayer)((Object)document.getProperty(clazz));
        if (lexerBasedHighlightLayer == null) {
            lexerBasedHighlightLayer = new LexerBasedHighlightLayer(document);
            document.putProperty(clazz, (Object)lexerBasedHighlightLayer);
        }
        return lexerBasedHighlightLayer;
    }

    private LexerBasedHighlightLayer(Document document) {
        this.doc = document;
        this.colorings = Collections.emptyMap();
    }

    public void setColorings(final Map<Token, ColoringAttributes.Coloring> map, final Set<Token> set, Set<Token> set2) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LexerBasedHighlightLayer lexerBasedHighlightLayer = LexerBasedHighlightLayer.this;
                synchronized (lexerBasedHighlightLayer) {
                    LexerBasedHighlightLayer.this.colorings = map;
                    if (!set.isEmpty()) {
                        if (set.size() == 1) {
                            Token token = (Token)set.iterator().next();
                            LexerBasedHighlightLayer.this.fireHighlightsChange(token.offset(null), token.offset(null) + token.length());
                        } else {
                            LexerBasedHighlightLayer.this.fireHighlightsChange(0, LexerBasedHighlightLayer.this.doc.getLength());
                        }
                    }
                }
            }
        });
    }

    public synchronized Map<Token, ColoringAttributes.Coloring> getColorings() {
        return this.colorings;
    }

    public synchronized HighlightsSequence getHighlights(int n, int n2) {
        if (this.colorings.isEmpty()) {
            return HighlightsSequence.EMPTY;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence.language() == JavaTokenId.language()) {
            return new LexerBasedHighlightSequence(this, tokenSequence.subSequence(n, n2), this.colorings);
        }
        return new EmbeddedLexerBasedHighlightSequence(this, tokenSequence.subSequence(n, n2), this.colorings);
    }

    public synchronized void clearColoringCache() {
        this.CACHE.clear();
    }

    synchronized AttributeSet getColoring(ColoringAttributes.Coloring coloring) {
        AttributeSet attributeSet = this.CACHE.get(coloring);
        if (attributeSet == null) {
            attributeSet = ColoringManager.getColoringImpl(coloring);
            this.CACHE.put(coloring, attributeSet);
        }
        return attributeSet;
    }
}

