/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.SunStudioDataCollector;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorsUpdateService {
    private static final Pattern METRIC_LINE_PATTERN = Pattern.compile("^ *([0-9]+(?:,[0-9]*)?) [^<]*$");
    private static final DecimalFormat METRIC_FORMAT = new DecimalFormat();
    private static final Metrics LEAK_METRICS;
    private static final List<String> LEAK_COLNAMES;
    private static final Metrics SYNC_METRICS;
    private static final List<String> SYNC_COLNAMES;
    private static final List<String> DATARACE_COLNAMES;
    private static final List<String> DEADLOCK_COLNAMES;
    private static final Logger log;
    private final SunStudioDataCollector ssdc;
    private final ExecutionEnvironment execEnv;
    private final String sproHome;
    private final String experimentDir;
    private final boolean isSyncMonitor;
    private final boolean isMemoryMonitor;
    private final boolean isDataRaceMonitor;
    private final boolean isDeadlockMonitor;
    private final Object updaterLock = MonitorsUpdateService.class.getName() + "Lock";
    private Updater updater = null;
    private BlockingQueue<Object> requestsQueue = new LinkedBlockingQueue<Object>(1);

    MonitorsUpdateService(SunStudioDataCollector sunStudioDataCollector, ExecutionEnvironment executionEnvironment, String string, String string2, Set<SunStudioDCConfiguration.CollectedInfo> set) {
        this.ssdc = sunStudioDataCollector;
        this.sproHome = string;
        this.execEnv = executionEnvironment;
        this.experimentDir = string2;
        this.isSyncMonitor = set.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY);
        this.isMemoryMonitor = set.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
        this.isDataRaceMonitor = set.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES);
        this.isDeadlockMonitor = set.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean bl;
        if (this.isBlank()) {
            return;
        }
        try {
            bl = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getOSFamily() == HostInfo.OSFamily.LINUX;
        }
        catch (CancellationException cancellationException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater != null) {
                return;
            }
            this.updater = new Updater(bl);
            DLightExecutorService.submit((Runnable)this.updater, (String)MonitorsUpdateService.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater == null) {
                return;
            }
            this.updater.stop();
            this.updater = null;
        }
    }

    boolean isBlank() {
        return !this.isMemoryMonitor && !this.isSyncMonitor && !this.isDataRaceMonitor && !this.isDeadlockMonitor;
    }

    static /* synthetic */ ExecutionEnvironment access$100(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.execEnv;
    }

    static /* synthetic */ String access$200(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.sproHome;
    }

    static /* synthetic */ String access$300(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.experimentDir;
    }

    static /* synthetic */ SunStudioDataCollector access$400(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.ssdc;
    }

    static /* synthetic */ boolean access$600(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.isSyncMonitor;
    }

    static /* synthetic */ Metrics access$700() {
        return SYNC_METRICS;
    }

    static /* synthetic */ List access$800() {
        return SYNC_COLNAMES;
    }

    static /* synthetic */ boolean access$900(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.isMemoryMonitor;
    }

    static /* synthetic */ Metrics access$1000() {
        return LEAK_METRICS;
    }

    static /* synthetic */ List access$1100() {
        return LEAK_COLNAMES;
    }

    static /* synthetic */ boolean access$1200(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.isDataRaceMonitor;
    }

    static /* synthetic */ List access$1300() {
        return DATARACE_COLNAMES;
    }

    static /* synthetic */ boolean access$1400(MonitorsUpdateService monitorsUpdateService) {
        return monitorsUpdateService.isDeadlockMonitor;
    }

    static /* synthetic */ List access$1500() {
        return DEADLOCK_COLNAMES;
    }

    static {
        METRIC_FORMAT.getDecimalFormatSymbols().setDecimalSeparator(',');
        LEAK_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_leakSize), Arrays.asList(SunStudioDCConfiguration.c_leakSize));
        LEAK_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_leakSize.getColumnName()));
        SYNC_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_eSync), Arrays.asList(SunStudioDCConfiguration.c_eSync));
        SYNC_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_ulockSummary.getColumnName(), SunStudioDCConfiguration.c_threadsCount.getColumnName()));
        DATARACE_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_Datarace.getColumnName()));
        DEADLOCK_COLNAMES = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_Deadlocks.getColumnName()));
        log = DLightLogger.getLogger(MonitorsUpdateService.class);
    }

    private class Updater
    implements Runnable {
        private volatile boolean isStopped = false;
        private volatile ErprintSession erprintSession;
        private boolean linuxMode;

        public Updater(boolean bl) {
            this.linuxMode = bl;
        }

        public void stop() {
            this.isStopped = true;
            MonitorsUpdateService.this.requestsQueue.offer(new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block21: {
                if (this.erprintSession != null) {
                    throw new IllegalStateException("Updater can be started only once!");
                }
                this.erprintSession = ErprintSession.createNew(MonitorsUpdateService.access$100(MonitorsUpdateService.this), MonitorsUpdateService.access$200(MonitorsUpdateService.this), MonitorsUpdateService.access$300(MonitorsUpdateService.this), MonitorsUpdateService.access$400(MonitorsUpdateService.this));
                var1_1 = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                    public void run() {
                        if (!Updater.this.isStopped) {
                            MonitorsUpdateService.this.requestsQueue.offer(new Object());
                        }
                    }
                }, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"SunStudio monitors update task");
                var2_2 = 0.0;
                var4_3 = 0.0;
                while (true) lbl-1000:
                // 5 sources

                {
                    try {
                        if (MonitorsUpdateService.access$000(MonitorsUpdateService.this).poll(2L, TimeUnit.SECONDS) == null) {
                        }
                    }
                    catch (InterruptedException var6_5) {}
                    break block21;
                    var6_4 = false;
                    var7_6 = new ArrayList<DataRow>();
                    try {
                        if (MonitorsUpdateService.access$600(MonitorsUpdateService.this)) {
                            var8_7 = this.erprintSession.getExperimentStatistics(5, var6_4 == false);
                            var9_9 = this.erprintSession.getThreadsStatistic(5, false);
                            var6_4 = true;
                            var10_11 = var9_9.getThreadsCount();
                            var11_12 = var8_7.getDuration();
                            v0 = var12_13 = var11_12 == null ? 0.0 : var11_12;
                            if (this.linuxMode) {
                                var16_15 = this.erprintSession.getHotFunctions(MonitorsUpdateService.access$700(), 0x7FFFFFFF, 5, false);
                                var14_14 = var16_15 == null || var16_15.length == 0 ? var4_3 : this.sumMetrics(var16_15);
                            } else {
                                var16_15 = var8_7.getULock();
                                v1 = var14_14 = var16_15 == null ? 0.0 : var16_15.doubleValue();
                            }
                            if (0.1 < var12_13 - var2_2) {
                                var7_6.add(new DataRow(MonitorsUpdateService.access$800(), Arrays.asList(new Number[]{100.0 * (var14_14 - var4_3) / (var12_13 - var2_2) / (double)var10_11, var10_11})));
                                var2_2 = var12_13;
                                var4_3 = var14_14;
                            }
                        }
                        if (MonitorsUpdateService.access$900(MonitorsUpdateService.this)) {
                            var8_7 = this.erprintSession.getHotFunctions(MonitorsUpdateService.access$1000(), 0x7FFFFFFF, 5, var6_4 == false);
                            var6_4 = true;
                            var9_10 = var8_7 == null || ((String[])var8_7).length == 0 ? 0L : (long)this.sumMetrics((String[])var8_7);
                            var7_6.add(new DataRow(MonitorsUpdateService.access$1100(), Arrays.asList(new Long[]{var9_10})));
                        }
                        if (MonitorsUpdateService.access$1200(MonitorsUpdateService.this)) {
                            var8_7 = this.erprintSession.getDataRaces(var6_4 == false);
                            var6_4 = true;
                            var7_6.add(new DataRow(MonitorsUpdateService.access$1300(), Arrays.asList(new Integer[]{var8_7.size()})));
                        }
                        if (!MonitorsUpdateService.access$1400(MonitorsUpdateService.this)) ** GOTO lbl-1000
                        var8_7 = this.erprintSession.getDeadlocks(var6_4 == false);
                        var6_4 = true;
                        var7_6.add(new DataRow(MonitorsUpdateService.access$1500(), Arrays.asList(new Integer[]{var8_7.size()})));
                    }
                    catch (Throwable var8_8) {
                        var8_8.printStackTrace();
                        MonitorsUpdateService.access$1600().log(Level.FINEST, "Exception while updateIndicators in MonitorUpdateService: " + var8_8.toString());
                    }
                    finally {
                        MonitorsUpdateService.access$400(MonitorsUpdateService.this).updateIndicators(var7_6);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (var1_1 != null) {
                        var1_1.cancel(false);
                    }
                    if (this.erprintSession != null) {
                        this.erprintSession.close();
                    }
                    MonitorsUpdateService.access$400(MonitorsUpdateService.this).notifyIndicatorsThatProviderFinished();
                }
            }
        }

        private double sumMetrics(String[] stringArray) {
            double d = 0.0;
            for (String string : stringArray) {
                Matcher matcher = METRIC_LINE_PATTERN.matcher(string);
                if (!matcher.matches()) continue;
                String string2 = matcher.group(1);
                try {
                    d += METRIC_FORMAT.parse(string2).doubleValue();
                }
                catch (ParseException parseException) {
                    log.log(Level.WARNING, null, parseException);
                }
            }
            return d;
        }
    }
}

