/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi.datafilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectedObjectsFilter
implements DataFilter {
    private final List<String> selectedObjectsList;
    private final List<String> hiddenObjectsList;
    private final Pattern selectedPattern = Pattern.compile(".*\\+\\[([^\\[\\]]*)\\].*");
    private final Pattern hiddenPattern = Pattern.compile(".*-\\[([^\\[\\]]*)\\].*");

    protected CollectedObjectsFilter(String string) {
        this.selectedObjectsList = this.extractList(this.selectedPattern, string);
        this.hiddenObjectsList = this.extractList(this.hiddenPattern, string);
    }

    public Collection<String> hiddenObjects() {
        return new ArrayList<String>(this.hiddenObjectsList);
    }

    public Collection<String> selectedObjects() {
        return new ArrayList<String>(this.selectedObjectsList);
    }

    private List<String> extractList(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return Arrays.asList(string2.split(","));
        }
        return Collections.emptyList();
    }
}

