/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DataraceImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DeadlockImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.LeaksStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.ThreadsStatistic;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Erprint {
    private static final Pattern specPattern = Pattern.compile("[^:]*: (.*)");
    private static final Pattern sortPattern = Pattern.compile(".* \\( (.*) \\)");
    private static final Pattern choicePattern = Pattern.compile("^[ \t]+([0-9]+)\\) .*:0x([0-9a-f]+) +\\((.*)\\)");
    private static final String choiceMarker = "Available name list:";
    private final Logger log = DLightLogger.getLogger(Erprint.class);
    private final AtomicInteger locks = new AtomicInteger();
    private final NativeProcess process;
    private final InputStream out;
    private final InputStream err;
    private final OutputStream in;
    private final OutputProcessor outProcessor;
    private int currentLimit = -1;
    private boolean stopped = false;
    private final String logPrefix;

    Erprint(NativeProcessBuilder nativeProcessBuilder, int n) throws IOException {
        this.process = nativeProcessBuilder.call();
        this.logPrefix = "er_print [" + this.process.getPID() + "]: ";
        this.addLock();
        String string = System.getProperty("nativeexecution.support.logger.er_print");
        if (string == null) {
            this.log.setLevel(Level.INFO);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(this.logPrefix + "started");
        }
        this.out = this.process.getInputStream();
        this.in = this.process.getOutputStream();
        this.err = this.process.getErrorStream();
        this.outProcessor = new OutputProcessor();
        this.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock() throws IllegalStateException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                throw new IllegalStateException("er_print is scheduled to be stopped already!");
            }
            this.locks.incrementAndGet();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock() {
        Erprint erprint = this;
        synchronized (erprint) {
            this.locks.decrementAndGet();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                if (Erprint.this.log.isLoggable(Level.FINEST)) {
                    Erprint.this.log.finest(Erprint.this.logPrefix + "Scheduled for termination");
                }
                int n = 30;
                while (Erprint.this.locks.get() != 0 && --n > 0) {
                    try {
                        if (Erprint.this.log.isLoggable(Level.FINEST)) {
                            Erprint.this.log.finest(Erprint.this.logPrefix + "waiting for lock release [" + Erprint.this.locks.get() + "] ...");
                        }
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!Erprint.this.log.isLoggable(Level.FINEST)) break;
                        Erprint.this.log.log(Level.FINEST, Erprint.this.logPrefix + "Exception while terminating", interruptedException);
                        break;
                    }
                }
                if (Erprint.this.log.isLoggable(Level.FINEST)) {
                    if (Erprint.this.locks.get() > 0) {
                        Erprint.this.log.finest(Erprint.this.logPrefix + "do force termination");
                    } else {
                        Erprint.this.log.finest(Erprint.this.logPrefix + "do termination");
                    }
                }
                Erprint.this.process.destroy();
            }
        }, (String)("Stopping er_print " + this.logPrefix));
    }

    private void post(String string) throws IOException {
        this.in.write((string + "\n").getBytes());
        this.in.flush();
    }

    public synchronized int setLimit(int n) throws IOException {
        if (this.currentLimit == n) {
            return this.currentLimit;
        }
        int n2 = this.currentLimit;
        this.exec(ErprintCommand.limit(n));
        this.currentLimit = n;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metrics setMetrics(Metrics metrics) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            String[] stringArray = this.exec(ErprintCommand.metrics());
            if (stringArray == null || stringArray.length != 2) {
                return null;
            }
            Matcher matcher = specPattern.matcher(stringArray[0]);
            Matcher matcher2 = sortPattern.matcher(stringArray[1]);
            Metrics metrics2 = null;
            if (matcher.matches() && matcher2.matches()) {
                metrics2 = new Metrics(matcher.group(1), matcher2.group(1));
            }
            this.exec(ErprintCommand.metrics(metrics.mspec));
            this.exec(ErprintCommand.sort(metrics.msort));
            return metrics2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metrics getExperimentMetrics() throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            String[] stringArray = this.exec(ErprintCommand.metrics());
            if (stringArray == null || stringArray.length != 2) {
                return null;
            }
            Matcher matcher = specPattern.matcher(stringArray[0]);
            Matcher matcher2 = sortPattern.matcher(stringArray[1]);
            Metrics metrics = null;
            if (matcher.matches() && matcher2.matches()) {
                metrics = new Metrics(matcher.group(1), matcher2.group(1));
            }
            return metrics;
        }
    }

    String[] getHotFunctions(ErprintCommand erprintCommand, int n) throws IOException {
        String[] stringArray = this.exec(erprintCommand);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!string.matches("^ *[0-9]+.*") || string.contains("<Total>")) continue;
            arrayList.add(string.trim());
            if (--n == 0) break;
        }
        return arrayList.toArray(new String[0]);
    }

    String[] getHotFunctions(int n) throws IOException {
        return this.getHotFunctions(ErprintCommand.functions(), n);
    }

    ExperimentStatistics getExperimentStatistics() throws IOException {
        String[] stringArray = this.exec(ErprintCommand.statistics());
        return new ExperimentStatistics(stringArray);
    }

    ThreadsStatistic getThreadsStatistics() throws IOException {
        String[] stringArray = this.exec(ErprintCommand.thread_list());
        return new ThreadsStatistic(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectObjects(CollectedObjectsFilter collectedObjectsFilter) throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.stopped || collectedObjectsFilter == null) {
                return;
            }
        }
        object = Pattern.compile(".* <(.*)>.*");
        StringBuilder stringBuilder = new StringBuilder();
        Erprint erprint = this;
        synchronized (erprint) {
            String[] stringArray = this.exec(ErprintCommand.object_list());
            Collection<String> collection = collectedObjectsFilter.selectedObjects();
            Collection<String> collection2 = collectedObjectsFilter.hiddenObjects();
            collection2.add("libcollector.so");
            collection2.add("er_heap.so");
            collection2.add("er_sync.so");
            collection2.add("Unknown");
            for (String string : stringArray) {
                String string2;
                Matcher matcher = ((Pattern)object).matcher(string);
                if (!matcher.matches() || !collection.contains(string2 = matcher.group(1)) && collection2.contains(string2)) continue;
                stringBuilder.append(string2).append(",");
            }
            if (stringBuilder.length() != 0) {
                this.exec(ErprintCommand.object_select(stringBuilder.toString()));
            }
        }
    }

    LeaksStatistics getExperimentLeaks() throws IOException {
        String[] stringArray = this.exec(ErprintCommand.leaks());
        return new LeaksStatistics(stringArray);
    }

    List<DataraceImpl> getDataRaces() throws IOException {
        String[] stringArray = this.exec(ErprintCommand.rdetail_all());
        return DataraceImpl.fromErprint(stringArray);
    }

    boolean setFilter(String string) throws IOException {
        String[] stringArray = this.exec(ErprintCommand.filter(string == null ? "\"\"" : string));
        return stringArray == null || stringArray.length <= 0 || !stringArray[0].startsWith("Error");
    }

    List<DeadlockImpl> getDeadlocks() throws IOException {
        String[] stringArray = this.exec(ErprintCommand.ddetail_all());
        return DeadlockImpl.fromErprint(stringArray);
    }

    FunctionStatistic getFunctionStatistic(String string) throws IOException {
        String[] stringArray = this.exec(ErprintCommand.fsingle(string, 1));
        return new FunctionStatistic(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionStatistic getFunctionStatistic(FunctionCallImpl functionCallImpl) throws IOException {
        FunctionStatistic functionStatistic = new FunctionStatistic(new String[0]);
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return functionStatistic;
            }
            String string = functionCallImpl.getFunction().getName();
            String string2 = functionCallImpl.getSourceFile();
            String[] stringArray = this.exec(ErprintCommand.fsingle(string));
            String string3 = "1";
            if (stringArray != null && stringArray.length > 0 && choiceMarker.equals(stringArray[0])) {
                long l = functionCallImpl.getFunctionRefID();
                for (String string4 : stringArray) {
                    Matcher matcher = choicePattern.matcher(string4);
                    if (!matcher.matches()) continue;
                    string3 = matcher.group(1);
                    String string5 = matcher.group(2);
                    String string6 = matcher.group(3);
                    try {
                        if (Long.parseLong(string5, 16) != l && (string2 == null || !string6.endsWith(string2))) continue;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.post(string3);
                stringArray = this.outProcessor.getOutput();
            }
            functionStatistic = new FunctionStatistic(stringArray == null ? new String[]{} : stringArray);
            if (stringArray != null) {
                this.refineSourceInfo(functionStatistic, functionCallImpl, Integer.parseInt(string3));
            }
            return functionStatistic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] exec(ErprintCommand erprintCommand) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return new String[0];
            }
            long l = System.currentTimeMillis();
            try {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("> '" + erprintCommand.getCmd() + "'");
                }
                this.post(erprintCommand.getCmd());
            }
            catch (IOException iOException) {
                this.stop();
                return new String[0];
            }
            String[] stringArray = this.outProcessor.getOutput();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Command '" + erprintCommand.getCmd() + "' done in " + (System.currentTimeMillis() - l) / 1000L + " secs. Response is " + stringArray.length + " lines.");
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refineSourceInfo(FunctionStatistic functionStatistic, FunctionCallImpl functionCallImpl, int n) throws IOException {
        String string = functionCallImpl.getFunction().getName();
        long l = functionCallImpl.getFunctionRefID();
        if ("(unknown)".equals(functionStatistic.getSourceFile())) {
            return;
        }
        Erprint erprint = this;
        synchronized (erprint) {
            Metrics metrics = null;
            try {
                metrics = this.setMetrics(Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_address), null));
                String[] stringArray = this.exec(ErprintCommand.source(string, n));
                Pattern pattern = Pattern.compile(".*:0x([0-9a-f]+) +([0-9]+).*");
                long l2 = Long.MAX_VALUE;
                int n2 = -1;
                for (String string2 : stringArray) {
                    if (string2.startsWith("Source file:")) {
                        functionStatistic.setSrcFile(string2.substring(13).trim());
                        continue;
                    }
                    Matcher matcher = pattern.matcher(string2);
                    if (!matcher.matches()) continue;
                    try {
                        long l3 = Long.parseLong(matcher.group(1), 16);
                        long l4 = Math.abs(l - l3);
                        if (l4 >= l2) continue;
                        n2 = Integer.parseInt(matcher.group(2));
                        if (l4 == 0L) break;
                        l2 = l4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n2 > 0) {
                    functionStatistic.setSrcFileLine(n2);
                }
                if (metrics == null) return;
            }
            catch (Throwable throwable) {
                if (metrics == null) throw throwable;
                this.setMetrics(metrics);
                throw throwable;
            }
            this.setMetrics(metrics);
            {
            }
            return;
        }
    }

    private class OutputProcessor {
        private final ArrayList<String> resultBuffer = new ArrayList();
        private final StringBuilder lineBuffer = new StringBuilder();
        private final char[] prompt;
        private final char[] enterSelectionPrompt = "Enter selection: ".toCharArray();
        private final InputStream pis;

        public OutputProcessor() throws IOException {
            this.pis = Erprint.this.process.getInputStream();
            this.prompt = this.getPrompt();
        }

        public String[] getOutput() throws IOException {
            int n;
            int n2 = 0;
            int n3 = 0;
            this.resultBuffer.clear();
            this.lineBuffer.setLength(0);
            while ((n = this.pis.read()) >= 0) {
                if (n == 10) {
                    this.resultBuffer.add(this.lineBuffer.toString());
                    this.lineBuffer.setLength(0);
                } else {
                    this.lineBuffer.append((char)n);
                }
                if (n2 == this.prompt.length) break;
                if (this.prompt[n2] == n) {
                    if (++n2 == this.prompt.length) {
                        break;
                    }
                } else {
                    n2 = 0;
                }
                if (this.enterSelectionPrompt[n3] == n) {
                    if (++n3 != this.enterSelectionPrompt.length) continue;
                    break;
                }
                n3 = 0;
            }
            return this.resultBuffer.toArray(new String[0]);
        }

        private char[] getPrompt() throws IOException {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            char[] cArray = new char[4096];
            char[] cArray2 = null;
            try {
                int n4;
                cArray[0] = (char)Erprint.this.out.read();
                Erprint.this.post("");
                while ((n4 = Erprint.this.out.read()) >= 0) {
                    cArray[++n] = (char)n4;
                    if (cArray[n2] == cArray[n]) {
                        if (n3 == 0) {
                            n3 = n;
                        }
                        if (++n2 != n3) continue;
                        break;
                    }
                    n3 = 0;
                    n2 = 0;
                }
                cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                Erprint.this.stop();
                cArray2 = "<Terminated>".toCharArray();
            }
            return cArray2;
        }
    }
}

