/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.util.DLightLogger;

public final class ExperimentStatistics {
    private final Double startTime;
    private final Double endTime;
    private final Double duration;
    private final Double totalThreadTime;
    private final Double avrgThreadsNumber;
    private final Double t_userCPU;
    private final Double t_userCPU_p;
    private final Double t_sysCPU;
    private final Double t_sysCPU_p;
    private final Double t_waitCPU;
    private final Double t_waitCPU_p;
    private final Double t_usrLock;
    private final Double t_usrLock_p;

    ExperimentStatistics(String[] stringArray) {
        Object var2_2 = null;
        Object var3_3 = null;
        Double d = null;
        Double d2 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        Double d3 = null;
        Double d4 = null;
        for (String string : stringArray) {
            int n = string.indexOf(58);
            if (n < 0) continue;
            String string2 = string.substring(0, n).trim();
            try {
                if (string2.startsWith("User Lock")) {
                    StringTokenizer stringTokenizer = ExperimentStatistics.tokenize(string.substring(n + 1));
                    d3 = DataUtil.toDouble((Object)stringTokenizer.nextToken(), (double)Double.NaN);
                    d4 = DataUtil.toDouble((Object)stringTokenizer.nextToken(), (double)Double.NaN);
                    continue;
                }
                if (string2.startsWith("Total Thread Time") || string2.startsWith("Total LWP Time")) {
                    d2 = DataUtil.toDouble((Object)string.substring(n + 1), (double)Double.NaN);
                    continue;
                }
                if (!string2.startsWith("Duration")) continue;
                d = DataUtil.toDouble((Object)string.substring(n + 1), (double)Double.NaN);
            }
            catch (NoSuchElementException noSuchElementException) {
                DLightLogger.instance.log(Level.INFO, "Failed to parse statistics line", noSuchElementException);
            }
        }
        this.startTime = var2_2;
        this.endTime = var3_3;
        this.duration = d == null || Double.isNaN(d) ? null : d;
        this.totalThreadTime = d2 == null || Double.isNaN(d2) ? null : d2;
        this.avrgThreadsNumber = var6_6;
        this.t_userCPU = var7_7;
        this.t_userCPU_p = var8_8;
        this.t_sysCPU = var9_9;
        this.t_sysCPU_p = var10_10;
        this.t_waitCPU = var11_11;
        this.t_waitCPU_p = var12_12;
        this.t_usrLock = d3 == null || Double.isNaN(d3) ? null : d3;
        this.t_usrLock_p = d4 == null || Double.isNaN(d4) ? null : d4;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Double getTotalThreadTime() {
        return this.totalThreadTime;
    }

    public Double getULock() {
        return this.t_usrLock;
    }

    public Double getULock_p() {
        return this.t_usrLock_p;
    }

    private static StringTokenizer tokenize(String string) {
        return new StringTokenizer(string, " ()%");
    }
}

