/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.tha.api;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.perfan.tha.api.THAConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class THAInstrumentationSupport {
    private static final CollectVersion minSupportedVersion = CollectVersion.getCollectVersion("6.7");
    private static final ConcurrentHashMap<SSLocation, THAInstrumentationSupport> hash = new ConcurrentHashMap();
    private final ExecutionEnvironment execEnv;
    private Future<CollectVersion> version;
    private final String collectCMD;
    private final String binDir;

    public static THAInstrumentationSupport getSupport(ExecutionEnvironment executionEnvironment, String string) {
        SSLocation sSLocation = new SSLocation(executionEnvironment, string);
        THAInstrumentationSupport tHAInstrumentationSupport = hash.get(sSLocation);
        if (tHAInstrumentationSupport != null) {
            return tHAInstrumentationSupport;
        }
        tHAInstrumentationSupport = new THAInstrumentationSupport(executionEnvironment, string);
        THAInstrumentationSupport tHAInstrumentationSupport2 = hash.putIfAbsent(sSLocation, tHAInstrumentationSupport);
        if (tHAInstrumentationSupport2 != null) {
            return tHAInstrumentationSupport2;
        }
        return tHAInstrumentationSupport;
    }

    private THAInstrumentationSupport(ExecutionEnvironment executionEnvironment, String string) {
        this.binDir = string;
        this.execEnv = executionEnvironment;
        this.collectCMD = string + "collect";
    }

    public boolean isSupported() {
        boolean bl = false;
        try {
            CollectVersion collectVersion;
            if (this.version == null) {
                this.version = this.getVersion();
            }
            return (collectVersion = this.version.get()).compareTo(minSupportedVersion) > 0;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return bl;
    }

    public boolean isInstrumentationNeeded(ExecutionEnvironment executionEnvironment, THAConfiguration tHAConfiguration) {
        try {
            return tHAConfiguration.collectDataRaces() || !tHAConfiguration.collectDeadlocks() || !HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getCpuFamily().equals((Object)HostInfo.CpuFamily.SPARC);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return true;
    }

    public Future<Boolean> isInstrumented(final String string) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THAInstrumentationSupport.this.execEnv);
                nativeProcessBuilder.setExecutable(THAInstrumentationSupport.this.collectCMD).setArguments(new String[]{"-n", "-r races", string});
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
                int n = nativeProcess.waitFor();
                if (n == 0) {
                    String string3 = THAInstrumentationSupport.loc("THA_InstrumentedIdentifier", new String[0]);
                    for (String string2 : list) {
                        if (!string2.contains(string3)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private Future<CollectVersion> getVersion() {
        FutureTask<CollectVersion> futureTask = new FutureTask<CollectVersion>(new Callable<CollectVersion>(){

            @Override
            public CollectVersion call() throws Exception {
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THAInstrumentationSupport.this.execEnv);
                nativeProcessBuilder.setExecutable(THAInstrumentationSupport.this.binDir + "version").setArguments(new String[]{THAInstrumentationSupport.this.collectCMD});
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
                int n = nativeProcess.waitFor();
                if (n == 0) {
                    return CollectVersion.getCollectVersion((String)list.get(0));
                }
                return CollectVersion.UNKNOWN;
            }
        });
        futureTask.run();
        return futureTask;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(THAInstrumentationSupport.class, (String)string, (Object[])stringArray);
    }

    public String getLinkerOptions() {
        return "-xinstrument=datarace";
    }

    public String getCompilerOptions() {
        return "-xinstrument=datarace";
    }

    private static final class SSLocation {
        private final ExecutionEnvironment execEnv;
        private final String binDir;

        public SSLocation(ExecutionEnvironment executionEnvironment, String string) {
            this.execEnv = executionEnvironment;
            this.binDir = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SSLocation)) {
                return false;
            }
            SSLocation sSLocation = (SSLocation)object;
            return this.execEnv.equals(sSLocation.execEnv) && this.binDir.equals(sSLocation.binDir);
        }

        public int hashCode() {
            int n = 7;
            n = 23 * n + (this.execEnv != null ? this.execEnv.hashCode() : 0);
            n = 23 * n + (this.binDir != null ? this.binDir.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectVersion
    implements Comparable<CollectVersion> {
        public static final CollectVersion UNKNOWN = new CollectVersion(0, 0);
        private final int major;
        private final int minor;

        public static CollectVersion getCollectVersion(String string) {
            Pattern pattern = Pattern.compile("version [^:]+: Sun Analyzer ([1-9]+)\\.([1-9]+).*");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return new CollectVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
            }
            pattern = Pattern.compile("version [^:]+: Sun .*Analyzer ([1-9]+)\\.([1-9]+).*");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return new CollectVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
            }
            pattern = Pattern.compile("([1-9]+)\\.([1-9]+).*");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return new CollectVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
            }
            return UNKNOWN;
        }

        private CollectVersion(int n, int n2) {
            this.major = n;
            this.minor = n2;
        }

        @Override
        public int compareTo(CollectVersion collectVersion) {
            if (this.equals(collectVersion)) {
                return 0;
            }
            if (this.major == collectVersion.major) {
                return Integer.valueOf(this.minor).compareTo(collectVersion.minor);
            }
            return Integer.valueOf(this.major).compareTo(collectVersion.major);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof CollectVersion)) {
                return false;
            }
            CollectVersion collectVersion = (CollectVersion)object;
            return this.major == collectVersion.major && this.minor == collectVersion.minor;
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + this.major;
            n = 17 * n + this.minor;
            return n;
        }
    }
}

