/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane
implements ChangeListener,
PropertyChangeListener {
    private static final boolean JDK6_OR_LATER = System.getProperty("java.version").substring(0, 3).compareTo("1.6") >= 0;
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;
    private static final boolean HTML_TABS_BROKEN = CloseButtonTabbedPane.htmlTabsBroken();
    private final Pattern removeHtmlTags;
    private static Method setTabComponentAt;
    private static Method indexOfTabComponent;
    private static Method getTabComponentAt;

    CloseButtonTabbedPane() {
        Pattern pattern = this.removeHtmlTags = HTML_TABS_BROKEN ? Pattern.compile("\\<.*?\\>") : null;
        if (!JDK6_OR_LATER) {
            CloseButtonListener.install();
        } else {
            this.addMouseListener(new MouseAdapter(){
                int lastIdx = -1;

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        this.lastIdx = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        int n = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                        if (n >= 0) {
                            Component component = CloseButtonTabbedPane.this.getComponentAt(n);
                            if (n == this.lastIdx && component != null && !CloseButtonTabbedPane.this.hideCloseButton(component)) {
                                CloseButtonTabbedPane.this.fireCloseRequest(component);
                            }
                        }
                        this.lastIdx = -1;
                    }
                }
            });
        }
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
        this.setTabLayoutPolicy(JDK6_OR_LATER ? 1 : 0);
        this.addChangeListener(this);
    }

    private Component sel() {
        Component component = this.getSelectedComponent();
        return component == null ? this : component;
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        if (JDK6_OR_LATER) {
            component.addPropertyChangeListener("noCloseButton", this);
            if (!this.hideCloseButton(component)) {
                this.callSetTabComponentAt(n, new ButtonTab());
            }
        }
        if (string != null) {
            this.setTitleAt(n, string);
        }
    }

    public void removeTabAt(int n) {
        Component component = this.getComponentAt(n);
        component.removePropertyChangeListener("noCloseButton", this);
        super.removeTabAt(n);
    }

    private static boolean htmlTabsBroken() {
        String string = System.getProperty("java.version");
        for (int i = 14; i < 18; ++i) {
            if (!string.startsWith("1.6.0_" + i)) continue;
            return true;
        }
        return false;
    }

    public void setTitleAt(int n, String string) {
        String string2;
        Component component;
        if (string == null) {
            super.setTitleAt(n, null);
            return;
        }
        if (this.removeHtmlTags != null && string.startsWith("<html>")) {
            string = this.removeHtmlTags.matcher(string).replaceAll("");
            string = string.replace("&nbsp;", "");
        }
        if (this.hideCloseButton(component = this.findTabAt(n)) || JDK6_OR_LATER) {
            super.setTitleAt(n, string);
            return;
        }
        String string3 = string2 = string.indexOf("</html>") != -1 ? string.replace("</html>", "&nbsp;&nbsp;</html>") : string + "   ";
        if (!string2.equals(this.getTitleAt(n))) {
            super.setTitleAt(n, string2);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Component findTabAt(int n) {
        int n2 = -1;
        for (Component component : this.getComponents()) {
            if (component instanceof UIResource || ++n2 != n) continue;
            return component;
        }
        return null;
    }

    private boolean hideCloseButton(Component component) {
        Object object;
        return component != null && component instanceof JComponent && (object = ((JComponent)component).getClientProperty("noCloseButton")) != null && object instanceof Boolean && (Boolean)object != false;
    }

    private Rectangle getCloseButtonBoundsAt(int n) {
        Component component = this.findTabAt(n);
        if (this.hideCloseButton(component)) {
            return null;
        }
        Rectangle rectangle = this.getBoundsAt(n);
        if (rectangle == null) {
            return null;
        }
        rectangle = new Rectangle(rectangle);
        CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width >= dimension.width || rectangle.y + rectangle.height >= dimension.height) {
            return null;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && n == this.getSelectedIndex()) {
            rectangle.x -= 3;
            rectangle.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || this.isAquaLaF()) {
            rectangle.x -= 2;
        } else if (this.isGTKLaF() && n == this.getSelectedIndex()) {
            --rectangle.x;
            rectangle.y -= 2;
        }
        if (n == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --rectangle.x;
            } else if (this.isAquaLaF()) {
                rectangle.x -= 3;
            }
        }
        return new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y + rectangle.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && bl != null && bl != false;
    }

    private boolean isWindowsLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.endsWith("Windows");
    }

    private boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return "Metal".equals(string);
    }

    private boolean isGTKLaF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (JDK6_OR_LATER) {
            return;
        }
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = this.getCloseButtonBoundsAt(i);
            if (rectangle == null) continue;
            if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                graphics.drawImage(this.getCloseTabRolloverImage(), rectangle.x, rectangle.y, this);
                continue;
            }
            if (i == this.pressedCloseButtonIndex) {
                graphics.drawImage(this.getCloseTabPressedImage(), rectangle.x, rectangle.y, this);
                continue;
            }
            graphics.drawImage(this.getCloseTabImage(), rectangle.x, rectangle.y, this);
        }
    }

    private Image getCloseTabImage() {
        if (null == this.closeTabImage) {
            this.closeTabImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (this.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))));
        }
        return this.closeTabImage;
    }

    private Image getCloseTabPressedImage() {
        if (null == this.closeTabPressedImage) {
            this.closeTabPressedImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (this.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))));
        }
        return this.closeTabPressedImage;
    }

    private Image getCloseTabRolloverImage() {
        if (null == this.closeTabMouseOverImage) {
            this.closeTabMouseOverImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (this.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))));
        }
        return this.closeTabMouseOverImage;
    }

    private void setPressedCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.pressedCloseButtonIndex == n) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.pressedCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = n;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.mouseOverCloseButtonIndex == n) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.mouseOverCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = n;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int n) {
        Component component = this.getComponentAt(n);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    private void fireCloseRequest(Component component) {
        int n;
        this.firePropertyChange(PROP_CLOSE, null, component);
        if (this.getTabLayoutPolicy() == 1 && (n = this.getSelectedIndex()) > 0) {
            this.setSelectedIndex(0);
            this.setSelectedIndex(n);
        }
    }

    static void fixGetBoundsAt(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = -rectangle.y;
        }
        if (rectangle.x < 0) {
            rectangle.x = -rectangle.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(i);
            if (rectangle == null) continue;
            rectangle = new Rectangle(rectangle);
            CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        try {
            super.processMouseEvent(mouseEvent);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Exceptions.attachLocalizedMessage((Throwable)arrayIndexOutOfBoundsException, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, arrayIndexOutOfBoundsException);
        }
    }

    protected void fireStateChanged() {
        block2: {
            try {
                super.fireStateChanged();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Utilities.isMac()) break block2;
                throw arrayIndexOutOfBoundsException;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!JDK6_OR_LATER) {
            this.reset();
        }
    }

    public Color getBackgroundAt(int n) {
        if (this.isWindowsLaF() && !this.isWindowsXPLaF()) {
            Color color;
            Color color2 = UIManager.getColor("controlHighlight");
            if (color2.equals(color = UIManager.getColor("control"))) {
                color = new Color(Math.max(color2.getRed() - 12, 0), Math.max(color2.getGreen() - 12, 0), Math.max(color2.getBlue() - 12, 0));
            }
            return n == this.getSelectedIndex() ? color2 : color;
        }
        return super.getBackgroundAt(n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Component) {
            assert (propertyChangeEvent.getPropertyName().equals("noCloseButton"));
            Component component = (Component)propertyChangeEvent.getSource();
            int n = this.indexOfComponent(component);
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.callSetTabComponentAt(n, bl ? null : new ButtonTab());
        }
    }

    private void callSetTabComponentAt(int n, Component component) {
        if (setTabComponentAt == null) {
            try {
                setTabComponentAt = JTabbedPane.class.getMethod("setTabComponentAt", Integer.TYPE, Component.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
        }
        try {
            setTabComponentAt.invoke((Object)this, n, component);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    private int callIndexOfTabComponent(Component component) {
        if (indexOfTabComponent == null) {
            try {
                indexOfTabComponent = JTabbedPane.class.getMethod("indexOfTabComponent", Component.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
        }
        int n = -1;
        try {
            n = (Integer)indexOfTabComponent.invoke((Object)this, component);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        return n;
    }

    private Component callGetTabComponentAt(int n) {
        if (getTabComponentAt == null) {
            try {
                getTabComponentAt = JTabbedPane.class.getMethod("getTabComponentAt", Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
        }
        Component component = null;
        try {
            component = (Component)getTabComponentAt.invoke((Object)this, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        return component;
    }

    class ButtonTab
    extends JPanel {
        JLabel label;

        public ButtonTab() {
            super(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            this.label = new JLabel(""){

                public String getText() {
                    int n = CloseButtonTabbedPane.this.callIndexOfTabComponent(ButtonTab.this);
                    if (n >= 0) {
                        String string = CloseButtonTabbedPane.this.getTitleAt(n);
                        if (!super.getText().equals(string)) {
                            this.setText(string);
                        }
                        return string;
                    }
                    return "";
                }

                public Icon getIcon() {
                    Icon icon;
                    int n = CloseButtonTabbedPane.this.callIndexOfTabComponent(ButtonTab.this);
                    Icon icon2 = icon = n >= 0 ? CloseButtonTabbedPane.this.getIconAt(n) : null;
                    if (super.getIcon() != icon) {
                        this.setIcon(icon);
                    }
                    return icon;
                }
            };
            this.add(this.label);
            this.add(new TabButton());
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            public TabButton() {
                int n = 16;
                this.setPreferredSize(new Dimension(n, n));
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setBorderPainted(false);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
                this.setIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabImage()));
                this.setRolloverIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabRolloverImage()));
                this.setPressedIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabPressedImage()));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CloseButtonTabbedPane.this.callIndexOfTabComponent(ButtonTab.this);
                if (n != -1) {
                    CloseButtonTabbedPane.this.fireCloseRequest(CloseButtonTabbedPane.this.getComponentAt(n));
                }
            }
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (!(aWTEvent.getSource() instanceof Component)) {
                return;
            }
            for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof CloseButtonTabbedPane); component = component.getParent()) {
            }
            if (component == null) {
                return;
            }
            CloseButtonTabbedPane closeButtonTabbedPane = (CloseButtonTabbedPane)component;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), closeButtonTabbedPane);
            if (mouseEvent.getID() == 500) {
                return;
            }
            int n = CloseButtonTabbedPane.findTabForCoordinate(closeButtonTabbedPane, point.x, point.y);
            Rectangle rectangle = null;
            if (n >= 0) {
                rectangle = closeButtonTabbedPane.getCloseButtonBoundsAt(n);
            }
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!rectangle.contains(point) && !SwingUtilities.isMiddleMouseButton(mouseEvent)) break;
                    closeButtonTabbedPane.setPressedCloseButtonIndex(n);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    return;
                }
                case 502: {
                    if (rectangle.contains(point) && closeButtonTabbedPane.pressedCloseButtonIndex >= 0 || SwingUtilities.isMiddleMouseButton(mouseEvent) && n == closeButtonTabbedPane.pressedCloseButtonIndex) {
                        Component component2 = null;
                        if (closeButtonTabbedPane.pressedCloseButtonIndex >= 0 && closeButtonTabbedPane.pressedCloseButtonIndex < closeButtonTabbedPane.getComponentCount()) {
                            component2 = closeButtonTabbedPane.findTabAt(closeButtonTabbedPane.pressedCloseButtonIndex);
                        }
                        closeButtonTabbedPane.reset();
                        if (null != component2 && !closeButtonTabbedPane.hideCloseButton(component2)) {
                            closeButtonTabbedPane.fireCloseRequest(component2);
                        }
                        mouseEvent.consume();
                        return;
                    }
                    closeButtonTabbedPane.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (rectangle.contains(point)) {
                        closeButtonTabbedPane.setMouseOverCloseButtonIndex(n);
                        closeButtonTabbedPane.draggedOut = false;
                        mouseEvent.consume();
                        return;
                    }
                    if (closeButtonTabbedPane.mouseOverCloseButtonIndex < 0) break;
                    closeButtonTabbedPane.setMouseOverCloseButtonIndex(-1);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    break;
                }
                case 506: {
                    if (closeButtonTabbedPane.pressedCloseButtonIndex < 0) break;
                    if (closeButtonTabbedPane.draggedOut != !rectangle.contains(point)) {
                        closeButtonTabbedPane.draggedOut = !rectangle.contains(point);
                        closeButtonTabbedPane.repaint(rectangle.x, rectangle.y, rectangle.width + 2 + 6, rectangle.height + 2 + 6);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getLastComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }
    }
}

