/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ObjectMarshal;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.collections.WeakHashSet;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    public static final int CS_IDX_INITIALIZE = 0;
    public static final String[] CS_NAMES = new String[]{"initialize"};
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyClass rubyClass2 = new RubyClass(ruby);
            rubyClass2.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return rubyClass2;
        }
    };
    private final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
            IRubyObject iRubyObject = (IRubyObject)object;
            marshalStream.registerLinkTarget(iRubyObject);
            marshalStream.dumpVariables(iRubyObject.getVariableList());
        }

        public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject iRubyObject = rubyClass.allocate();
            unmarshalStream.registerLinkTarget(iRubyObject);
            unmarshalStream.defaultVariablesUnmarshal(iRubyObject);
            return iRubyObject;
        }
    };

    public static void createClassClass(Ruby ruby, RubyClass rubyClass) {
        rubyClass.index = 13;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyClass;
            }
        };
        rubyClass.undefineMethod("module_function");
        rubyClass.undefineMethod("append_features");
        rubyClass.undefineMethod("extend_object");
        rubyClass.defineAnnotatedMethods(RubyClass.class);
        rubyClass.addMethod("new", new SpecificArityNew(rubyClass, Visibility.PUBLIC));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator objectAllocator) {
        this.allocator = objectAllocator;
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject iRubyObject = this.allocator.allocate(this.runtime, this);
        if (iRubyObject.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return iRubyObject;
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public int getNativeTypeIndex() {
        return 13;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby ruby, String string, RubyClass rubyClass, ObjectAllocator objectAllocator) {
        RubyClass rubyClass2;
        if (rubyClass == null) {
            rubyClass2 = new RubyClass(ruby);
            rubyClass2.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            rubyClass2 = new RubyClass(ruby, rubyClass);
        }
        rubyClass2.setAllocator(objectAllocator);
        rubyClass2.setBaseName(string);
        return rubyClass2;
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, ruby.getClassClass(), bl);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = new CallSite.InlineCachingCallSite(CS_NAMES[i], CallType.FUNCTIONAL);
        }
        this.runtime = ruby;
        this.superClass = rubyClass;
    }

    protected RubyClass(Ruby ruby) {
        super(ruby, ruby.getClassClass());
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = new CallSite.InlineCachingCallSite(CS_NAMES[i], CallType.FUNCTIONAL);
        }
        this.runtime = ruby;
        this.index = 13;
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass) {
        this(ruby);
        this.superClass = rubyClass;
        this.marshal = rubyClass.marshal;
        rubyClass.addSubclass(this);
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby ruby, RubyClass rubyClass, CallSite[] callSiteArray) {
        this(ruby);
        this.superClass = rubyClass;
        this.marshal = rubyClass.marshal;
        rubyClass.addSubclass(this);
        this.extraCallSites = callSiteArray;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass) {
        if (rubyClass == ruby.getClassClass()) {
            throw ruby.newTypeError("can't make subclass of Class");
        }
        if (rubyClass.isSingleton()) {
            throw ruby.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(ruby, rubyClass);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass, CallSite[] callSiteArray) {
        if (rubyClass == ruby.getClassClass()) {
            throw ruby.newTypeError("can't make subclass of Class");
        }
        if (rubyClass.isSingleton()) {
            throw ruby.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(ruby, rubyClass, callSiteArray);
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass, String string, ObjectAllocator objectAllocator, RubyModule rubyModule, boolean bl) {
        RubyClass rubyClass2 = RubyClass.newClass(ruby, rubyClass);
        rubyClass2.setBaseName(string);
        rubyClass2.setAllocator(objectAllocator);
        rubyClass2.makeMetaClass(rubyClass.getMetaClass());
        if (bl) {
            rubyClass2.setParent(rubyModule);
        }
        rubyModule.setConstant(string, rubyClass2);
        rubyClass2.inherit(rubyClass);
        return rubyClass2;
    }

    public static RubyClass newClass(Ruby ruby, RubyClass rubyClass, String string, ObjectAllocator objectAllocator, RubyModule rubyModule, boolean bl, CallSite[] callSiteArray) {
        RubyClass rubyClass2 = RubyClass.newClass(ruby, rubyClass, callSiteArray);
        rubyClass2.setBaseName(string);
        rubyClass2.setAllocator(objectAllocator);
        rubyClass2.makeMetaClass(rubyClass.getMetaClass());
        if (bl) {
            rubyClass2.setParent(rubyModule);
        }
        rubyModule.setConstant(string, rubyClass2);
        rubyClass2.inherit(rubyClass);
        return rubyClass2;
    }

    public RubyClass makeMetaClass(RubyClass rubyClass) {
        if (this.isSingleton()) {
            MetaClass metaClass = new MetaClass(this.getRuntime(), rubyClass);
            this.setMetaClass(metaClass);
            metaClass.setAttached(this);
            metaClass.setMetaClass(metaClass);
            metaClass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return metaClass;
        }
        return super.makeMetaClass(rubyClass);
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, int n, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        return this.invoke(threadContext, iRubyObject, string, iRubyObjectArray, callType, block);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject, CallType callType) {
        return !dynamicMethod.isCallableFrom(iRubyObject, callType) && !string.equals("method_missing");
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, CallType callType, Block block) {
        IRubyObject iRubyObject2;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject2 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, block);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, threadContext.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        IRubyObject iRubyObject2;
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject2 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, iRubyObject2, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObjectArray, block);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, threadContext.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObjectArray, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        IRubyObject iRubyObject3;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject3 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, block);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, Block block) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, threadContext.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, CallType callType, Block block) {
        IRubyObject iRubyObject4;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject4 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3, block);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, threadContext.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, CallType callType, Block block) {
        IRubyObject iRubyObject5;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject5 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, this, string, iRubyObject2, iRubyObject3, iRubyObject4, block);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, threadContext.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, this, string, iRubyObject2, iRubyObject3, iRubyObject4, block);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, CallType callType) {
        IRubyObject iRubyObject2;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject2 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, callType, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, this, string);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, this, string);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, CallType callType) {
        IRubyObject iRubyObject2;
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject2 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, iRubyObject2, callType, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObjectArray);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray) {
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObjectArray);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, CallType callType) {
        IRubyObject iRubyObject3;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject3 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, callType, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, CallType callType) {
        IRubyObject iRubyObject4;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject4 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, callType, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3);
    }

    public IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, CallType callType) {
        IRubyObject iRubyObject5;
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod, string, iRubyObject5 = threadContext.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5, callType, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3, iRubyObject4);
    }

    public IRubyObject finvoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        DynamicMethod dynamicMethod = this.searchMethod(string);
        if (this.shouldCallMethodMissing(dynamicMethod)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObject2, iRubyObject3, iRubyObject4, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this, string, iRubyObject2, iRubyObject3, iRubyObject4);
    }

    private boolean shouldCallMethodMissing(DynamicMethod dynamicMethod) {
        return dynamicMethod.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject, CallType callType) {
        return dynamicMethod.isUndefined() || this.notVisibleAndNotMethodMissing(dynamicMethod, string, iRubyObject, callType);
    }

    public IRubyObject invokeInherited(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        DynamicMethod dynamicMethod = this.getMetaClass().searchMethod("inherited");
        if (dynamicMethod.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, "inherited", iRubyObject2, threadContext.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)this.getMetaClass(), "inherited", iRubyObject2, Block.NULL_BLOCK);
    }

    public IRubyObject newInstance(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject = this.allocate();
        this.baseCallSites[0].call(threadContext, iRubyObject, iRubyObjectArray, block);
        return iRubyObject;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (this.superClass != null) {
            throw this.getRuntime().newTypeError("already initialized class");
        }
        if (iRubyObjectArray.length == 0) {
            iRubyObject = this.getRuntime().getObject();
        } else {
            iRubyObject = iRubyObjectArray[0];
            RubyClass.checkInheritable(iRubyObject);
        }
        IRubyObject iRubyObject2 = iRubyObject;
        this.superClass = iRubyObject2;
        this.allocator = ((RubyClass)iRubyObject2).allocator;
        this.makeMetaClass(((RubyObject)iRubyObject2).getMetaClass());
        this.marshal = ((RubyClass)iRubyObject2).marshal;
        ((RubyClass)iRubyObject2).addSubclass(this);
        super.initialize(block);
        this.inherit((RubyClass)iRubyObject2);
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
        if (iRubyObject instanceof MetaClass) {
            throw this.getRuntime().newTypeError("can't copy singleton class");
        }
        super.initialize_copy(iRubyObject);
        this.allocator = ((RubyClass)iRubyObject).allocator;
        return this;
    }

    public IRubyObject subclasses(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        boolean bl = false;
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyBoolean) {
                bl = iRubyObjectArray[0].isTrue();
            } else {
                threadContext.getRuntime().newTypeError(iRubyObjectArray[0], threadContext.getRuntime().fastGetClass("Boolean"));
            }
        }
        return RubyArray.newArray(threadContext.getRuntime(), this.subclasses(bl)).freeze(threadContext);
    }

    public Collection subclasses(boolean bl) {
        if (this.subclasses != null) {
            ArrayList<RubyClass> arrayList = new ArrayList<RubyClass>(this.subclasses);
            if (bl) {
                for (RubyClass rubyClass : this.subclasses) {
                    arrayList.addAll(rubyClass.subclasses(bl));
                }
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addSubclass(RubyClass rubyClass) {
        if (this.subclasses == null) {
            this.subclasses = new WeakHashSet<RubyClass>();
        }
        this.subclasses.add(rubyClass);
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1)
    public IRubyObject inherited(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().getNil();
    }

    public void inherit(RubyClass rubyClass) {
        if (rubyClass == null) {
            rubyClass = this.getRuntime().getObject();
        }
        rubyClass.invokeInherited(this.getRuntime().getCurrentContext(), rubyClass, this);
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass(ThreadContext threadContext) {
        RubyClass rubyClass = this.superClass;
        if (rubyClass == null) {
            throw threadContext.getRuntime().newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            rubyClass = this.metaClass;
        }
        while (rubyClass != null && rubyClass.isIncluded()) {
            rubyClass = rubyClass.superClass;
        }
        return rubyClass != null ? rubyClass : threadContext.getRuntime().getNil();
    }

    public static void checkInheritable(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyClass)) {
            throw iRubyObject.getRuntime().newTypeError("superclass must be a Class (" + iRubyObject.getMetaClass() + " given)");
        }
        if (((RubyClass)iRubyObject).isSingleton()) {
            throw iRubyObject.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal objectMarshal) {
        this.marshal = objectMarshal;
    }

    public final void marshal(Object object, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.getRuntime(), object, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.getRuntime(), this, unmarshalStream);
    }

    public static void marshalTo(RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyClass);
        marshalStream.writeString(MarshalStream.getPathFromClass(rubyClass));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        String string = RubyString.byteListToString(unmarshalStream.unmarshalString());
        RubyClass rubyClass = UnmarshalStream.getClassFromPath(unmarshalStream.getRuntime(), string);
        unmarshalStream.registerLinkTarget(rubyClass);
        return rubyClass;
    }

    public static class SpecificArityNew
    extends JavaMethod {
        public SpecificArityNew(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            IRubyObject iRubyObject2 = rubyClass.allocate();
            rubyClass.baseCallSites[0].call(threadContext, iRubyObject2, iRubyObjectArray, block);
            return iRubyObject2;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            IRubyObject iRubyObject2 = rubyClass.allocate();
            rubyClass.baseCallSites[0].call(threadContext, iRubyObject2, block);
            return iRubyObject2;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            IRubyObject iRubyObject3 = rubyClass.allocate();
            rubyClass.baseCallSites[0].call(threadContext, iRubyObject3, iRubyObject2, block);
            return iRubyObject3;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            IRubyObject iRubyObject4 = rubyClass.allocate();
            rubyClass.baseCallSites[0].call(threadContext, iRubyObject4, iRubyObject2, iRubyObject3, block);
            return iRubyObject4;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            RubyClass rubyClass = (RubyClass)iRubyObject;
            IRubyObject iRubyObject5 = rubyClass.allocate();
            rubyClass.baseCallSites[0].call(threadContext, iRubyObject5, iRubyObject2, iRubyObject3, iRubyObject4, block);
            return iRubyObject5;
        }
    }
}

